/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.util.TimeMeasurement;

public class ExecTimeTelemetryData {
    private final TimeMeasurement query = new TimeMeasurement();
    private final TimeMeasurement bind = new TimeMeasurement();
    private final TimeMeasurement gzip = new TimeMeasurement();
    private final TimeMeasurement httpClient = new TimeMeasurement();
    private final TimeMeasurement responseIOStream = new TimeMeasurement();
    private final TimeMeasurement processResultChunk = new TimeMeasurement();
    private final TimeMeasurement createResultSet = new TimeMeasurement();
    private String batchId;
    private String queryId;
    private String queryFunction;
    private int retryCount = 0;
    private String retryLocations = "";
    private Boolean ocspEnabled = false;
    boolean sendData = true;
    private String requestId;

    public ExecTimeTelemetryData(String queryFunction, String batchId) {
        this.query.setStart();
        this.queryFunction = queryFunction;
        this.batchId = batchId;
        if (!TelemetryService.getInstance().isHTAPEnabled()) {
            this.sendData = false;
        }
    }

    public ExecTimeTelemetryData() {
        this.sendData = false;
    }

    public void setBindStart() {
        this.bind.setStart();
    }

    public void setOCSPStatus(Boolean ocspEnabled) {
        this.ocspEnabled = ocspEnabled;
    }

    public void setBindEnd() {
        this.bind.setEnd();
    }

    public void setHttpClientStart() {
        this.httpClient.setStart();
    }

    public void setHttpClientEnd() {
        this.httpClient.setEnd();
    }

    public void setGzipStart() {
        this.gzip.setStart();
    }

    public void setGzipEnd() {
        this.gzip.setEnd();
    }

    public void setQueryEnd() {
        this.query.setEnd();
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setProcessResultChunkStart() {
        this.processResultChunk.setStart();
    }

    public void setProcessResultChunkEnd() {
        this.processResultChunk.setEnd();
    }

    public void setResponseIOStreamStart() {
        this.responseIOStream.setStart();
    }

    public void setResponseIOStreamEnd() {
        this.responseIOStream.setEnd();
    }

    public void setCreateResultSetStart() {
        this.createResultSet.setStart();
    }

    public void setCreateResultSetEnd() {
        this.createResultSet.setEnd();
    }

    public void incrementRetryCount() {
        ++this.retryCount;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void addRetryLocation(String location) {
        this.retryLocations = SnowflakeUtil.isNullOrEmpty(this.retryLocations) ? location : this.retryLocations.concat(", ").concat(location);
    }

    long getTotalQueryTime() {
        return this.query.getTime();
    }

    long getResultProcessingTime() {
        if (this.createResultSet.getEnd() == 0L || this.processResultChunk.getStart() == 0L) {
            return -1L;
        }
        return this.createResultSet.getEnd() - this.processResultChunk.getStart();
    }

    long getHttpRequestTime() {
        return this.httpClient.getTime();
    }

    long getResultSetCreationTime() {
        return this.createResultSet.getTime();
    }

    public String generateTelemetry() {
        if (this.sendData) {
            String eventType = "ExecutionTimeRecord";
            JSONObject value = new JSONObject();
            value.put("eventType", eventType);
            value.put("QueryStart", this.query.getStart());
            value.put("BindStart", this.bind.getStart());
            value.put("BindEnd", this.bind.getEnd());
            value.put("GzipStart", this.gzip.getStart());
            value.put("GzipEnd", this.gzip.getEnd());
            value.put("HttpClientStart", this.httpClient.getStart());
            value.put("HttpClientEnd", this.httpClient.getEnd());
            value.put("ResponseIOStreamStart", this.responseIOStream.getStart());
            value.put("ResponseIOStreamEnd", this.responseIOStream.getEnd());
            value.put("ProcessResultChunkStart", this.processResultChunk.getStart());
            value.put("ProcessResultChunkEnd", this.processResultChunk.getEnd());
            value.put("CreateResultSetStart", this.createResultSet.getStart());
            value.put("CreateResultSetEnd", this.createResultSet.getEnd());
            value.put("QueryEnd", this.query.getEnd());
            value.put("BatchID", this.batchId);
            value.put("QueryID", this.queryId);
            value.put("RequestID", this.requestId);
            value.put("QueryFunction", this.queryFunction);
            value.put("RetryCount", this.retryCount);
            value.put("RetryLocations", this.retryLocations);
            value.put("ocspEnabled", this.ocspEnabled);
            value.put("ElapsedQueryTime", this.getTotalQueryTime());
            value.put("ElapsedResultProcessTime", this.getResultProcessingTime());
            value.put("Urgent", true);
            String valueStr = value.toString();
            TelemetryService.getInstance().logExecutionTimeTelemetryEvent(value, eventType);
            return valueStr;
        }
        return "";
    }

    @SnowflakeJdbcInternalApi
    public String getLogString() {
        return "Query id: " + this.queryId + ", query function: " + this.queryFunction + ", batch id: " + this.batchId + ", request id: " + this.requestId + ", total query time: " + this.getTotalQueryTime() / 1000L + " ms, result processing time: " + this.getResultProcessingTime() / 1000L + " ms, result set creation time: " + this.getResultSetCreationTime() / 1000L + " ms, http request time: " + this.getHttpRequestTime() / 1000L + " ms, retry count: " + this.retryCount;
    }
}

