/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.alts;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.grpc.Channel;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.ServerCredentials;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.alts.AltsChannelCredentials;
import net.snowflake.client.jdbc.internal.grpc.alts.HandshakerServiceChannel;
import net.snowflake.client.jdbc.internal.grpc.alts.InternalCheckGcpEnvironment;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.AltsProtocolNegotiator;
import net.snowflake.client.jdbc.internal.grpc.internal.ObjectPool;
import net.snowflake.client.jdbc.internal.grpc.internal.SharedResourcePool;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.InternalNettyServerCredentials;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsServerCredentials {
    private static final Logger logger = Logger.getLogger(AltsServerCredentials.class.getName());

    private AltsServerCredentials() {
    }

    public static ServerCredentials create() {
        return AltsServerCredentials.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
    public static final class Builder {
        private ObjectPool<Channel> handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
        private boolean enableUntrustedAlts;

        public Builder enableUntrustedAltsForTesting() {
            this.enableUntrustedAlts = true;
            return this;
        }

        public Builder setHandshakerAddressForTesting(String handshakerAddress) {
            this.handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.getHandshakerChannelForTesting(handshakerAddress));
            return this;
        }

        public ServerCredentials build() {
            return InternalNettyServerCredentials.create(this.buildProtocolNegotiator());
        }

        InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator() {
            if (!InternalCheckGcpEnvironment.isOnGcp()) {
                if (this.enableUntrustedAlts) {
                    logger.log(Level.WARNING, "Untrusted ALTS mode is enabled and we cannot guarantee the trustworthiness of the ALTS handshaker service");
                } else {
                    Status status = Status.INTERNAL.withDescription("ALTS is only allowed to run on Google Cloud Platform");
                    return new AltsChannelCredentials.FailingProtocolNegotiator(status);
                }
            }
            return AltsProtocolNegotiator.serverAltsProtocolNegotiator(this.handshakerChannelPool);
        }
    }
}

