/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.util;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x500.X500Name;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.X509CertificateHolder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.ContentSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

final class BouncyCastleSelfSignedCertGenerator {
    private static final Provider PROVIDER;

    static String[] generate(String fqdn, KeyPair keypair, SecureRandom random, Date notBefore, Date notAfter, String algorithm) throws Exception {
        PrivateKey key = keypair.getPrivate();
        X500Name owner = new X500Name("CN=" + fqdn);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, random), notBefore, notAfter, owner, keypair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder(algorithm.equalsIgnoreCase("EC") ? "SHA256withECDSA" : "SHA256WithRSAEncryption").build(key);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        return SelfSignedCertificate.newSelfSignedCertificate(fqdn, key, cert);
    }

    private BouncyCastleSelfSignedCertGenerator() {
    }

    static {
        Class<?> providerClass;
        try {
            providerClass = Class.forName("net.snowflake.client.jdbc.internal.org.bouncycastle.jce.provider.BouncyCastleProvider");
        }
        catch (ClassNotFoundException e) {
            try {
                providerClass = Class.forName("net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
            }
            catch (ClassNotFoundException ignore) {
                throw new RuntimeException("Neither BouncyCastleProvider nor BouncyCastleFipsProvider found");
            }
        }
        try {
            PROVIDER = (Provider)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate BouncyCastle provider", e);
        }
    }
}

