/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.RateLimiter;

public class ThrottlingLogger {
    private static final double RATE_LIMIT = 5.0;
    private static final double THROTTLED_RATE_LIMIT = 1.0;
    private static final TimeUnit rateTimeUnit = TimeUnit.MINUTES;
    private final Logger delegate;
    private final AtomicBoolean throttled = new AtomicBoolean(false);
    private final RateLimiter fastRateLimiter;
    private final RateLimiter throttledRateLimiter;

    public ThrottlingLogger(Logger delegate) {
        this(delegate, Clock.getDefault());
    }

    ThrottlingLogger(Logger delegate, Clock clock) {
        this.delegate = delegate;
        this.fastRateLimiter = new RateLimiter(5.0 / (double)rateTimeUnit.toSeconds(1L), 5.0, clock);
        this.throttledRateLimiter = new RateLimiter(5.0 / (double)rateTimeUnit.toSeconds(1L), 1.0, clock);
    }

    public void log(Level level, String message) {
        this.log(level, message, null);
    }

    public void log(Level level, String message, @Nullable Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (this.throttled.get()) {
            if (this.throttledRateLimiter.trySpend(1.0)) {
                this.doLog(level, message, throwable);
            }
            return;
        }
        if (this.fastRateLimiter.trySpend(1.0)) {
            this.doLog(level, message, throwable);
            return;
        }
        if (this.throttled.compareAndSet(false, true)) {
            this.throttledRateLimiter.trySpend(1.0);
            this.delegate.log(level, "Too many log messages detected. Will only log once per minute from now on.");
            this.doLog(level, message, throwable);
        }
    }

    private void doLog(Level level, String message, @Nullable Throwable throwable) {
        if (throwable != null) {
            this.delegate.log(level, message, throwable);
        } else {
            this.delegate.log(level, message);
        }
    }

    public boolean isLoggable(Level level) {
        return this.delegate.isLoggable(level);
    }
}

