/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtTokenSets;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/KotlinSingleClassFileAnalyzer;", "", "<init>", "()V", "isSingleClassFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getSingleClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "intellij.kotlin.base.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKotlinSingleClassFileAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSingleClassFileAnalyzer.kt\norg/jetbrains/kotlin/idea/base/util/KotlinSingleClassFileAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class KotlinSingleClassFileAnalyzer {
    @NotNull
    public static final KotlinSingleClassFileAnalyzer INSTANCE = new KotlinSingleClassFileAnalyzer();

    private KotlinSingleClassFileAnalyzer() {
    }

    @JvmStatic
    public static final boolean isSingleClassFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return KotlinSingleClassFileAnalyzer.getSingleClass(file) != null;
    }

    @JvmStatic
    @Nullable
    public static final KtClassOrObject getSingleClass(@NotNull KtFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!FileUtils.isFileInRoots(project, file.getVirtualFile())) {
            return null;
        }
        Ref.ObjectRef targetDeclaration = new Ref.ObjectRef();
        file.withGreenStubOrAst(arg_0 -> KotlinSingleClassFileAnalyzer.getSingleClass$lambda$0(targetDeclaration, arg_0), arg_0 -> KotlinSingleClassFileAnalyzer.getSingleClass$lambda$1(targetDeclaration, arg_0));
        KtDeclaration ktDeclaration = (KtDeclaration)targetDeclaration.element;
        if (ktDeclaration != null) {
            KtDeclaration ktDeclaration2;
            KtDeclaration it = ktDeclaration2 = ktDeclaration;
            boolean bl = false;
            object = it instanceof KtClassOrObject && Intrinsics.areEqual((Object)StringUtil.getPackageName((String)file.getName()), (Object)((KtClassOrObject)it).getName()) ? ktDeclaration2 : null;
        } else {
            object = null;
        }
        KtDeclaration ktDeclaration3 = object;
        return ktDeclaration3 instanceof KtClassOrObject ? (KtClassOrObject)ktDeclaration3 : null;
    }

    private static final boolean getSingleClass$handleDeclaration(Ref.ObjectRef<KtDeclaration> targetDeclaration, PsiElement psiElement) {
        KtDeclaration ktDeclaration = psiElement instanceof KtDeclaration ? (KtDeclaration)psiElement : null;
        if (ktDeclaration == null) {
            return true;
        }
        KtDeclaration declaration = ktDeclaration;
        if (!KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)declaration)) && !(declaration instanceof KtTypeAlias)) {
            if (targetDeclaration.element != null) {
                targetDeclaration.element = null;
                return false;
            }
            targetDeclaration.element = declaration;
        }
        return true;
    }

    private static final Unit getSingleClass$lambda$0(Ref.ObjectRef $targetDeclaration, PsiFileStub fileStub) {
        for (StubElement stubElement : fileStub.getChildrenStubs()) {
            IElementType elementType = stubElement.getElementType();
            if (Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.TYPEALIAS) || !KtTokenSets.DECLARATION_TYPES.contains(elementType) || KotlinSingleClassFileAnalyzer.getSingleClass$handleDeclaration((Ref.ObjectRef<KtDeclaration>)$targetDeclaration, stubElement.getPsi())) continue;
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit getSingleClass$lambda$1(Ref.ObjectRef $targetDeclaration, FileElement fileElement) {
        Intrinsics.checkNotNull((Object)fileElement);
        for (ASTNode node : PsiUtilsKt.children((ASTNode)((ASTNode)fileElement))) {
            if (KotlinSingleClassFileAnalyzer.getSingleClass$handleDeclaration((Ref.ObjectRef<KtDeclaration>)$targetDeclaration, node.getPsi())) continue;
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

