/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001d\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0003*\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0014\u0010\u0017\u001a\u00020\f*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/KotlinBigDecimalEqualsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/KotlinBigDecimalEqualsInspection$Context;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "isApplicableByPsi", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "isBigDecimal", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "Context", "Companion", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nKotlinBigDecimalEqualsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBigDecimalEqualsInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/KotlinBigDecimalEqualsInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class KotlinBigDecimalEqualsInspection
extends KotlinApplicableInspectionBase.Simple<KtExpression, Context>
implements CleanupLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ClassId bigDecimal = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"java/math/BigDecimal", (boolean)false, (int)2, null);
    @NotNull
    private static final CallableId bigDecimalEquals;

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return VisitorWrappersKt.expressionVisitor(arg_0 -> KotlinBigDecimalEqualsInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"big.decimal.equals.problem.descriptor", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtExpression> createQuickFix(@NotNull KtExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtExpression>(context2){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
            }

            public String getFamilyName() {
                return KotlinBundle.message((String)"big.decimal.equals", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtExpression element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtBinaryExpression) {
                    KtExpression ktExpression2 = ((KtBinaryExpression)element).getLeft();
                    Intrinsics.checkNotNull((Object)ktExpression2);
                    KtExpression ktExpression3 = ((KtBinaryExpression)element).getRight();
                    Intrinsics.checkNotNull((Object)ktExpression3);
                    String expressionString = this.expressionString(this.$context, ktExpression2, ktExpression3);
                    KtExpression compareToExpression = psiFactory.createExpression(expressionString);
                    v2 = ((KtBinaryExpression)element).replace((PsiElement)compareToExpression);
                } else if (ktExpression instanceof KtCallExpression) {
                    PsiElement psiElement = ((KtCallExpression)element).getParent();
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
                    KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)psiElement;
                    KtExpression receiverExpression = qualifiedExpression.getReceiverExpression();
                    KtExpression ktExpression4 = ((KtValueArgument)CollectionsKt.single((List)((KtCallExpression)element).getValueArguments())).getArgumentExpression();
                    Intrinsics.checkNotNull((Object)ktExpression4);
                    KtExpression argumentExpression = ktExpression4;
                    String expressionString = this.expressionString(this.$context, receiverExpression, argumentExpression);
                    KtExpression compareToExpression = psiFactory.createExpression("(" + expressionString + ")");
                    v2 = qualifiedExpression.replace((PsiElement)compareToExpression);
                } else {
                    return;
                }
            }

            private final String expressionString(Context context2, KtExpression left, KtExpression right) {
                StringBuilder stringBuilder;
                StringBuilder $this$expressionString_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                if (!context2.getNullableLeft() && !context2.getNullableRight()) {
                    $this$expressionString_u24lambda_u240.append(left.getText());
                    $this$expressionString_u24lambda_u240.append(".compareTo(");
                    $this$expressionString_u24lambda_u240.append(right.getText());
                    $this$expressionString_u24lambda_u240.append(") ");
                    $this$expressionString_u24lambda_u240.append(context2.getEquals() ? "==" : "!=");
                    v0 = $this$expressionString_u24lambda_u240.append(" 0");
                } else if (context2.getNullableLeft() && context2.getNullableRight()) {
                    $this$expressionString_u24lambda_u240.append(left.getText());
                    $this$expressionString_u24lambda_u240.append("?.let { ");
                    $this$expressionString_u24lambda_u240.append(right.getText());
                    $this$expressionString_u24lambda_u240.append("?.compareTo(it) ");
                    $this$expressionString_u24lambda_u240.append(context2.getEquals() ? "==" : "!=");
                    $this$expressionString_u24lambda_u240.append(" 0 } ?: (");
                    $this$expressionString_u24lambda_u240.append(right.getText());
                    v0 = $this$expressionString_u24lambda_u240.append(" == null)");
                } else {
                    String e1 = context2.getNullableLeft() ? left.getText() : right.getText();
                    String e2 = context2.getNullableLeft() ? right.getText() : left.getText();
                    $this$expressionString_u24lambda_u240.append(e1);
                    $this$expressionString_u24lambda_u240.append("?.compareTo(");
                    $this$expressionString_u24lambda_u240.append(e2);
                    $this$expressionString_u24lambda_u240.append(") ");
                    $this$expressionString_u24lambda_u240.append(context2.getEquals() ? "==" : "!=");
                    v0 = $this$expressionString_u24lambda_u240.append(" 0");
                }
                return stringBuilder.toString();
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableByPsi(@NotNull KtExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof KtBinaryExpression) {
            if (Intrinsics.areEqual((Object)((KtBinaryExpression)element).getOperationToken(), (Object)KtTokens.EQEQ)) return true;
            if (Intrinsics.areEqual((Object)((KtBinaryExpression)element).getOperationToken(), (Object)KtTokens.EXCLEQ)) return true;
        }
        if (!(element instanceof KtCallExpression)) return false;
        if (((KtCallExpression)element).getValueArguments().size() != 1) return false;
        KtExpression ktExpression = ((KtCallExpression)element).getCalleeExpression();
        if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"equals")) return false;
        if (!(((KtCallExpression)element).getParent() instanceof KtQualifiedExpression)) return false;
        return true;
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtExpression element) {
        Context context2;
        block23: {
            block24: {
                KaType kaType;
                boolean nullableReceiverType;
                block26: {
                    block25: {
                        KaType kaType2;
                        KtExpression ktExpression;
                        block18: {
                            KaType kaType3;
                            KaType leftType;
                            block22: {
                                block21: {
                                    KaType it;
                                    KaType kaType4;
                                    KtExpression right;
                                    block20: {
                                        block19: {
                                            KaType kaType5;
                                            Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
                                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                            ktExpression = element;
                                            if (!(ktExpression instanceof KtBinaryExpression)) break block18;
                                            KtExpression ktExpression2 = ((KtBinaryExpression)element).getLeft();
                                            if (ktExpression2 == null) {
                                                return null;
                                            }
                                            KtExpression left = ktExpression2;
                                            KtExpression ktExpression3 = ((KtBinaryExpression)element).getRight();
                                            if (ktExpression3 == null) {
                                                return null;
                                            }
                                            right = ktExpression3;
                                            kaType4 = $this$prepareContext.getExpressionType(left);
                                            if (kaType4 == null) break block19;
                                            it = kaType5 = kaType4;
                                            boolean bl = false;
                                            kaType4 = this.isBigDecimal($this$prepareContext, it) ? kaType5 : null;
                                            if (kaType4 != null) break block20;
                                        }
                                        return null;
                                    }
                                    leftType = kaType4;
                                    kaType3 = $this$prepareContext.getExpressionType(right);
                                    if (kaType3 == null) break block21;
                                    KaType it2 = it = kaType3;
                                    boolean bl = false;
                                    kaType3 = this.isBigDecimal($this$prepareContext, it2) ? it : null;
                                    if (kaType3 != null) break block22;
                                }
                                return null;
                            }
                            KaType rightType = kaType3;
                            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)element).getOperationReference();
                            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
                            KaLifetimeOwner kaLifetimeOwner = $this$prepareContext.resolveToCall((KtElement)ktOperationReferenceExpression);
                            if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull(kaLifetimeOwner)) == null || (kaLifetimeOwner = (KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)kaLifetimeOwner)) == null || (kaLifetimeOwner = ((KaCallableSymbol)kaLifetimeOwner).getCallableId()) == null) {
                                return null;
                            }
                            KaLifetimeOwner operatorCallableId = kaLifetimeOwner;
                            if (!Intrinsics.areEqual((Object)operatorCallableId, (Object)bigDecimalEquals)) {
                                return null;
                            }
                            boolean nullableLeft = $this$prepareContext.isMarkedNullable(leftType);
                            boolean nullableRight = $this$prepareContext.isMarkedNullable(rightType);
                            context2 = new Context(nullableLeft, nullableRight, Intrinsics.areEqual((Object)((KtBinaryExpression)element).getOperationToken(), (Object)KtTokens.EQEQ));
                            break block23;
                        }
                        if (!(ktExpression instanceof KtCallExpression)) break block24;
                        PsiElement leftType = ((KtCallExpression)element).getParent();
                        KtQualifiedExpression ktQualifiedExpression = leftType instanceof KtQualifiedExpression ? (KtQualifiedExpression)leftType : null;
                        if (ktQualifiedExpression == null) {
                            return null;
                        }
                        KtQualifiedExpression expression = ktQualifiedExpression;
                        KaType kaType6 = $this$prepareContext.getExpressionType(expression.getReceiverExpression());
                        boolean bl = kaType6 != null ? $this$prepareContext.isMarkedNullable(kaType6) : (nullableReceiverType = false);
                        KtExpression calleeExpression = ((KtCallExpression)element).getCalleeExpression();
                        Object object = calleeExpression;
                        if (object == null || (object = $this$prepareContext.resolveToCall((KtElement)object)) == null || (object = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)object)) == null) {
                            return null;
                        }
                        Object call2 = object;
                        if (!Intrinsics.areEqual((Object)((KaCallableSymbol)KaCallKt.getSymbol((KaCallableMemberCall)call2)).getCallableId(), (Object)bigDecimalEquals)) {
                            return null;
                        }
                        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)((KtCallExpression)element).getValueArguments());
                        if (ktValueArgument == null) {
                            return null;
                        }
                        KtValueArgument singleArgument = ktValueArgument;
                        KtExpression ktExpression4 = singleArgument.getArgumentExpression();
                        if (ktExpression4 == null) {
                            return null;
                        }
                        KtExpression argumentExpression = ktExpression4;
                        kaType = $this$prepareContext.getExpressionType(argumentExpression);
                        if (kaType == null) break block25;
                        KaType it = kaType2 = kaType;
                        boolean bl2 = false;
                        kaType = this.isBigDecimal($this$prepareContext, it) ? kaType2 : null;
                        if (kaType != null) break block26;
                    }
                    return null;
                }
                KaType argumentType = kaType;
                context2 = new Context(nullableReceiverType, $this$prepareContext.isMarkedNullable(argumentType), true);
                break block23;
            }
            context2 = null;
        }
        return context2;
    }

    private final boolean isBigDecimal(KaSession $this$isBigDecimal, KaType type2) {
        KaType kaType = $this$isBigDecimal.upperBoundIfFlexible(type2);
        KaClassType kaClassType = kaType instanceof KaClassType ? (KaClassType)kaType : null;
        return Intrinsics.areEqual((Object)(kaClassType != null ? kaClassType.getClassId() : null), (Object)bigDecimal);
    }

    private static final Unit buildVisitor$lambda$0(KotlinBigDecimalEqualsInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    static {
        Name name2 = Name.identifier((String)"equals");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        bigDecimalEquals = new CallableId(bigDecimal, name2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/KotlinBigDecimalEqualsInspection$Companion;", "", "<init>", "()V", "bigDecimal", "Lorg/jetbrains/kotlin/name/ClassId;", "bigDecimalEquals", "Lorg/jetbrains/kotlin/name/CallableId;", "kotlin.code-insight.inspections.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/KotlinBigDecimalEqualsInspection$Context;", "", "nullableLeft", "", "nullableRight", "equals", "<init>", "(ZZZ)V", "getNullableLeft", "()Z", "getNullableRight", "getEquals", "kotlin.code-insight.inspections.shared"})
    public static final class Context {
        private final boolean nullableLeft;
        private final boolean nullableRight;
        private final boolean equals;

        public Context(boolean nullableLeft, boolean nullableRight, boolean equals) {
            this.nullableLeft = nullableLeft;
            this.nullableRight = nullableRight;
            this.equals = equals;
        }

        public final boolean getNullableLeft() {
            return this.nullableLeft;
        }

        public final boolean getNullableRight() {
            return this.nullableRight;
        }

        public final boolean getEquals() {
            return this.equals;
        }
    }
}

