/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.EntryUpdateDiff;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.MultiDollarConversionInfo;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.PrefixedStringTemplateUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.StringTemplateEntryUpdateInfo;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringInterpolationPrefix;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a8\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u001a\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002\u001a*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f*\u00020 2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u001a\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f*\u00020 2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f*\u00020 H\u0002\u001a\u0014\u0010#\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a\n\u0010$\u001a\u00020\u000f*\u00020 \u001a\n\u0010%\u001a\u00020\u000f*\u00020&\u001a\n\u0010'\u001a\u00020\u000f*\u00020\u0017\u001a\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001f*\u00020\f2\u0006\u0010*\u001a\u00020\u000f\u001a\u0018\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u000f\u001a\u001f\u0010/\u001a\u0004\u0018\u00010\u00032\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u00100\u001a\u0016\u00101\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u00102\u001a\u00020,\u001a\u000e\u00103\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f\u001a\u0014\u00104\u001a\u00020\u0007*\u00020\f2\u0006\u00105\u001a\u00020\u000fH\u0002\u001a\u000e\u00106\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f\u001a\u000e\u00107\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\f\u001a\u001a\u00108\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\f2\b\b\u0002\u00109\u001a\u00020\u0003H\u0002\u001a\u001a\u0010:\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\f2\b\b\u0002\u00109\u001a\u00020\u0003H\u0002\u001a\f\u0010;\u001a\u00020\u000f*\u00020\u001cH\u0002\u001a\u0018\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002\u001a\f\u0010'\u001a\u00020\u000f*\u00020>H\u0002\u001a\u0014\u0010?\u001a\u00020\u000f*\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003H\u0002\u001a\f\u0010@\u001a\u00020\u0003*\u00020\u0017H\u0002\u001a\"\u0010I\u001a\u00020\f*\u00020J2\u0006\u0010K\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\"\u0018\u0010A\u001a\u00020\u0003*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\"\u0015\u0010D\u001a\u00020\u0003*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010F\"\u0015\u0010G\u001a\u00020\u0003*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010F\u00a8\u0006M"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DEFAULT_INTERPOLATION_PREFIX_LENGTH", "", "INTERPOLATION_PREFIX_LENGTH_THRESHOLD", "dollarLiteralExpressions", "", "", "getDollarLiteralExpressions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "changeInterpolationPrefix", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "newPrefixLength", "isSourceSingleQuoted", "", "isDestinationSingleQuoted", "onEntryUpdate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/StringTemplateEntryUpdateInfo;", "", "asOneToOneDiff", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/EntryUpdateDiff;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "newText", "changePrefixLength", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntryWithExpression;", "prefixLength", "Lorg/jetbrains/kotlin/psi/KtBlockStringTemplateEntry;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameStringTemplateEntry;", "escapeIfNecessary", "", "Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "escapeDollarIfNecessary", "escapeSpecialCharacters", "unescapeIfPossible", "canBeConsideredIdentifierOrBlock", "canBeStartOfIdentifierOrBlock", "", "isEscapedDollar", "findTextRangesInParentForEscapedDollars", "Lcom/intellij/openapi/util/TextRange;", "includeUnsafe", "prepareMultiDollarConversionInfo", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/MultiDollarConversionInfo;", "element", "useFallbackPrefix", "findSuitablePrefixLength", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Z)Ljava/lang/Integer;", "convertToMultiDollarString", "contextInfo", "convertToStringWithoutPrefix", "toEscapedText", "isSingleQuoted", "simplifyDollarEntries", "findPrefixLengthForPlainTextConversion", "longestUnsafeDollarSequenceLengthForConservativeConversion", "threshold", "longestUnsafeDollarSequenceLengthForPlainTextConversion", "isInterpolatedDollarLiteralExpression", "replaceExpressionEntries", "stringTemplate", "Lorg/jetbrains/kotlin/psi/KtEscapeStringTemplateEntry;", "isSafeToReplaceWithDollar", "countTrailingDollarsInPreviousEntries", "trailingDollarsLength", "getTrailingDollarsLength", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;)I", "templatePrefixLength", "getTemplatePrefixLength", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)I", "entryPrefixLength", "getEntryPrefixLength", "createStringTemplate", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "content", "isRaw", "intellij.kotlin.codeInsight.shared"})
@SourceDebugExtension(value={"SMAP\nPrefixedStringTemplateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrefixedStringTemplateUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/PrefixedStringTemplateUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,532:1\n1#2:533\n1563#3:534\n1634#3,3:535\n1563#3:543\n1634#3,3:544\n1069#4,2:538\n1069#4,2:547\n1069#4,2:549\n621#4,6:551\n621#4,6:557\n3919#5:540\n4434#5,2:541\n13#6:563\n*S KotlinDebug\n*F\n+ 1 PrefixedStringTemplateUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/PrefixedStringTemplateUtilsKt\n*L\n53#1:534\n53#1:535,3\n261#1:543\n261#1:544,3\n149#1:538,2\n409#1:547,2\n451#1:549,2\n498#1:551,6\n508#1:557,6\n259#1:540\n259#1:541,2\n14#1:563\n*E\n"})
public final class PrefixedStringTemplateUtilsKt {
    @NotNull
    private static final Logger LOG;
    private static final int DEFAULT_INTERPOLATION_PREFIX_LENGTH = 2;
    private static final int INTERPOLATION_PREFIX_LENGTH_THRESHOLD = 5;
    @NotNull
    private static final String[] dollarLiteralExpressions;

    @NotNull
    public static final String[] getDollarLiteralExpressions() {
        return dollarLiteralExpressions;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtStringTemplateExpression changeInterpolationPrefix(@NotNull KtStringTemplateExpression $this$changeInterpolationPrefix, int newPrefixLength, boolean isSourceSingleQuoted, boolean isDestinationSingleQuoted, @NotNull Function1<? super StringTemplateEntryUpdateInfo, Unit> onEntryUpdate) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$changeInterpolationPrefix, (String)"<this>");
        Intrinsics.checkNotNullParameter(onEntryUpdate, (String)"onEntryUpdate");
        if (!(newPrefixLength >= 0)) {
            boolean $i$a$-require-PrefixedStringTemplateUtilsKt$changeInterpolationPrefix$32 = false;
            String $i$a$-require-PrefixedStringTemplateUtilsKt$changeInterpolationPrefix$32 = "Unexpected string template prefix length: " + newPrefixLength;
            throw new IllegalArgumentException($i$a$-require-PrefixedStringTemplateUtilsKt$changeInterpolationPrefix$32.toString());
        }
        KtStringInterpolationPrefix ktStringInterpolationPrefix = $this$changeInterpolationPrefix.getInterpolationPrefix();
        boolean bl = ktStringInterpolationPrefix != null ? ktStringInterpolationPrefix.getTextLength() == newPrefixLength : false;
        if (bl) {
            return $this$changeInterpolationPrefix;
        }
        Project project = $this$changeInterpolationPrefix.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        StringBuilder $this$changeInterpolationPrefix_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = $this$changeInterpolationPrefix.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        KtStringTemplateEntry[] ktStringTemplateEntryArray2 = ktStringTemplateEntryArray;
        int n = ktStringTemplateEntryArray2.length;
        for (int j = 0; j < n; ++j) {
            List list2;
            int index2 = j;
            KtStringTemplateEntry entry = ktStringTemplateEntryArray2[j];
            int newPrefixLength2 = Math.max(newPrefixLength, 1);
            KtStringTemplateEntry ktStringTemplateEntry = entry;
            if (ktStringTemplateEntry instanceof KtStringTemplateEntryWithExpression) {
                KtStringTemplateEntry newEntry = PrefixedStringTemplateUtilsKt.unescapeIfPossible((KtStringTemplateEntry)PrefixedStringTemplateUtilsKt.changePrefixLength((KtStringTemplateEntryWithExpression)entry, newPrefixLength2), newPrefixLength2);
                String string = newEntry.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                list2 = CollectionsKt.listOf((Object)PrefixedStringTemplateUtilsKt.asOneToOneDiff(entry, string));
            } else if (ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry) {
                list2 = PrefixedStringTemplateUtilsKt.escapeIfNecessary((KtLiteralStringTemplateEntry)entry, newPrefixLength2, isSourceSingleQuoted, isDestinationSingleQuoted);
            } else if (ktStringTemplateEntry instanceof KtEscapeStringTemplateEntry) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = CollectionsKt.listOf((Object)PrefixedStringTemplateUtilsKt.unescapeIfPossible(entry, newPrefixLength2));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void unescapedEntry;
                    KtStringTemplateEntry ktStringTemplateEntry2 = (KtStringTemplateEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    String string = unescapedEntry.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    collection.add(PrefixedStringTemplateUtilsKt.asOneToOneDiff(entry, string));
                }
                list2 = (List)destination$iv$iv;
            } else {
                Intrinsics.checkNotNull((Object)entry);
                String string = entry.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                list2 = CollectionsKt.listOf((Object)PrefixedStringTemplateUtilsKt.asOneToOneDiff(entry, string));
            }
            List newEntries = list2;
            String newText = CollectionsKt.joinToString$default((Iterable)newEntries, (CharSequence)"", null, null, (int)0, null, PrefixedStringTemplateUtilsKt::changeInterpolationPrefix$lambda$2$1, (int)30, null);
            $this$changeInterpolationPrefix_u24lambda_u242.append(newText);
            if (Intrinsics.areEqual((Object)newText, (Object)entry.getText())) continue;
            Intrinsics.checkNotNull((Object)entry);
            onEntryUpdate.invoke((Object)new StringTemplateEntryUpdateInfo(index2, entry, newEntries));
        }
        String contentText = stringBuilder.toString();
        return newPrefixLength != 0 ? factory2.createMultiDollarStringTemplate(contentText, newPrefixLength, !isDestinationSingleQuoted) : (isDestinationSingleQuoted ? factory2.createStringTemplate(contentText) : factory2.createRawStringTemplate(contentText));
    }

    public static /* synthetic */ KtStringTemplateExpression changeInterpolationPrefix$default(KtStringTemplateExpression ktStringTemplateExpression, int n, boolean bl, boolean bl2, Function1 function1, int n2, Object object) {
        if ((n2 & 8) != 0) {
            function1 = PrefixedStringTemplateUtilsKt::changeInterpolationPrefix$lambda$0;
        }
        return PrefixedStringTemplateUtilsKt.changeInterpolationPrefix(ktStringTemplateExpression, n, bl, bl2, (Function1<? super StringTemplateEntryUpdateInfo, Unit>)function1);
    }

    private static final EntryUpdateDiff asOneToOneDiff(KtStringTemplateEntry $this$asOneToOneDiff, String newText) {
        IntRange intRange = RangesKt.until((int)0, (int)$this$asOneToOneDiff.getTextLength());
        String string = $this$asOneToOneDiff.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new EntryUpdateDiff(intRange, string, newText);
    }

    private static final KtStringTemplateEntryWithExpression changePrefixLength(KtStringTemplateEntryWithExpression $this$changePrefixLength, int prefixLength) {
        if (!(prefixLength > 0)) {
            boolean bl = false;
            String string = "Unexpected string template prefix length: " + prefixLength;
            throw new IllegalArgumentException(string.toString());
        }
        KtStringTemplateEntryWithExpression ktStringTemplateEntryWithExpression = $this$changePrefixLength;
        KtStringTemplateEntryWithExpression replacement = ktStringTemplateEntryWithExpression instanceof KtSimpleNameStringTemplateEntry ? (KtStringTemplateEntryWithExpression)PrefixedStringTemplateUtilsKt.changePrefixLength((KtSimpleNameStringTemplateEntry)$this$changePrefixLength, prefixLength) : (ktStringTemplateEntryWithExpression instanceof KtBlockStringTemplateEntry ? PrefixedStringTemplateUtilsKt.changePrefixLength((KtBlockStringTemplateEntry)$this$changePrefixLength, prefixLength) : $this$changePrefixLength);
        return replacement;
    }

    private static final KtStringTemplateEntryWithExpression changePrefixLength(KtBlockStringTemplateEntry $this$changePrefixLength, int prefixLength) {
        KtStringTemplateEntryWithExpression ktStringTemplateEntryWithExpression;
        if (!(prefixLength > 0)) {
            boolean $i$a$-require-PrefixedStringTemplateUtilsKt$changePrefixLength$32 = false;
            String $i$a$-require-PrefixedStringTemplateUtilsKt$changePrefixLength$32 = "Unexpected string template entry prefix length: " + prefixLength;
            throw new IllegalArgumentException($i$a$-require-PrefixedStringTemplateUtilsKt$changePrefixLength$32.toString());
        }
        Project project = $this$changePrefixLength.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        KtExpression expression = $this$changePrefixLength.getExpression();
        if (expression != null) {
            ktStringTemplateEntryWithExpression = ktPsiFactory.createMultiDollarBlockStringTemplateEntry(expression, prefixLength);
        } else {
            String prefix2 = StringsKt.repeat((CharSequence)"$", (int)prefixLength);
            KtExpression incompleteExpression = ktPsiFactory.createExpression(prefix2 + "\"" + prefix2 + "{}\"");
            Intrinsics.checkNotNull((Object)incompleteExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
            KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)incompleteExpression).getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
            Object object = ArraysKt.single((Object[])ktStringTemplateEntryArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry");
            ktStringTemplateEntryWithExpression = (KtStringTemplateEntryWithExpression)((KtBlockStringTemplateEntry)object);
        }
        KtStringTemplateEntryWithExpression replacement = ktStringTemplateEntryWithExpression;
        return replacement;
    }

    private static final KtSimpleNameStringTemplateEntry changePrefixLength(KtSimpleNameStringTemplateEntry $this$changePrefixLength, int prefixLength) {
        if (!(prefixLength > 0)) {
            boolean bl = false;
            String string = "Unexpected string template entry prefix length: " + prefixLength;
            throw new IllegalArgumentException(string.toString());
        }
        Project project = $this$changePrefixLength.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        KtExpression ktExpression = $this$changePrefixLength.getExpression();
        String string = ktExpression != null ? ktExpression.getText() : null;
        if (string == null) {
            string = "";
        }
        return ktPsiFactory.createMultiDollarSimpleNameStringTemplateEntry(string, prefixLength);
    }

    private static final List<EntryUpdateDiff> escapeIfNecessary(KtLiteralStringTemplateEntry $this$escapeIfNecessary, int newPrefixLength, boolean isSourceSingleQuoted, boolean isDestinationSingleQuoted) {
        boolean bl;
        block3: {
            String string = $this$escapeIfNecessary.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence $this$all$iv = string;
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char ch = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (ch == '$') continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            return PrefixedStringTemplateUtilsKt.escapeDollarIfNecessary($this$escapeIfNecessary, newPrefixLength, isDestinationSingleQuoted);
        }
        if (!isSourceSingleQuoted && isDestinationSingleQuoted) {
            return PrefixedStringTemplateUtilsKt.escapeSpecialCharacters($this$escapeIfNecessary);
        }
        KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)$this$escapeIfNecessary;
        String string = $this$escapeIfNecessary.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return CollectionsKt.listOf((Object)PrefixedStringTemplateUtilsKt.asOneToOneDiff(ktStringTemplateEntry, string));
    }

    private static final List<EntryUpdateDiff> escapeDollarIfNecessary(KtLiteralStringTemplateEntry $this$escapeDollarIfNecessary, int newPrefixLength, boolean isDestinationSingleQuoted) {
        EntryUpdateDiff entryUpdateDiff;
        String it;
        String string;
        KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)$this$escapeDollarIfNecessary;
        String string2 = $this$escapeDollarIfNecessary.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        EntryUpdateDiff unchangedDiff = PrefixedStringTemplateUtilsKt.asOneToOneDiff(ktStringTemplateEntry, string2);
        if ($this$escapeDollarIfNecessary.getTextLength() < newPrefixLength) {
            return CollectionsKt.listOf((Object)unchangedDiff);
        }
        PsiElement psiElement = $this$escapeDollarIfNecessary.getNextSibling();
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = psiElement instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)psiElement : null;
        if (ktLiteralStringTemplateEntry == null) {
            return CollectionsKt.listOf((Object)unchangedDiff);
        }
        KtLiteralStringTemplateEntry nextSibling = ktLiteralStringTemplateEntry;
        if (!PrefixedStringTemplateUtilsKt.canBeConsideredIdentifierOrBlock(nextSibling)) {
            return CollectionsKt.listOf((Object)unchangedDiff);
        }
        Project project = $this$escapeDollarIfNecessary.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        String escapedDollar = isDestinationSingleQuoted ? "\\$" : StringsKt.repeat((CharSequence)"$", (int)newPrefixLength) + "{'$'}";
        String string3 = $this$escapeDollarIfNecessary.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String beforeLast = StringsKt.dropLast((String)string3, (int)1);
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ktPsiFactory.createStringTemplate(escapedDollar).getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        KtStringTemplateEntry ktStringTemplateEntry2 = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
        if (ktStringTemplateEntry2 == null) {
            return CollectionsKt.listOf((Object)unchangedDiff);
        }
        KtStringTemplateEntry escapedLastDollar = ktStringTemplateEntry2;
        Object[] objectArray = new EntryUpdateDiff[2];
        String string4 = string = beforeLast;
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = ((CharSequence)it).length() > 0;
        Object[] objectArray3 = objectArray2;
        int n2 = n;
        String string5 = bl2 ? string : null;
        if (string5 != null) {
            it = string5;
            n = n2;
            objectArray2 = objectArray3;
            boolean bl3 = false;
            EntryUpdateDiff entryUpdateDiff2 = new EntryUpdateDiff(RangesKt.until((int)0, (int)($this$escapeDollarIfNecessary.getTextLength() - 1)), it, it);
            objectArray3 = objectArray2;
            n2 = n;
            entryUpdateDiff = entryUpdateDiff2;
        } else {
            entryUpdateDiff = null;
        }
        objectArray3[n2] = entryUpdateDiff;
        IntRange intRange = new IntRange($this$escapeDollarIfNecessary.getTextLength() - 1, $this$escapeDollarIfNecessary.getTextLength());
        String string6 = $this$escapeDollarIfNecessary.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        String string7 = String.valueOf(StringsKt.last((CharSequence)string6));
        String string8 = escapedLastDollar.getText();
        if (string8 == null) {
            string8 = "";
        }
        objectArray[1] = new EntryUpdateDiff(intRange, string7, string8);
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final List<EntryUpdateDiff> escapeSpecialCharacters(KtLiteralStringTemplateEntry $this$escapeSpecialCharacters) {
        NotNullFunction notNullFunction = StringUtil.escaper((boolean)true, (String)"\"");
        Intrinsics.checkNotNullExpressionValue((Object)notNullFunction, (String)"escaper(...)");
        NotNullFunction escaper = notNullFunction;
        Ref.IntRef from = new Ref.IntRef();
        Ref.IntRef to2 = new Ref.IntRef();
        Ref.ObjectRef nextChunkBuilder = new Ref.ObjectRef();
        nextChunkBuilder.element = new StringBuilder();
        List diffs = new ArrayList();
        String string = $this$escapeSpecialCharacters.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = string2.length();
        for (int j = 0; j < n; ++j) {
            int n2;
            char c = string2.charAt(j);
            String oldCharAsString = String.valueOf(c);
            Object object = escaper.apply((Object)oldCharAsString);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
            String escapedCharAsString = (String)object;
            if (Intrinsics.areEqual((Object)oldCharAsString, (Object)escapedCharAsString)) {
                n2 = to2.element;
                to2.element = n2 + 1;
                ((StringBuilder)nextChunkBuilder.element).append(escapedCharAsString);
                continue;
            }
            PrefixedStringTemplateUtilsKt.escapeSpecialCharacters$dumpSimpleChunk(from, to2, (Ref.ObjectRef<StringBuilder>)nextChunkBuilder, diffs);
            diffs.add(new EntryUpdateDiff(RangesKt.until((int)to2.element, (int)(to2.element + 1)), oldCharAsString, escapedCharAsString));
            n2 = to2.element;
            from.element = to2.element = n2 + 1;
        }
        PrefixedStringTemplateUtilsKt.escapeSpecialCharacters$dumpSimpleChunk(from, to2, (Ref.ObjectRef<StringBuilder>)nextChunkBuilder, diffs);
        return diffs;
    }

    private static final KtStringTemplateEntry unescapeIfPossible(KtStringTemplateEntry $this$unescapeIfPossible, int newPrefixLength) {
        KtStringTemplateEntry ktStringTemplateEntry;
        KtStringTemplateEntry ktStringTemplateEntry2 = $this$unescapeIfPossible;
        if (ktStringTemplateEntry2 instanceof KtEscapeStringTemplateEntry) {
            if (!Intrinsics.areEqual((Object)((KtEscapeStringTemplateEntry)$this$unescapeIfPossible).getUnescapedValue(), (Object)"$")) {
                return $this$unescapeIfPossible;
            }
            if (!PrefixedStringTemplateUtilsKt.isSafeToReplaceWithDollar($this$unescapeIfPossible, newPrefixLength)) {
                return $this$unescapeIfPossible;
            }
            Project project = ((KtEscapeStringTemplateEntry)$this$unescapeIfPossible).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ktStringTemplateEntry = (KtStringTemplateEntry)new KtPsiFactory(project, false, 2, null).createLiteralStringTemplateEntry("$");
        } else if (ktStringTemplateEntry2 instanceof KtBlockStringTemplateEntry) {
            KtExpression ktExpression = ((KtBlockStringTemplateEntry)$this$unescapeIfPossible).getExpression();
            if (ktExpression == null) {
                return $this$unescapeIfPossible;
            }
            KtExpression expression = ktExpression;
            if (!ArraysKt.contains((Object[])dollarLiteralExpressions, (Object)expression.getText())) {
                return $this$unescapeIfPossible;
            }
            if (!PrefixedStringTemplateUtilsKt.isSafeToReplaceWithDollar($this$unescapeIfPossible, newPrefixLength)) {
                return $this$unescapeIfPossible;
            }
            Project project = ((KtBlockStringTemplateEntry)$this$unescapeIfPossible).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ktStringTemplateEntry = (KtStringTemplateEntry)new KtPsiFactory(project, false, 2, null).createLiteralStringTemplateEntry("$");
        } else {
            ktStringTemplateEntry = $this$unescapeIfPossible;
        }
        return ktStringTemplateEntry;
    }

    public static final boolean canBeConsideredIdentifierOrBlock(@NotNull KtLiteralStringTemplateEntry $this$canBeConsideredIdentifierOrBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeConsideredIdentifierOrBlock, (String)"<this>");
        String string = $this$canBeConsideredIdentifierOrBlock.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Character c = StringsKt.firstOrNull((CharSequence)string);
        return c != null ? PrefixedStringTemplateUtilsKt.canBeStartOfIdentifierOrBlock(c.charValue()) : false;
    }

    public static final boolean canBeStartOfIdentifierOrBlock(char $this$canBeStartOfIdentifierOrBlock) {
        return Character.isLetter($this$canBeStartOfIdentifierOrBlock) || $this$canBeStartOfIdentifierOrBlock == '_' || $this$canBeStartOfIdentifierOrBlock == '{' || $this$canBeStartOfIdentifierOrBlock == '`';
    }

    public static final boolean isEscapedDollar(@NotNull KtStringTemplateEntry $this$isEscapedDollar) {
        Intrinsics.checkNotNullParameter((Object)$this$isEscapedDollar, (String)"<this>");
        KtStringTemplateEntry ktStringTemplateEntry = $this$isEscapedDollar;
        return ktStringTemplateEntry instanceof KtEscapeStringTemplateEntry ? PrefixedStringTemplateUtilsKt.isEscapedDollar((KtEscapeStringTemplateEntry)$this$isEscapedDollar) : (ktStringTemplateEntry instanceof KtBlockStringTemplateEntry ? PrefixedStringTemplateUtilsKt.isInterpolatedDollarLiteralExpression((KtBlockStringTemplateEntry)$this$isEscapedDollar) : false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TextRange> findTextRangesInParentForEscapedDollars(@NotNull KtStringTemplateExpression $this$findTextRangesInParentForEscapedDollars, boolean includeUnsafe) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findTextRangesInParentForEscapedDollars, (String)"<this>");
        KtStringTemplateEntry[] ktStringTemplateEntryArray = $this$findTextRangesInParentForEscapedDollars.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$filter$iv = ktStringTemplateEntryArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (KtStringTemplateEntry element$iv$iv : $this$filterTo$iv$iv) {
            KtStringTemplateEntry entry = element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            if (!(PrefixedStringTemplateUtilsKt.isEscapedDollar(entry) && (includeUnsafe || PrefixedStringTemplateUtilsKt.isSafeToReplaceWithDollar(entry, PrefixedStringTemplateUtilsKt.getEntryPrefixLength($this$findTextRangesInParentForEscapedDollars))))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtStringTemplateEntry element$iv$iv;
            element$iv$iv = (KtStringTemplateEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTextRangeInParent());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final MultiDollarConversionInfo prepareMultiDollarConversionInfo(@NotNull KtStringTemplateExpression element, boolean useFallbackPrefix) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Integer n = PrefixedStringTemplateUtilsKt.findSuitablePrefixLength(element, useFallbackPrefix);
        if (n == null) {
            return null;
        }
        int suitablePrefixLength = n;
        return new MultiDollarConversionInfo(suitablePrefixLength);
    }

    private static final Integer findSuitablePrefixLength(KtStringTemplateExpression element, boolean useFallbackPrefix) {
        int longestUnsafeDollarSequence = PrefixedStringTemplateUtilsKt.longestUnsafeDollarSequenceLengthForConservativeConversion(element, 5);
        if (longestUnsafeDollarSequence >= 5) {
            return useFallbackPrefix ? Integer.valueOf(2) : null;
        }
        return Math.max(longestUnsafeDollarSequence + 1, 2);
    }

    @NotNull
    public static final KtStringTemplateExpression convertToMultiDollarString(@NotNull KtStringTemplateExpression element, @NotNull MultiDollarConversionInfo contextInfo) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)contextInfo, (String)"contextInfo");
        if (element.getInterpolationPrefix() != null) {
            LOG.error(StringsKt.trimIndent((String)("\n            The string passed for multi-dollar conversion already has an interpolation prefix and won't be changed: " + element.getText() + ".\n            This function should only be used for strings without an interpolation prefix. \n            ")));
            return element;
        }
        PrefixedStringTemplateUtilsKt.replaceExpressionEntries(element, contextInfo.getPrefixLength());
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement psiElement = element.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createMultiDollarStringTemplate(KtPsiUtilKt.getPlainContent((KtStringTemplateExpression)element), contextInfo.getPrefixLength(), !KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)element)));
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        KtStringTemplateExpression replaced = (KtStringTemplateExpression)psiElement;
        return replaced;
    }

    @NotNull
    public static final KtStringTemplateExpression convertToStringWithoutPrefix(@NotNull KtStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getInterpolationPrefix() == null) {
            return element;
        }
        PrefixedStringTemplateUtilsKt.replaceExpressionEntries(element, 1);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtStringTemplateExpression replaced = PrefixedStringTemplateUtilsKt.createStringTemplate(psiFactory, PrefixedStringTemplateUtilsKt.toEscapedText(element, KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)element)), 0, !KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)element));
        PsiElement psiElement = element.replace((PsiElement)replaced);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        return (KtStringTemplateExpression)psiElement;
    }

    private static final String toEscapedText(KtStringTemplateExpression $this$toEscapedText, boolean isSingleQuoted) {
        String dollarReplacement = isSingleQuoted ? "\\$" : "${'$'}";
        KtStringTemplateEntry[] ktStringTemplateEntryArray = $this$toEscapedText.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        return ArraysKt.joinToString$default((Object[])ktStringTemplateEntryArray, (CharSequence)"", null, null, (int)0, null, arg_0 -> PrefixedStringTemplateUtilsKt.toEscapedText$lambda$0(dollarReplacement, arg_0), (int)30, null);
    }

    @NotNull
    public static final KtStringTemplateExpression simplifyDollarEntries(@NotNull KtStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        int entryPrefixLength = PrefixedStringTemplateUtilsKt.getEntryPrefixLength(element);
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        for (KtStringTemplateEntry entry : ktStringTemplateEntryArray) {
            KtStringTemplateEntry ktStringTemplateEntry = entry;
            if (ktStringTemplateEntry instanceof KtEscapeStringTemplateEntry) {
                if (!PrefixedStringTemplateUtilsKt.isEscapedDollar((KtEscapeStringTemplateEntry)entry) || !PrefixedStringTemplateUtilsKt.isSafeToReplaceWithDollar(entry, entryPrefixLength)) continue;
                ((KtEscapeStringTemplateEntry)entry).replace((PsiElement)ktPsiFactory.createLiteralStringTemplateEntry("$"));
                continue;
            }
            if (!(ktStringTemplateEntry instanceof KtBlockStringTemplateEntry)) continue;
            KtExpression ktExpression = ((KtBlockStringTemplateEntry)entry).getExpression();
            if (!ArraysKt.contains((Object[])dollarLiteralExpressions, (Object)(ktExpression != null ? ktExpression.getText() : null)) || !PrefixedStringTemplateUtilsKt.isSafeToReplaceWithDollar(entry, entryPrefixLength)) continue;
            ((KtBlockStringTemplateEntry)entry).replace((PsiElement)ktPsiFactory.createLiteralStringTemplateEntry("$"));
        }
        KtStringTemplateExpression replacement = PrefixedStringTemplateUtilsKt.createStringTemplate(ktPsiFactory, KtPsiUtilKt.getPlainContent((KtStringTemplateExpression)element), PrefixedStringTemplateUtilsKt.getTemplatePrefixLength(element), !KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)element));
        PsiElement psiElement = element.replace((PsiElement)replacement);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        return (KtStringTemplateExpression)psiElement;
    }

    public static final int findPrefixLengthForPlainTextConversion(@NotNull KtStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PrefixedStringTemplateUtilsKt.longestUnsafeDollarSequenceLengthForPlainTextConversion$default(element, 0, 2, null) + 1;
    }

    private static final int longestUnsafeDollarSequenceLengthForConservativeConversion(KtStringTemplateExpression element, int threshold) {
        int longest = 0;
        int current = 0;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        for (KtStringTemplateEntry entry : ktStringTemplateEntryArray) {
            KtStringTemplateEntry ktStringTemplateEntry = entry;
            if (ktStringTemplateEntry instanceof KtSimpleNameStringTemplateEntry) {
                current = 0;
            } else if (ktStringTemplateEntry instanceof KtEscapeStringTemplateEntry) {
                current = PrefixedStringTemplateUtilsKt.isEscapedDollar((KtEscapeStringTemplateEntry)entry) ? ++current : 0;
            } else if (ktStringTemplateEntry instanceof KtBlockStringTemplateEntry) {
                current = PrefixedStringTemplateUtilsKt.isInterpolatedDollarLiteralExpression((KtBlockStringTemplateEntry)entry) ? ++current : 0;
            } else if (ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry) {
                if (PrefixedStringTemplateUtilsKt.canBeConsideredIdentifierOrBlock((KtLiteralStringTemplateEntry)entry)) {
                    if (current > longest) {
                        longest = current;
                    }
                    current = PrefixedStringTemplateUtilsKt.getTrailingDollarsLength(entry);
                } else {
                    boolean bl;
                    block14: {
                        String string = ((KtLiteralStringTemplateEntry)entry).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        CharSequence $this$all$iv = string;
                        boolean $i$f$all = false;
                        for (int j = 0; j < $this$all$iv.length(); ++j) {
                            char element$iv;
                            char it = element$iv = $this$all$iv.charAt(j);
                            boolean bl2 = false;
                            if (it == '$') continue;
                            bl = false;
                            break block14;
                        }
                        bl = true;
                    }
                    if (bl) {
                        current += ((KtLiteralStringTemplateEntry)entry).getText().length();
                    } else {
                        String string = ((KtLiteralStringTemplateEntry)entry).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        current = StringsKt.endsWith$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null) ? PrefixedStringTemplateUtilsKt.getTrailingDollarsLength(entry) : 0;
                    }
                }
            }
            if (longest >= threshold) break;
        }
        return longest;
    }

    static /* synthetic */ int longestUnsafeDollarSequenceLengthForConservativeConversion$default(KtStringTemplateExpression ktStringTemplateExpression, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return PrefixedStringTemplateUtilsKt.longestUnsafeDollarSequenceLengthForConservativeConversion(ktStringTemplateExpression, n);
    }

    private static final int longestUnsafeDollarSequenceLengthForPlainTextConversion(KtStringTemplateExpression element, int threshold) {
        int longest = 0;
        int current = 0;
        int entryPrefixLength = PrefixedStringTemplateUtilsKt.getEntryPrefixLength(element);
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        for (KtStringTemplateEntry entry : ktStringTemplateEntryArray) {
            KtStringTemplateEntry ktStringTemplateEntry = entry;
            if (ktStringTemplateEntry instanceof KtSimpleNameStringTemplateEntry || ktStringTemplateEntry instanceof KtBlockStringTemplateEntry) {
                if ((current += entryPrefixLength) > longest) {
                    longest = current;
                }
                current = 0;
            } else if (ktStringTemplateEntry instanceof KtEscapeStringTemplateEntry) {
                current = 0;
            } else if (ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry) {
                if (PrefixedStringTemplateUtilsKt.canBeConsideredIdentifierOrBlock((KtLiteralStringTemplateEntry)entry)) {
                    if (current > longest) {
                        longest = current;
                    }
                    current = PrefixedStringTemplateUtilsKt.getTrailingDollarsLength(entry);
                } else {
                    boolean bl;
                    block13: {
                        String string = ((KtLiteralStringTemplateEntry)entry).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        CharSequence $this$all$iv = string;
                        boolean $i$f$all = false;
                        for (int j = 0; j < $this$all$iv.length(); ++j) {
                            char element$iv;
                            char it = element$iv = $this$all$iv.charAt(j);
                            boolean bl2 = false;
                            if (it == '$') continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                    if (bl) {
                        current += ((KtLiteralStringTemplateEntry)entry).getText().length();
                    } else {
                        String string = ((KtLiteralStringTemplateEntry)entry).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        current = StringsKt.endsWith$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null) ? PrefixedStringTemplateUtilsKt.getTrailingDollarsLength(entry) : 0;
                    }
                }
            }
            if (longest >= threshold) break;
        }
        return longest;
    }

    static /* synthetic */ int longestUnsafeDollarSequenceLengthForPlainTextConversion$default(KtStringTemplateExpression ktStringTemplateExpression, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return PrefixedStringTemplateUtilsKt.longestUnsafeDollarSequenceLengthForPlainTextConversion(ktStringTemplateExpression, n);
    }

    private static final boolean isInterpolatedDollarLiteralExpression(KtBlockStringTemplateEntry $this$isInterpolatedDollarLiteralExpression) {
        KtExpression ktExpression = $this$isInterpolatedDollarLiteralExpression.getExpression();
        return ArraysKt.contains((Object[])dollarLiteralExpressions, (Object)(ktExpression != null ? ktExpression.getText() : null));
    }

    private static final void replaceExpressionEntries(KtStringTemplateExpression stringTemplate, int prefixLength) {
        KtStringTemplateEntry[] ktStringTemplateEntryArray = stringTemplate.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        for (KtStringTemplateEntry entry : ktStringTemplateEntryArray) {
            if (!(entry instanceof KtStringTemplateEntryWithExpression)) continue;
            ((KtStringTemplateEntryWithExpression)entry).replace((PsiElement)PrefixedStringTemplateUtilsKt.changePrefixLength((KtStringTemplateEntryWithExpression)entry, prefixLength));
        }
    }

    private static final boolean isEscapedDollar(KtEscapeStringTemplateEntry $this$isEscapedDollar) {
        return Intrinsics.areEqual((Object)$this$isEscapedDollar.getUnescapedValue(), (Object)"$");
    }

    private static final boolean isSafeToReplaceWithDollar(KtStringTemplateEntry $this$isSafeToReplaceWithDollar, int prefixLength) {
        PsiElement psiElement = $this$isSafeToReplaceWithDollar.getNextSibling();
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = psiElement instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)psiElement : null;
        if (ktLiteralStringTemplateEntry == null) {
            return true;
        }
        KtLiteralStringTemplateEntry nextSiblingStringLiteral = ktLiteralStringTemplateEntry;
        if (!PrefixedStringTemplateUtilsKt.canBeConsideredIdentifierOrBlock(nextSiblingStringLiteral)) {
            return true;
        }
        int trailingDollarsLength = PrefixedStringTemplateUtilsKt.countTrailingDollarsInPreviousEntries($this$isSafeToReplaceWithDollar);
        return trailingDollarsLength + 1 < prefixLength;
    }

    private static final int countTrailingDollarsInPreviousEntries(KtStringTemplateEntry $this$countTrailingDollarsInPreviousEntries) {
        int count = 0;
        PsiElement prev = $this$countTrailingDollarsInPreviousEntries.getPrevSibling();
        while (prev instanceof KtLiteralStringTemplateEntry) {
            String string;
            block2: {
                String $this$takeLastWhile$iv;
                Intrinsics.checkNotNullExpressionValue((Object)((KtLiteralStringTemplateEntry)prev).getText(), (String)"getText(...)");
                boolean $i$f$takeLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it = $this$takeLastWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)String.valueOf(it), (Object)"$")) continue;
                    String string2 = $this$takeLastWhile$iv;
                    int n = index$iv + 1;
                    String string3 = string2.substring(n);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block2;
                }
                string = $this$takeLastWhile$iv;
            }
            int trailingDollarsLength = string.length();
            count += trailingDollarsLength;
            if (((KtLiteralStringTemplateEntry)prev).getTextLength() != trailingDollarsLength) break;
            prev = ((KtLiteralStringTemplateEntry)prev).getPrevSibling();
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    private static final int getTrailingDollarsLength(KtStringTemplateEntry $this$trailingDollarsLength) {
        String string;
        block1: {
            void var1_1;
            String string2 = $this$trailingDollarsLength.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String $this$takeLastWhile$iv = string2;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (Intrinsics.areEqual((Object)String.valueOf(it), (Object)"$")) continue;
                String string3 = $this$takeLastWhile$iv;
                int n = index$iv + 1;
                String string4 = string3.substring(n);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                break block1;
            }
            string = var1_1;
        }
        return string.length();
    }

    public static final int getTemplatePrefixLength(@NotNull KtStringTemplateExpression $this$templatePrefixLength) {
        Intrinsics.checkNotNullParameter((Object)$this$templatePrefixLength, (String)"<this>");
        KtStringInterpolationPrefix ktStringInterpolationPrefix = $this$templatePrefixLength.getInterpolationPrefix();
        return ktStringInterpolationPrefix != null ? ktStringInterpolationPrefix.getTextLength() : 0;
    }

    public static final int getEntryPrefixLength(@NotNull KtStringTemplateExpression $this$entryPrefixLength) {
        Intrinsics.checkNotNullParameter((Object)$this$entryPrefixLength, (String)"<this>");
        KtStringInterpolationPrefix ktStringInterpolationPrefix = $this$entryPrefixLength.getInterpolationPrefix();
        return ktStringInterpolationPrefix != null ? ktStringInterpolationPrefix.getTextLength() : 1;
    }

    @NotNull
    public static final KtStringTemplateExpression createStringTemplate(@NotNull KtPsiFactory $this$createStringTemplate, @NotNull String content, int prefixLength, boolean isRaw) {
        Intrinsics.checkNotNullParameter((Object)$this$createStringTemplate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return prefixLength > 0 ? $this$createStringTemplate.createMultiDollarStringTemplate(content, prefixLength, isRaw) : (isRaw ? $this$createStringTemplate.createRawStringTemplate(content) : $this$createStringTemplate.createStringTemplate(content));
    }

    private static final Unit changeInterpolationPrefix$lambda$0(StringTemplateEntryUpdateInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final CharSequence changeInterpolationPrefix$lambda$2$1(EntryUpdateDiff it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNewText();
    }

    private static final void escapeSpecialCharacters$dumpSimpleChunk(Ref.IntRef from, Ref.IntRef to2, Ref.ObjectRef<StringBuilder> nextChunkBuilder, List<EntryUpdateDiff> diffs) {
        if (from.element < to2.element) {
            String string = ((StringBuilder)nextChunkBuilder.element).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String simpleTextChunk = string;
            nextChunkBuilder.element = new StringBuilder();
            diffs.add(new EntryUpdateDiff(RangesKt.until((int)from.element, (int)to2.element), simpleTextChunk, simpleTextChunk));
        }
    }

    private static final CharSequence toEscapedText$lambda$0(String $dollarReplacement, KtStringTemplateEntry entry) {
        CharSequence charSequence;
        if (entry instanceof KtLiteralStringTemplateEntry) {
            String string = ((KtLiteralStringTemplateEntry)entry).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            charSequence = StringsKt.replace$default((String)string, (String)"$", (String)$dollarReplacement, (boolean)false, (int)4, null);
        } else {
            String string = entry.getText();
            Intrinsics.checkNotNull((Object)string);
            charSequence = string;
        }
        return charSequence;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PrefixedStringTemplateUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        String[] stringArray = new String[]{"'$'", "\"$\""};
        dollarLiteralExpressions = stringArray;
    }
}

