/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.concurrency.Semaphore;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidStackFrameException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposableUtils;
import org.jetbrains.kotlin.idea.core.util.CodeFragmentUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.HopelessExceptionUtils;
import org.jetbrains.kotlin.idea.debugger.core.CodeFragmentContextTuner;
import org.jetbrains.kotlin.idea.debugger.evaluate.DebugContextProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.FrameInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactoryBase;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugForeignPropertyDescriptorProvider;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\f\u001a\u00020\r*\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\tH\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinK1CodeFragmentFactory;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactoryBase;", "<init>", "()V", "createPsiCodeFragmentImpl", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "registerCodeFragmentExtensions", "", "Lorg/jetbrains/kotlin/psi/KtBlockCodeFragment;", "contextElement", "unwrapNullableType", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "supplyDebugInformation", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "getFrameInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;", "debuggerContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "fixImportIfNeeded", "", "import", "isContextAccepted", "", "isJavaContextAccepted", "createFakeFileWithJavaContextElement", "Lorg/jetbrains/kotlin/psi/KtFile;", "funWithLocalVariables", "javaContext", "Companion", "kotlin.jvm-debugger.evaluation.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinK1CodeFragmentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinK1CodeFragmentFactory.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinK1CodeFragmentFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 4 HopelessExceptionUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/HopelessExceptionUtils\n*L\n1#1,226:1\n1#2:227\n73#3:228\n73#3:231\n17#4,2:229\n19#4,3:232\n*S KotlinDebug\n*F\n+ 1 KotlinK1CodeFragmentFactory.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinK1CodeFragmentFactory\n*L\n87#1:228\n150#1:231\n149#1:229,2\n149#1:232,3\n*E\n"})
public final class KotlinK1CodeFragmentFactory
extends KotlinCodeFragmentFactoryBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String FAKE_JAVA_CONTEXT_FUNCTION_NAME = "_java_locals_debug_fun_";

    @NotNull
    protected JavaCodeFragment createPsiCodeFragmentImpl(@NotNull TextWithImports item, @Nullable PsiElement context2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement contextElement = CodeFragmentContextTuner.Companion.getInstance().tuneContextElement(context2);
        String string = item.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        KtBlockCodeFragment codeFragment = new KtBlockCodeFragment(project, "fragment.kt", (CharSequence)string, this.initImports(item.getImports()), contextElement);
        this.registerCodeFragmentExtensions(codeFragment, contextElement);
        this.supplyDebugInformation((KtCodeFragment)codeFragment, context2);
        return (JavaCodeFragment)codeFragment;
    }

    @Override
    public void registerCodeFragmentExtensions(@NotNull KtBlockCodeFragment $this$registerCodeFragmentExtensions, @Nullable PsiElement contextElement) {
        Intrinsics.checkNotNullParameter((Object)$this$registerCodeFragmentExtensions, (String)"<this>");
        $this$registerCodeFragmentExtensions.putCopyableUserData(CodeFragmentUtils.INSTANCE.getRUNTIME_TYPE_EVALUATOR(), arg_0 -> KotlinK1CodeFragmentFactory.registerCodeFragmentExtensions$lambda$0($this$registerCodeFragmentExtensions, arg_0));
        if (contextElement != null && !(contextElement instanceof KtElement)) {
            $this$registerCodeFragmentExtensions.putCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE(), () -> KotlinK1CodeFragmentFactory.registerCodeFragmentExtensions$lambda$1(this, contextElement, $this$registerCodeFragmentExtensions));
        }
    }

    private final KtTypeElement unwrapNullableType(KtTypeElement $this$unwrapNullableType) {
        KtTypeElement ktTypeElement;
        if ($this$unwrapNullableType instanceof KtNullableType) {
            ktTypeElement = ((KtNullableType)$this$unwrapNullableType).getInnerType();
            if (ktTypeElement == null) {
                ktTypeElement = $this$unwrapNullableType;
            }
        } else {
            ktTypeElement = $this$unwrapNullableType;
        }
        return ktTypeElement;
    }

    private final void supplyDebugInformation(KtCodeFragment codeFragment, PsiElement context2) {
        Project project = codeFragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DebuggerContextImpl debuggerContextImpl = DebugContextProvider.INSTANCE.getDebuggerContext(project2, context2);
        if (debuggerContextImpl == null || (debuggerContextImpl = debuggerContextImpl.getDebugProcess()) == null) {
            return;
        }
        DebuggerContextImpl debugProcess = debuggerContextImpl;
        new DebugForeignPropertyDescriptorProvider(codeFragment, (DebugProcessImpl)debugProcess).supplyDebugForeignProperties();
    }

    private final FrameInfo getFrameInfo(Project project, PsiElement contextElement, DebuggerContextImpl debuggerContext) {
        DebuggerManagerThreadImpl managerThread;
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        Ref.ObjectRef frameInfo = new Ref.ObjectRef();
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = managerThread = debuggerContext.getManagerThread();
        if (debuggerManagerThreadImpl != null) {
            debuggerManagerThreadImpl.invoke(PrioritizedTask.Priority.LOW, () -> KotlinK1CodeFragmentFactory.getFrameInfo$lambda$0(frameInfo, debuggerContext, semaphore, project, contextElement));
        }
        for (int i2 = 0; i2 < 51 && !semaphore.waitFor(20L); ++i2) {
        }
        return (FrameInfo)frameInfo.element;
    }

    private final String fixImportIfNeeded(String string) {
        if (StringsKt.endsWith$default((String)string, (String)"[]", (boolean)false, (int)2, null)) {
            return this.fixImportIfNeeded(((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)string, (CharSequence)"[]"))).toString());
        }
        if (!Intrinsics.areEqual((Object)PsiTypesUtil.boxIfPossible((String)string), (Object)string)) {
            return null;
        }
        return string;
    }

    public boolean isContextAccepted(@Nullable PsiElement contextElement) {
        return (Boolean)ActionsKt.runReadAction(() -> KotlinK1CodeFragmentFactory.isContextAccepted$lambda$0(contextElement, this));
    }

    private final boolean isJavaContextAccepted() {
        return Registry.Companion.is("debugger.enable.kotlin.evaluator.in.java.context", false);
    }

    private final KtFile createFakeFileWithJavaContextElement(String funWithLocalVariables, PsiElement javaContext) {
        PsiJavaFile psiJavaFile;
        PsiFile psiFile = javaContext.getContainingFile();
        PsiJavaFile javaFile = psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
        StringBuilder sb = new StringBuilder();
        Object object = javaFile;
        if (object != null && (object = object.getPackageName()) != null) {
            Object object2;
            Object it = object2 = object;
            boolean bl = false;
            object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object2 : null;
            if (object != null) {
                it = object;
                boolean bl2 = false;
                sb.append("package ").append(KtPsiUtilKt.quoteIfNeeded((String)it)).append("\n");
            }
        }
        if ((psiJavaFile = javaFile) != null && (psiJavaFile = psiJavaFile.getImportList()) != null) {
            PsiJavaFile it = psiJavaFile;
            boolean bl = false;
            sb.append(it.getText()).append("\n");
        }
        sb.append(funWithLocalVariables);
        KtPsiFactory ktPsiFactory = KtPsiFactory.Companion.contextual$default((KtPsiFactory.Companion)KtPsiFactory.Companion, (PsiElement)javaContext, (boolean)false, (boolean)false, (int)6, null);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ktPsiFactory.createFile("fakeFileForJavaContextInDebugger.kt", string);
    }

    private static final KotlinType registerCodeFragmentExtensions$lambda$0(KtBlockCodeFragment $this_registerCodeFragmentExtensions, KtExpression expression) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx((Project)$this_registerCodeFragmentExtensions.getProject()).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getContext(...)");
        DebuggerContextImpl debuggerContext = debuggerContextImpl;
        DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
        if (debuggerSession == null || debuggerContext.getSuspendContext() == null) {
            kotlinType = null;
        } else {
            Semaphore semaphore = new Semaphore();
            semaphore.down();
            AtomicReference<KotlinType> nameRef = new AtomicReference<KotlinType>();
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator == null) {
                progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            }
            ProgressIndicator progressIndicator2 = progressIndicator;
            KotlinRuntimeTypeEvaluator worker2 = new KotlinRuntimeTypeEvaluator(expression, debuggerContext, nameRef, semaphore, progressIndicator2){
                final /* synthetic */ AtomicReference<KotlinType> $nameRef;
                final /* synthetic */ Semaphore $semaphore;
                {
                    this.$nameRef = $nameRef;
                    this.$semaphore = $semaphore;
                    super(null, $expression, $debuggerContext, $super_call_param$1);
                }

                protected void typeCalculationFinished(KotlinType type2) {
                    this.$nameRef.set(type2);
                    this.$semaphore.up();
                }
            };
            DebuggerManagerThreadImpl debuggerManagerThreadImpl = debuggerContext.getManagerThread();
            if (debuggerManagerThreadImpl != null) {
                debuggerManagerThreadImpl.invoke((DebuggerCommandImpl)worker2);
            }
            for (int i2 = 0; i2 < 51; ++i2) {
                ProgressManager.checkCanceled();
                if (semaphore.waitFor(20L)) break;
            }
            kotlinType = nameRef.get();
        }
        return kotlinType;
    }

    private static final KtElement registerCodeFragmentExtensions$lambda$1(KotlinK1CodeFragmentFactory this$0, PsiElement $contextElement, KtBlockCodeFragment $this_registerCodeFragmentExtensions) {
        KtExpression fakeContext;
        KtTypeElement thisType;
        StringBuilder stringBuilder;
        KtFile emptyFile = this$0.createFakeFileWithJavaContextElement("", $contextElement);
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx((Project)$this_registerCodeFragmentExtensions.getProject()).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getContext(...)");
        DebuggerContextImpl debuggerContext = debuggerContextImpl;
        DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
        if (debuggerSession == null || debuggerContext.getSuspendContext() == null) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn("Couldn't create fake context element for java file, debugger isn't paused on breakpoint");
                return (KtElement)emptyFile;
            }
        }
        Project project = $this_registerCodeFragmentExtensions.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FrameInfo frameInfo = this$0.getFrameInfo(project, $contextElement, debuggerContext);
        if (frameInfo == null) {
            KtBlockCodeFragment $this$registerCodeFragmentExtensions_u24lambda_u241_u240 = $this_registerCodeFragmentExtensions;
            boolean bl = false;
            SourcePosition sourcePosition = debuggerContext.getSourcePosition();
            SourcePosition sourcePosition2 = debuggerContext.getSourcePosition();
            String position = (sourcePosition2 != null && (sourcePosition2 = sourcePosition2.getFile()) != null ? sourcePosition2.getName() : null) + ":" + (sourcePosition != null ? Integer.valueOf(sourcePosition.getLine()) : null);
            LOG.warn("Couldn't get info about 'this' and local variables for " + position);
            return (KtElement)emptyFile;
        }
        FrameInfo frameInfo2 = frameInfo;
        StringBuilder $this$registerCodeFragmentExtensions_u24lambda_u241_u241 = stringBuilder = new StringBuilder();
        boolean $i$a$-buildString-KotlinK1CodeFragmentFactory$registerCodeFragmentExtensions$2$fakeFunctionText$22 = false;
        $this$registerCodeFragmentExtensions_u24lambda_u241_u241.append("fun ");
        FrameInfo.Variable variable = frameInfo2.getThisObject();
        KtTypeElement ktTypeElement = variable != null && (variable = variable.asProperty()) != null && (variable = variable.getTypeReference()) != null && (variable = variable.getTypeElement()) != null ? this$0.unwrapNullableType((KtTypeElement)variable) : (thisType = null);
        if (thisType != null) {
            $this$registerCodeFragmentExtensions_u24lambda_u241_u241.append(thisType.getText()).append('.');
        }
        $this$registerCodeFragmentExtensions_u24lambda_u241_u241.append(FAKE_JAVA_CONTEXT_FUNCTION_NAME).append("() {\n");
        for (FrameInfo.Variable variable2 : frameInfo2.getVariables()) {
            Object object = variable2.asProperty();
            if (object == null || (object = object.getText()) == null) continue;
            Object text = object;
            $this$registerCodeFragmentExtensions_u24lambda_u241_u241.append("    ").append((String)text).append("\n");
        }
        $this$registerCodeFragmentExtensions_u24lambda_u241_u241.append("    val _debug_context_val = 1\n");
        $this$registerCodeFragmentExtensions_u24lambda_u241_u241.append("}");
        String fakeFunctionText = stringBuilder.toString();
        KtFile fakeFile2 = this$0.createFakeFileWithJavaContextElement(fakeFunctionText, $contextElement);
        Object $i$a$-buildString-KotlinK1CodeFragmentFactory$registerCodeFragmentExtensions$2$fakeFunctionText$22 = CollectionsKt.firstOrNull((List)fakeFile2.getDeclarations());
        KtFunction fakeFunction = $i$a$-buildString-KotlinK1CodeFragmentFactory$registerCodeFragmentExtensions$2$fakeFunctionText$22 instanceof KtFunction ? (KtFunction)$i$a$-buildString-KotlinK1CodeFragmentFactory$registerCodeFragmentExtensions$2$fakeFunctionText$22 : null;
        Object object = fakeFunction;
        KtExpression ktExpression = fakeContext = object != null && (object = object.getBodyBlockExpression()) != null && (object = object.getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)object) : null;
        return ktExpression != null ? (KtElement)ktExpression : (KtElement)emptyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getFrameInfo$lambda$0(Ref.ObjectRef $frameInfo, DebuggerContextImpl $debuggerContext, Semaphore $semaphore, Project $project, PsiElement $contextElement) {
        try {
            StackFrameProxyImpl stackFrameProxyImpl;
            boolean $i$f$hopelessAware = false;
            try {
                Object object;
                boolean bl = false;
                boolean $i$f$isUnitTestMode = false;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    DebuggerContextImpl debuggerContextImpl = DebugContextProvider.INSTANCE.getDebuggerContext($project, $contextElement);
                    object = debuggerContextImpl != null ? debuggerContextImpl.getFrameProxy() : null;
                } else {
                    object = $debuggerContext.getFrameProxy();
                }
                stackFrameProxyImpl = object;
            }
            catch (Exception e$iv) {
                HopelessExceptionUtils.handleHopelessException(e$iv);
                stackFrameProxyImpl = null;
            }
            StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
            Project project = $debuggerContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            $frameInfo.element = FrameInfo.Companion.from(project, frameProxy);
        }
        catch (AbsentInformationException absentInformationException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        finally {
            $semaphore.up();
        }
    }

    private static final boolean isContextAccepted$lambda$0(PsiElement $contextElement, KotlinK1CodeFragmentFactory this$0) {
        boolean bl;
        if ($contextElement instanceof PsiCodeBlock) {
            PsiElement psiElement = ((PsiCodeBlock)$contextElement).getContext();
            bl = this$0.isContextAccepted((PsiElement)(psiElement != null ? psiElement.getContext() : null));
        } else if ($contextElement == null) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)$contextElement.getLanguage(), (Object)KotlinFileType.INSTANCE.getLanguage())) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)$contextElement.getLanguage(), (Object)JavaFileType.INSTANCE.getLanguage()) && this$0.isJavaContextAccepted()) {
            Project project = $contextElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            GlobalSearchScope globalSearchScope = $contextElement.getResolveScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            bl = (Boolean)KotlinPluginDisposableUtils.syncNonBlockingReadAction(project2, () -> KotlinK1CodeFragmentFactory.isContextAccepted$lambda$0$0(scope, project2));
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isContextAccepted$lambda$0$0(GlobalSearchScope $scope, Project $project) {
        return KotlinProjectStructureUtils.hasKotlinJvmRuntime($scope, $project);
    }

    static {
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinK1CodeFragmentFactory$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "FAKE_JAVA_CONTEXT_FUNCTION_NAME", "", "kotlin.jvm-debugger.evaluation.k1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

