/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.ApplicabilityRange;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.JavaCollectionsStaticMethodInspectionUtils;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u00152\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaCollectionsStaticMethodInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "Lorg/jetbrains/kotlin/idea/inspections/JavaCollectionsStaticMethodInspection$Context;", "<init>", "()V", "createProblemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Lcom/intellij/codeInspection/InspectionManager;", "element", "context", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "onTheFly", "", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getApplicableRanges", "", "Context", "ReplaceWithStdLibFix", "kotlin.idea"})
public final class JavaCollectionsStaticMethodInspection
extends KotlinApplicableInspectionBase<KtDotQualifiedExpression, Context> {
    @Override
    @NotNull
    protected ProblemDescriptor createProblemDescriptor(@NotNull InspectionManager $this$createProblemDescriptor, @NotNull KtDotQualifiedExpression element, @NotNull Context context2, @Nullable TextRange rangeInElement, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)$this$createProblemDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = (PsiElement)element;
        String string = KotlinBundle.message((String)"java.collections.static.method.call.should.be.replaced.with.kotlin.stdlib", (Object[])new Object[0]);
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
        String string2 = context2.getMethodName();
        String string3 = context2.getFirstArg().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        localQuickFixArray[0] = new ReplaceWithStdLibFix(string2, string3);
        ProblemDescriptor problemDescriptor = $this$createProblemDescriptor.createProblemDescriptor(psiElement, rangeInElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, localQuickFixArray);
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        return problemDescriptor;
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.dotQualifiedExpressionVisitor(arg_0 -> JavaCollectionsStaticMethodInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Pair<String, KtValueArgument> pair = JavaCollectionsStaticMethodInspectionUtils.INSTANCE.getMethodIfItsArgumentIsMutableList($this$prepareContext, element);
        if (pair == null) {
            return null;
        }
        Pair<String, KtValueArgument> pair2 = pair;
        String methodName = (String)pair2.component1();
        KtValueArgument firstArg = (KtValueArgument)pair2.component2();
        return new Context(methodName, firstArg);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ApplicabilityRange.INSTANCE.self((PsiElement)element);
    }

    private static final Unit buildVisitor$lambda$0(JavaCollectionsStaticMethodInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtDotQualifiedExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaCollectionsStaticMethodInspection$Context;", "", "methodName", "", "firstArg", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtValueArgument;)V", "getMethodName", "()Ljava/lang/String;", "getFirstArg", "()Lorg/jetbrains/kotlin/psi/KtValueArgument;", "kotlin.idea"})
    public static final class Context {
        @NotNull
        private final String methodName;
        @NotNull
        private final KtValueArgument firstArg;

        public Context(@NotNull String methodName, @NotNull KtValueArgument firstArg) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)firstArg, (String)"firstArg");
            this.methodName = methodName;
            this.firstArg = firstArg;
        }

        @NotNull
        public final String getMethodName() {
            return this.methodName;
        }

        @NotNull
        public final KtValueArgument getFirstArg() {
            return this.firstArg;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaCollectionsStaticMethodInspection$ReplaceWithStdLibFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "methodName", "", "receiver", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.idea"})
    private static final class ReplaceWithStdLibFix
    extends KotlinModCommandQuickFix<KtDotQualifiedExpression> {
        @NotNull
        private final String methodName;
        @NotNull
        private final String receiver;

        public ReplaceWithStdLibFix(@NotNull String methodName, @NotNull String receiver2) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)receiver2, (String)"receiver");
            this.methodName = methodName;
            this.receiver = receiver2;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.receiver, this.methodName};
            return KotlinBundle.message((String)"replace.with.std.lib.fix.text", (Object[])objectArray);
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull KtDotQualifiedExpression element, @NotNull ModPsiUpdater updater2) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            KtCallExpression ktCallExpression = KotlinPsiUtilsKt.getCallExpression((KtQualifiedExpression)element);
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression callExpression = ktCallExpression;
            List valueArguments = callExpression.getValueArguments();
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull((List)valueArguments, (int)0);
            if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
                return;
            }
            KtValueArgument firstArg = ktValueArgument;
            KtValueArgument ktValueArgument2 = (KtValueArgument)CollectionsKt.getOrNull((List)valueArguments, (int)1);
            KtExpression secondArg = ktValueArgument2 != null ? ktValueArgument2.getArgumentExpression() : null;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            if (secondArg != null) {
                if (Intrinsics.areEqual((Object)this.methodName, (Object)"sort")) {
                    var10_9 = new Object[2];
                    var10_9[0] = firstArg;
                    Intrinsics.checkNotNullExpressionValue((Object)secondArg.getText(), (String)"getText(...)");
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0.sortWith(Comparator $1)", (Object[])var10_9, (boolean)false, (int)4, null);
                } else {
                    var10_9 = new Object[]{firstArg, secondArg};
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)("$0." + this.methodName + "($1)"), (Object[])var10_9, (boolean)false, (int)4, null);
                }
            } else {
                var10_9 = new Object[]{firstArg};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)("$0." + this.methodName + "()"), (Object[])var10_9, (boolean)false, (int)4, null);
            }
            KtExpression newExpression = ktExpression;
            element.replace((PsiElement)newExpression);
        }
    }
}

