/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.modification.UtilsKt;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ProjectStructureProviderService;
import org.jetbrains.kotlin.idea.internal.actions.InvalidateCachesDialog;
import org.jetbrains.kotlin.idea.internal.actions.InvalidationMode;
import org.jetbrains.kotlin.idea.internal.actions.KotlinInternalBundle;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/internal/actions/InvalidateK2CachesInternalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "invalidateCaches", "project", "Lcom/intellij/openapi/project/Project;", "invalidationMode", "Lorg/jetbrains/kotlin/idea/internal/actions/InvalidationMode;", "showNotificationAboutInvalidatedCaches", "update", "intellij.kotlin.internal"})
@SourceDebugExtension(value={"SMAP\nInvalidateK2CachesInternalAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidateK2CachesInternalAction.kt\norg/jetbrains/kotlin/idea/internal/actions/InvalidateK2CachesInternalAction\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,128:1\n81#2:129\n*S KotlinDebug\n*F\n+ 1 InvalidateK2CachesInternalAction.kt\norg/jetbrains/kotlin/idea/internal/actions/InvalidateK2CachesInternalAction\n*L\n72#1:129\n*E\n"})
public final class InvalidateK2CachesInternalAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        InvalidationMode invalidationMode = InvalidateCachesDialog.Companion.show();
        if (invalidationMode == null) {
            return;
        }
        InvalidationMode invalidationMode2 = invalidationMode;
        this.invalidateCaches(project2, invalidationMode2);
        DaemonCodeAnalyzer.getInstance((Project)project2).restart((Object)this);
        this.showNotificationAboutInvalidatedCaches(project2, invalidationMode2);
    }

    private final void invalidateCaches(Project project, InvalidationMode invalidationMode) {
        ApplicationUtilsKt.runWriteAction(() -> InvalidateK2CachesInternalAction.invalidateCaches$lambda$0(invalidationMode, project));
    }

    private final void showNotificationAboutInvalidatedCaches(Project project, InvalidationMode invalidationMode) {
        Notification notification;
        String content = switch (WhenMappings.$EnumSwitchMapping$0[invalidationMode.ordinal()]) {
            case 1 -> KotlinInternalBundle.message("notification.content.source.caches", new Object[0]);
            case 2 -> KotlinInternalBundle.message("notification.content.source.library.caches", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        Notification $this$showNotificationAboutInvalidatedCaches_u24lambda_u240 = notification = new Notification("Internal Kotlin Plugin Actions", KotlinInternalBundle.message("notification.content.kotlin.internal.resolution.caches.were.invalidated.title", new Object[0]), content, NotificationType.INFORMATION);
        boolean bl = false;
        $this$showNotificationAboutInvalidatedCaches_u24lambda_u240.setIcon(KotlinIcons.FIR);
        Notification notification2 = notification;
        Notifications.Bus.notify((Notification)notification2, (Project)project);
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        v0 = e.getPresentation();
        if (e.getProject() == null) ** GOTO lbl-1000
        $i$f$isApplicationInternalMode = false;
        if (ApplicationManager.getApplication().isInternal() && KotlinPluginModeProvider.Companion.isK2Mode()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        v0.setEnabledAndVisible(v1);
    }

    private static final Unit invalidateCaches$lambda$0(InvalidationMode $invalidationMode, Project $project) {
        if ($invalidationMode.getInvalidateSources()) {
            ProjectStructureProviderService.Companion.getInstance($project).incOutOfBlockModificationCount();
            UtilsKt.publishGlobalSourceOutOfBlockModificationEvent($project);
            UtilsKt.publishGlobalScriptModuleStateModificationEvent($project);
        }
        if ($invalidationMode.getInvalidateLibraries()) {
            JavaLibraryModificationTracker.incModificationCount((Project)$project);
            UtilsKt.publishGlobalModuleStateModificationEvent($project);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InvalidationMode.values().length];
            try {
                nArray[InvalidationMode.OnlySourceCaches.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InvalidationMode.LibraryAndSourceCaches.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

