/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ExplainInfo;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.PreviewOutputBlocksManager;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputBlock;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputHandlerAdapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/PreviewEditorScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandlerAdapter;", "previewOutputBlocksManager", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/PreviewOutputBlocksManager;", "toolwindowHandler", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandler;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/PreviewOutputBlocksManager;Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandler;Lcom/intellij/openapi/Disposable;)V", "onStart", "", "file", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "handle", "expression", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutput;", "explanations", "", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ExplainInfo;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "error", "message", "", "onFinish", "clear", "printToPreviewEditor", "clearOutputManager", "kotlin.jvm.shared"})
public final class PreviewEditorScratchOutputHandler
extends ScratchOutputHandlerAdapter {
    @NotNull
    private final PreviewOutputBlocksManager previewOutputBlocksManager;
    @NotNull
    private final ScratchOutputHandler toolwindowHandler;
    @NotNull
    private final Disposable parentDisposable;

    public PreviewEditorScratchOutputHandler(@NotNull PreviewOutputBlocksManager previewOutputBlocksManager, @NotNull ScratchOutputHandler toolwindowHandler, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)previewOutputBlocksManager, (String)"previewOutputBlocksManager");
        Intrinsics.checkNotNullParameter((Object)toolwindowHandler, (String)"toolwindowHandler");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.previewOutputBlocksManager = previewOutputBlocksManager;
        this.toolwindowHandler = toolwindowHandler;
        this.parentDisposable = parentDisposable;
    }

    @Override
    public void onStart(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.toolwindowHandler.onStart(file);
    }

    @Override
    public void handle(@NotNull ScratchFile file, @NotNull ScratchExpression expression, @NotNull ScratchOutput output) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.printToPreviewEditor(expression, output);
    }

    @Override
    public void handle(@NotNull ScratchFile file, @NotNull ScratchOutput output) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.toolwindowHandler.handle(file, output);
    }

    @Override
    public void handle(@NotNull ScratchFile file, @NotNull List<ExplainInfo> explanations, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(explanations, (String)"explanations");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.previewOutputBlocksManager.addOutput(explanations, scope);
    }

    @Override
    public void error(@NotNull ScratchFile file, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.toolwindowHandler.error(file, message2);
    }

    @Override
    public void onFinish(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.toolwindowHandler.onFinish(file);
    }

    @Override
    public void clear(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.toolwindowHandler.clear(file);
        this.clearOutputManager();
    }

    private final void printToPreviewEditor(ScratchExpression expression, ScratchOutput output) {
        TransactionGuard.submitTransaction((Disposable)this.parentDisposable, () -> PreviewEditorScratchOutputHandler.printToPreviewEditor$lambda$0(this, expression, output));
    }

    private final void clearOutputManager() {
        TransactionGuard.submitTransaction((Disposable)this.parentDisposable, () -> PreviewEditorScratchOutputHandler.clearOutputManager$lambda$0(this));
    }

    private static final void printToPreviewEditor$lambda$0(PreviewEditorScratchOutputHandler this$0, ScratchExpression $expression, ScratchOutput $output) {
        ScratchOutputBlock scratchOutputBlock = this$0.previewOutputBlocksManager.getBlock($expression);
        if (scratchOutputBlock == null) {
            scratchOutputBlock = this$0.previewOutputBlocksManager.addBlockToTheEnd($expression);
        }
        ScratchOutputBlock targetCell = scratchOutputBlock;
        targetCell.addOutput($output);
    }

    private static final void clearOutputManager$lambda$0(PreviewEditorScratchOutputHandler this$0) {
        this$0.previewOutputBlocksManager.clear();
    }
}

