/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.safeDelete;

import com.intellij.ide.IdeBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.searching.inheritors.KotlinSearchUtilKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"getParametersToSearch", "", "Lcom/intellij/psi/PsiElement;", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "checkParametersInMethodHierarchy", "", "parameter", "collectParameterHierarchy", "", "intellij.kotlin.refactorings"})
@SourceDebugExtension(value={"SMAP\npsiParametersUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 psiParametersUtil.kt\norg/jetbrains/kotlin/idea/k2/refactoring/safeDelete/PsiParametersUtilKt\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,79:1\n73#2:80\n1321#3,2:81\n*S KotlinDebug\n*F\n+ 1 psiParametersUtil.kt\norg/jetbrains/kotlin/idea/k2/refactoring/safeDelete/PsiParametersUtilKt\n*L\n33#1:80\n77#1:81,2\n*E\n"})
public final class PsiParametersUtilKt {
    @NotNull
    public static final List<PsiElement> getParametersToSearch(@NotNull KtParameter element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Collection<PsiElement> collection = PsiParametersUtilKt.checkParametersInMethodHierarchy(element);
        if (collection == null) {
            return CollectionsKt.listOf((Object)element);
        }
        Collection<PsiElement> elements = collection;
        return CollectionsKt.toList((Iterable)elements);
    }

    private static final Collection<PsiElement> checkParametersInMethodHierarchy(KtParameter parameter) {
        Collection parametersToDelete;
        KtDeclaration method;
        block5: {
            block4: {
                KtDeclaration ktDeclaration = parameter.getOwnerDeclaration();
                if (ktDeclaration == null) {
                    return null;
                }
                method = ktDeclaration;
                Object[] objectArray = new Object[]{parameter.getName()};
                parametersToDelete = (Collection)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> PsiParametersUtilKt.checkParametersInMethodHierarchy$lambda$0(parameter), JavaRefactoringBundle.message((String)"progress.title.collect.hierarchy", (Object[])objectArray), true, parameter.getProject());
                if (parametersToDelete == null || parametersToDelete.size() <= 1) break block4;
                boolean $i$f$isUnitTestMode = false;
                if (!ApplicationManager.getApplication().isUnitTestMode()) break block5;
            }
            return parametersToDelete;
        }
        Object[] objectArray = new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)method), (ElementDescriptionLocation)((ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT))};
        String string = JavaRefactoringBundle.message((String)"0.is.a.part.of.method.hierarchy.do.you.want.to.delete.multiple.parameters", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message2 = string;
        int exitCode = Messages.showOkCancelDialog((Project)parameter.getProject(), (String)message2, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        return exitCode == 0 ? parametersToDelete : null;
    }

    private static final Set<PsiElement> collectParameterHierarchy(KtParameter parameter) {
        KtDeclaration ktDeclaration = parameter.getOwnerDeclaration();
        KtCallableDeclaration ktCallableDeclaration = ktDeclaration instanceof KtCallableDeclaration ? (KtCallableDeclaration)ktDeclaration : null;
        if (ktCallableDeclaration == null) {
            return SetsKt.emptySet();
        }
        KtCallableDeclaration function = ktCallableDeclaration;
        int parameterIndex = KtPsiUtilKt.parameterIndex((PsiElement)((PsiElement)parameter));
        HashSet parametersToDelete = new HashSet();
        Function1 processElement = arg_0 -> PsiParametersUtilKt.collectParameterHierarchy$lambda$0(parameter, parametersToDelete, parameterIndex, arg_0);
        processElement.invoke((Object)function);
        Sequence $this$forEach$iv = KotlinSearchUtilKt.findHierarchyWithSiblings$default(function, null, 1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processElement.invoke(element$iv);
        }
        return parametersToDelete;
    }

    private static final Collection checkParametersInMethodHierarchy$lambda$0(KtParameter $parameter) {
        return (Collection)ActionsKt.runReadAction(() -> PsiParametersUtilKt.checkParametersInMethodHierarchy$lambda$0$0($parameter));
    }

    private static final Set checkParametersInMethodHierarchy$lambda$0$0(KtParameter $parameter) {
        return PsiParametersUtilKt.collectParameterHierarchy($parameter);
    }

    private static final Unit collectParameterHierarchy$lambda$0(KtParameter $parameter, HashSet $parametersToDelete, int $parameterIndex, PsiElement owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        PsiElement psiElement = owner;
        if (psiElement instanceof KtFunction) {
            if ($parameter.isContextParameter()) {
                PsiParametersUtilKt.collectParameterHierarchy$lambda$0$rememberContextParameter($parameterIndex, $parametersToDelete, (KtCallableDeclaration)owner);
            } else {
                $parametersToDelete.add(((KtFunction)owner).getValueParameters().get($parameterIndex));
            }
        } else if (psiElement instanceof KtProperty) {
            if ($parameter.isContextParameter()) {
                PsiParametersUtilKt.collectParameterHierarchy$lambda$0$rememberContextParameter($parameterIndex, $parametersToDelete, (KtCallableDeclaration)owner);
            }
        } else if (psiElement instanceof PsiMethod) {
            $parametersToDelete.add(((PsiMethod)owner).getParameterList().getParameters()[$parameterIndex]);
        }
        return Unit.INSTANCE;
    }

    private static final void collectParameterHierarchy$lambda$0$rememberContextParameter(int parameterIndex, HashSet<PsiElement> parametersToDelete, KtCallableDeclaration owner) {
        block0: {
            Object object = owner.getModifierList();
            if (object == null || (object = object.getContextReceiverList()) == null || (object = object.contextParameters()) == null || (object = (KtParameter)object.get(parameterIndex)) == null) break block0;
            Object param = object;
            boolean bl = false;
            parametersToDelete.add((PsiElement)param);
        }
    }
}

