/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0094\u0002J\u0013\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010*\u00020\u0011H\u0002J0\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J(\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J8\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0016\b\u0002\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t\u0018\u00010%H\u0002R\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSemicolonBeforeLambdaExpressionFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;)V", "getFamilyName", "", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "findCorrectEndOfCall", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "liftTrailingNodesAndRelocateLastLambda", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "endOfCall", "lastLambdaAcceptor", "nodeBeforeSemicolon", "liftTrailingNodes", "addNodesAfter", "isCallOrDotExpression", "", "(Lcom/intellij/psi/PsiElement;)Z", "topLevelHolder", "Lorg/jetbrains/kotlin/idea/quickfix/AddSemicolonBeforeLambdaExpressionFix$TopExpressionAndHolder;", "makeNewExpressionsFromTrailingLambdas", "oldCallExpression", "endOfArguments", "lastLambdaHandler", "Lkotlin/Function1;", "TopExpressionAndHolder", "kotlin.fir.frontend-independent"})
public final class AddSemicolonBeforeLambdaExpressionFix
extends PsiUpdateModCommandAction<KtLambdaExpression> {
    public AddSemicolonBeforeLambdaExpressionFix(@NotNull KtLambdaExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.add.semicolon.lambda.expression", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull KtLambdaExpression element, @NotNull ModPsiUpdater updater2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        PsiElement psiElement2 = element.getParent();
        KtLambdaArgument ktLambdaArgument = psiElement2 instanceof KtLambdaArgument ? (KtLambdaArgument)psiElement2 : null;
        if (ktLambdaArgument == null) {
            return;
        }
        KtLambdaArgument lambdaExpressionArgument = ktLambdaArgument;
        PsiElement psiElement3 = lambdaExpressionArgument.getParent();
        KtCallExpression ktCallExpression = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        PsiElement psiElement4 = this.findCorrectEndOfCall(lambdaExpressionArgument);
        if (psiElement4 == null) {
            return;
        }
        PsiElement desiredEndOfCallExpression = psiElement4;
        Project project = context2.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        PsiElement parent = callExpression.getParent();
        if (parent instanceof KtCallExpression) {
            psiElement = this.liftTrailingNodesAndRelocateLastLambda(psiFactory, callExpression, desiredEndOfCallExpression, parent, (PsiElement)callExpression);
        } else if (parent instanceof KtDotQualifiedExpression) {
            PsiElement grandparent = ((KtDotQualifiedExpression)parent).getParent();
            if (((KtDotQualifiedExpression)parent).getReceiverExpression() == callExpression) {
                psiElement = this.liftTrailingNodesAndRelocateLastLambda(psiFactory, callExpression, desiredEndOfCallExpression, parent, (PsiElement)callExpression);
            } else {
                Intrinsics.checkNotNull((Object)grandparent);
                psiElement = this.isCallOrDotExpression(grandparent) ? this.liftTrailingNodesAndRelocateLastLambda(psiFactory, callExpression, desiredEndOfCallExpression, grandparent, parent) : this.liftTrailingNodes(psiFactory, callExpression, desiredEndOfCallExpression, parent);
            }
        } else {
            psiElement = this.liftTrailingNodes(psiFactory, callExpression, desiredEndOfCallExpression, (PsiElement)callExpression);
        }
        PsiElement addedSemicolon = psiElement;
        updater2.moveCaretTo(addedSemicolon);
    }

    private final PsiElement findCorrectEndOfCall(KtLambdaArgument $this$findCorrectEndOfCall) {
        PsiElement psiElement = PsiTreeUtil.findSiblingBackward((PsiElement)((PsiElement)$this$findCorrectEndOfCall), (IElementType)KtNodeTypes.LAMBDA_ARGUMENT, null);
        if (psiElement == null) {
            psiElement = PsiTreeUtil.findSiblingBackward((PsiElement)((PsiElement)$this$findCorrectEndOfCall), (IElementType)KtNodeTypes.VALUE_ARGUMENT_LIST, null);
        }
        return psiElement;
    }

    private final PsiElement liftTrailingNodesAndRelocateLastLambda(KtPsiFactory psiFactory, KtCallExpression callExpression, PsiElement endOfCall, PsiElement lastLambdaAcceptor, PsiElement nodeBeforeSemicolon) {
        TopExpressionAndHolder topExpressionAndHolder = this.topLevelHolder(callExpression);
        PsiElement topCall = topExpressionAndHolder.component1();
        PsiElement callHolder = topExpressionAndHolder.component2();
        PsiElement semicolon = callHolder.addBefore(psiFactory.createSemicolon(), topCall);
        Intrinsics.checkNotNull((Object)semicolon);
        this.makeNewExpressionsFromTrailingLambdas(callExpression, endOfCall, semicolon, (Function1<? super PsiElement, Unit>)((Function1)arg_0 -> AddSemicolonBeforeLambdaExpressionFix.liftTrailingNodesAndRelocateLastLambda$lambda$0(lastLambdaAcceptor, nodeBeforeSemicolon, arg_0)));
        callHolder.addBefore(nodeBeforeSemicolon, semicolon);
        nodeBeforeSemicolon.delete();
        return semicolon;
    }

    private final PsiElement liftTrailingNodes(KtPsiFactory psiFactory, KtCallExpression callExpression, PsiElement endOfCall, PsiElement addNodesAfter) {
        AddSemicolonBeforeLambdaExpressionFix.makeNewExpressionsFromTrailingLambdas$default(this, callExpression, endOfCall, addNodesAfter, null, 8, null);
        PsiElement psiElement = addNodesAfter.getParent().addAfter(psiFactory.createSemicolon(), addNodesAfter);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"addAfter(...)");
        return psiElement;
    }

    private final boolean isCallOrDotExpression(PsiElement $this$isCallOrDotExpression) {
        return $this$isCallOrDotExpression instanceof KtCallExpression || $this$isCallOrDotExpression instanceof KtDotQualifiedExpression;
    }

    private final TopExpressionAndHolder topLevelHolder(KtCallExpression callExpression) {
        PsiElement me = (PsiElement)callExpression;
        PsiElement psiElement = callExpression.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement parent = psiElement;
        while (this.isCallOrDotExpression(parent)) {
            me = parent;
            Intrinsics.checkNotNullExpressionValue((Object)parent.getParent(), (String)"getParent(...)");
        }
        return new TopExpressionAndHolder(me, parent);
    }

    private final void makeNewExpressionsFromTrailingLambdas(KtCallExpression oldCallExpression, PsiElement endOfArguments, PsiElement addNodesAfter, Function1<? super PsiElement, Unit> lastLambdaHandler) {
        PsiElement lastSibling = oldCallExpression.getLastChild();
        boolean lastLambdaWasProcessed = false;
        while (!Intrinsics.areEqual((Object)lastSibling, (Object)endOfArguments)) {
            if (lastSibling instanceof KtLambdaArgument) {
                PsiElement lambdaExpression;
                KtLambdaExpression ktLambdaExpression = ((KtLambdaArgument)lastSibling).getLambdaExpression();
                PsiElement psiElement = lambdaExpression = ktLambdaExpression != null ? (PsiElement)ktLambdaExpression : lastSibling;
                if (lastLambdaHandler != null && !lastLambdaWasProcessed) {
                    lastLambdaWasProcessed = true;
                    lastLambdaHandler.invoke((Object)lambdaExpression);
                    v2 = Unit.INSTANCE;
                } else {
                    v2 = addNodesAfter.getParent().addAfter(lambdaExpression, addNodesAfter);
                }
            } else {
                v2 = addNodesAfter.getParent().addAfter(lastSibling, addNodesAfter);
            }
            lastSibling = lastSibling.getPrevSibling();
        }
        oldCallExpression.deleteChildRange(endOfArguments.getNextSibling(), oldCallExpression.getLastChild());
    }

    static /* synthetic */ void makeNewExpressionsFromTrailingLambdas$default(AddSemicolonBeforeLambdaExpressionFix addSemicolonBeforeLambdaExpressionFix, KtCallExpression ktCallExpression, PsiElement psiElement, PsiElement psiElement2, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        addSemicolonBeforeLambdaExpressionFix.makeNewExpressionsFromTrailingLambdas(ktCallExpression, psiElement, psiElement2, (Function1<? super PsiElement, Unit>)function1);
    }

    private static final Unit liftTrailingNodesAndRelocateLastLambda$lambda$0(PsiElement $lastLambdaAcceptor, PsiElement $nodeBeforeSemicolon, PsiElement lastLambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)lastLambdaExpression, (String)"lastLambdaExpression");
        $lastLambdaAcceptor.addAfter(lastLambdaExpression, $nodeBeforeSemicolon);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSemicolonBeforeLambdaExpressionFix$TopExpressionAndHolder;", "", "top", "Lcom/intellij/psi/PsiElement;", "holder", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "getTop", "()Lcom/intellij/psi/PsiElement;", "getHolder", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.fir.frontend-independent"})
    public static final class TopExpressionAndHolder {
        @NotNull
        private final PsiElement top;
        @NotNull
        private final PsiElement holder;

        public TopExpressionAndHolder(@NotNull PsiElement top, @NotNull PsiElement holder2) {
            Intrinsics.checkNotNullParameter((Object)top, (String)"top");
            Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
            this.top = top;
            this.holder = holder2;
        }

        @NotNull
        public final PsiElement getTop() {
            return this.top;
        }

        @NotNull
        public final PsiElement getHolder() {
            return this.holder;
        }

        @NotNull
        public final PsiElement component1() {
            return this.top;
        }

        @NotNull
        public final PsiElement component2() {
            return this.holder;
        }

        @NotNull
        public final TopExpressionAndHolder copy(@NotNull PsiElement top, @NotNull PsiElement holder2) {
            Intrinsics.checkNotNullParameter((Object)top, (String)"top");
            Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
            return new TopExpressionAndHolder(top, holder2);
        }

        public static /* synthetic */ TopExpressionAndHolder copy$default(TopExpressionAndHolder topExpressionAndHolder, PsiElement psiElement, PsiElement psiElement2, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement = topExpressionAndHolder.top;
            }
            if ((n & 2) != 0) {
                psiElement2 = topExpressionAndHolder.holder;
            }
            return topExpressionAndHolder.copy(psiElement, psiElement2);
        }

        @NotNull
        public String toString() {
            return "TopExpressionAndHolder(top=" + this.top + ", holder=" + this.holder + ")";
        }

        public int hashCode() {
            int result2 = this.top.hashCode();
            result2 = result2 * 31 + this.holder.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TopExpressionAndHolder)) {
                return false;
            }
            TopExpressionAndHolder topExpressionAndHolder = (TopExpressionAndHolder)other;
            if (!Intrinsics.areEqual((Object)this.top, (Object)topExpressionAndHolder.top)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.holder, (Object)topExpressionAndHolder.holder);
        }
    }
}

