/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.InputStream;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.api.OpenPGPDefaultPolicy;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.bc.BcOpenPGPImplementation;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilderProvider;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;

public abstract class OpenPGPImplementation {
    private static OpenPGPImplementation INSTANCE;
    private OpenPGPPolicy policy = new OpenPGPDefaultPolicy();

    public static void setInstance(OpenPGPImplementation openPGPImplementation) {
        INSTANCE = openPGPImplementation;
    }

    public static OpenPGPImplementation getInstance() {
        if (INSTANCE == null) {
            OpenPGPImplementation.setInstance(new BcOpenPGPImplementation());
        }
        return INSTANCE;
    }

    public OpenPGPPolicy policy() {
        return this.policy;
    }

    public OpenPGPImplementation setPolicy(OpenPGPPolicy openPGPPolicy) {
        this.policy = openPGPPolicy;
        return this;
    }

    public abstract PGPObjectFactory pgpObjectFactory(InputStream var1);

    public abstract PGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider();

    public abstract PBESecretKeyDecryptorBuilderProvider pbeSecretKeyDecryptorBuilderProvider();

    public abstract PGPDataEncryptorBuilder pgpDataEncryptorBuilder(int var1);

    public abstract PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator(PGPPublicKey var1);

    public abstract PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] var1);

    public abstract PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] var1, S2K.Argon2Params var2);

    public abstract PGPContentSignerBuilder pgpContentSignerBuilder(int var1, int var2);

    public abstract PBEDataDecryptorFactory pbeDataDecryptorFactory(char[] var1) throws PGPException;

    public abstract SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory(PGPSessionKey var1);

    public abstract PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory(PGPPrivateKey var1);

    public abstract PGPDigestCalculatorProvider pgpDigestCalculatorProvider() throws PGPException;

    public abstract PGPKeyPairGeneratorProvider pgpKeyPairGeneratorProvider();

    public abstract PGPContentSignerBuilderProvider pgpContentSignerBuilderProvider(int var1);

    public abstract KeyFingerPrintCalculator keyFingerPrintCalculator();

    public abstract PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean var1) throws PGPException;

    public abstract PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean var1, int var2, int var3) throws PGPException;
}

