/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.modeling.ngram;

import com.intellij.completion.ngram.slp.counting.Counter;
import com.intellij.completion.ngram.slp.counting.trie.MapTrieCounter;
import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0016\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/ngram/ADModel;", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;", "order", "", "counter", "Lcom/intellij/completion/ngram/slp/counting/Counter;", "(ILcom/intellij/completion/ngram/slp/counting/Counter;)V", "config", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel$Config;", "getConfig", "()Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel$Config;", "modelWithConfidence", "Lkotlin/Pair;", "", "subList", "", "counts", "", "bd0177eacd27ae4e"})
public final class ADModel
extends NGramModel {
    @NotNull
    private final NGramModel.Config config;

    @Override
    @NotNull
    protected Pair<Double, Double> modelWithConfidence(@NotNull List<Integer> subList, @NotNull long[] counts) {
        Intrinsics.checkParameterIsNotNull(subList, (String)"subList");
        Intrinsics.checkParameterIsNotNull((Object)counts, (String)"counts");
        long count = counts[0];
        long contextCount = counts[1];
        int n1 = this.getCounter().getCountOfCount(subList.size(), 1);
        int n2 = this.getCounter().getCountOfCount(subList.size(), 2);
        double D = (double)n1 / ((double)n1 + (double)(2 * n2));
        int[] distinctContext = this.getCounter().getDistinctCounts(1, subList.subList(0, subList.size() - 1));
        int N1Plus = distinctContext[0];
        double d = 0.0;
        double d2 = (double)count - D;
        boolean bl = false;
        double MLEDisc = Math.max(d, d2) / (double)contextCount;
        double lambda = 1.0 - (double)N1Plus * D / (double)contextCount;
        return new Pair((Object)(MLEDisc / lambda), (Object)lambda);
    }

    @Override
    @NotNull
    protected NGramModel.Config getConfig() {
        return this.config;
    }

    public ADModel(int order, @NotNull Counter counter) {
        Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
        super(order, counter);
        this.config = new NGramModel.Config(order, String.valueOf(this.getClass()));
    }

    public /* synthetic */ ADModel(int n, Counter counter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 6;
        }
        if ((n2 & 2) != 0) {
            counter = new MapTrieCounter();
        }
        this(n, counter);
    }

    public ADModel() {
        this(0, null, 3, null);
    }
}

