/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency;

import java.io.IOException;
import java.util.function.Function;
import org.jetbrains.jps.dependency.DataReader;
import org.jetbrains.jps.dependency.DataWriter;
import org.jetbrains.jps.dependency.ExternalizableGraphElement;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;

public interface Externalizer<T>
extends DataReader<T>,
DataWriter<T> {
    public T[] createStorage(int var1);

    public static <T extends ExternalizableGraphElement> Externalizer<T> forGraphElement(final DataReader<? extends T> reader, final Function<Integer, T[]> arrayFactory) {
        return new Externalizer<T>(){

            @Override
            public T[] createStorage(int size) {
                return (ExternalizableGraphElement[])arrayFactory.apply(size);
            }

            @Override
            public T load(GraphDataInput in) throws IOException {
                return (ExternalizableGraphElement)reader.load(in);
            }

            @Override
            public void save(GraphDataOutput out, T value) throws IOException {
                value.write(out);
            }
        };
    }

    public static <T extends ExternalizableGraphElement> Externalizer<T> forAnyGraphElement(final Function<Integer, T[]> arrayFactory) {
        return new Externalizer<T>(){

            @Override
            public T[] createStorage(int size) {
                return (ExternalizableGraphElement[])arrayFactory.apply(size);
            }

            @Override
            public T load(GraphDataInput in) throws IOException {
                return in.readGraphElement();
            }

            @Override
            public void save(GraphDataOutput out, T value) throws IOException {
                out.writeGraphElement(value);
            }
        };
    }
}

