/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.Proto;

public final class ModuleRequires
extends Proto
implements DiffCapable<ModuleRequires, Diff> {
    private final String myVersion;

    public ModuleRequires(JVMFlags flags, String name, String version) {
        super(flags, "", name, Collections.emptyList());
        this.myVersion = version == null ? "" : version;
    }

    public ModuleRequires(GraphDataInput in) throws IOException {
        super(in);
        this.myVersion = in.readUTF();
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myVersion);
    }

    public boolean isTransitive() {
        return this.getFlags().isTransitive();
    }

    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public boolean isSame(DiffCapable<?, ?> other) {
        return other instanceof ModuleRequires && this.getName().equals(((ModuleRequires)other).getName());
    }

    @Override
    public int diffHashCode() {
        return this.getName().hashCode();
    }

    @Override
    public Diff difference(ModuleRequires past) {
        return new Diff(past);
    }

    public final class Diff
    extends Proto.Diff<ModuleRequires> {
        public Diff(ModuleRequires past) {
            super((Proto)ModuleRequires.this, (Proto)past);
        }

        @Override
        public boolean unchanged() {
            return super.unchanged() && !this.versionChanged();
        }

        public boolean versionChanged() {
            return !Objects.equals(((ModuleRequires)this.myPast).getVersion(), ModuleRequires.this.getVersion());
        }

        public boolean becameNonTransitive() {
            return ((ModuleRequires)this.myPast).getFlags().isTransitive() && !ModuleRequires.this.getFlags().isTransitive();
        }
    }
}

