/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.tools.combined.CombinedBlockId;
import com.intellij.diff.tools.combined.CombinedDiffComponentProcessor;
import com.intellij.diff.tools.combined.CombinedDiffKeysKt;
import com.intellij.diff.tools.combined.CombinedDiffViewer;
import com.intellij.diff.tools.combined.CombinedPathBlockId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.actions.diff.CombinedDiffManagerImplKt;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDiffPreviewHandler;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"refreshCombinedDiffProcessor", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "processor", "Lcom/intellij/diff/tools/combined/CombinedDiffComponentProcessor;", "handler", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;", "onlyBlockSelection", "", "toCombinedPathBlockId", "Lcom/intellij/diff/tools/combined/CombinedPathBlockId;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "intellij.platform.vcs.impl"})
public final class TreeHandlerDiffRequestProcessorKt {
    private static final void refreshCombinedDiffProcessor(ChangesTree tree, CombinedDiffComponentProcessor processor2, ChangesTreeDiffPreviewHandler handler, boolean onlyBlockSelection) {
        CombinedPathBlockId newSelectedBlockId;
        boolean keepSelection;
        CombinedDiffViewer combinedDiffViewer = (CombinedDiffViewer)processor2.getContext().getUserData(CombinedDiffKeysKt.getCOMBINED_DIFF_VIEWER_KEY());
        JBIterable jBIterable = JBIterable.from(handler.iterateSelectedChanges(tree));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable selectedChanges = jBIterable;
        CombinedDiffViewer combinedDiffViewer2 = combinedDiffViewer;
        CombinedBlockId combinedBlockId = combinedDiffViewer2 != null ? combinedDiffViewer2.getCurrentBlockId() : null;
        CombinedPathBlockId prevSelectedBlockId = combinedBlockId instanceof CombinedPathBlockId ? (CombinedPathBlockId)combinedBlockId : null;
        boolean bl = keepSelection = prevSelectedBlockId != null && selectedChanges.find(arg_0 -> TreeHandlerDiffRequestProcessorKt.refreshCombinedDiffProcessor$lambda$1(arg_0 -> TreeHandlerDiffRequestProcessorKt.refreshCombinedDiffProcessor$lambda$0(prevSelectedBlockId, arg_0), arg_0)) != null;
        if (keepSelection) {
            v3 = prevSelectedBlockId;
        } else {
            ChangeViewDiffRequestProcessor.Wrapper wrapper2 = (ChangeViewDiffRequestProcessor.Wrapper)CollectionsKt.firstOrNull((Iterable)((Iterable)selectedChanges));
            v3 = newSelectedBlockId = wrapper2 != null ? TreeHandlerDiffRequestProcessorKt.toCombinedPathBlockId(wrapper2) : null;
        }
        if (onlyBlockSelection) {
            if (newSelectedBlockId != null && !keepSelection) {
                CombinedDiffViewer combinedDiffViewer3 = combinedDiffViewer;
                if (combinedDiffViewer3 != null) {
                    combinedDiffViewer3.scrollToFirstChange((CombinedBlockId)newSelectedBlockId, false, CombinedDiffViewer.ScrollPolicy.SCROLL_TO_BLOCK);
                }
            }
        } else {
            processor2.getContext().putUserData(CombinedDiffKeysKt.getCOMBINED_DIFF_SCROLL_TO_BLOCK(), (Object)newSelectedBlockId);
            List changes = CollectionsKt.toList(handler.iterateAllChanges(tree));
            if (!((Collection)changes).isEmpty()) {
                Project project = tree.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                processor2.setBlocks(CombinedDiffManagerImplKt.prepareCombinedBlocksFromWrappers(project, changes));
            }
        }
    }

    private static final CombinedPathBlockId toCombinedPathBlockId(ChangeViewDiffRequestProcessor.Wrapper $this$toCombinedPathBlockId) {
        FilePath filePath = $this$toCombinedPathBlockId.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return new CombinedPathBlockId(filePath, $this$toCombinedPathBlockId.getFileStatus(), (Object)$this$toCombinedPathBlockId.getTag());
    }

    private static final boolean refreshCombinedDiffProcessor$lambda$0(CombinedPathBlockId $prevSelectedBlockId, ChangeViewDiffRequestProcessor.Wrapper it) {
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)TreeHandlerDiffRequestProcessorKt.toCombinedPathBlockId(it), (Object)$prevSelectedBlockId);
    }

    private static final boolean refreshCombinedDiffProcessor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$refreshCombinedDiffProcessor(ChangesTree tree, CombinedDiffComponentProcessor processor2, ChangesTreeDiffPreviewHandler handler, boolean onlyBlockSelection) {
        TreeHandlerDiffRequestProcessorKt.refreshCombinedDiffProcessor(tree, processor2, handler, onlyBlockSelection);
    }
}

