/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiJavaModuleReferenceImpl
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement>
implements PsiJavaModuleReference {
    public PsiJavaModuleReferenceImpl(@NotNull PsiJavaModuleReferenceElement element) {
        if (element == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(0);
        }
        super(element, new TextRange(0, element.getTextLength()), false);
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
        if (string == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public PsiJavaModule resolve() {
        return (PsiJavaModule)super.resolve();
    }

    @Override
    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, Resolver.INSTANCE, false, incompleteCode);
        if (resolveResultArray == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
        PsiJavaModuleReferenceElement element;
        if (newName == null) {
            PsiJavaModuleReferenceImpl.$$$reportNull$$$0(3);
        }
        if ((element = (PsiJavaModuleReferenceElement)this.getElement()) instanceof PsiCompiledElement) {
            throw new IncorrectOperationException(JavaPsiBundle.message("psi.error.attempt.to.edit.class.file", element.getContainingFile()));
        }
        PsiJavaModuleReferenceElement newElement = PsiElementFactory.getInstance(element.getProject()).createModuleReferenceFromText(newName, null);
        return element.replace(newElement);
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReferenceImpl> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReferenceImpl> INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        public ResolveResult @NotNull [] resolve(@NotNull PsiJavaModuleReferenceImpl reference2, boolean incompleteCode) {
            PsiJavaModule module2;
            if (reference2 == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            PsiJavaModuleReferenceElement refElement = (PsiJavaModuleReferenceElement)reference2.getElement();
            PsiFile file = refElement.getContainingFile();
            String moduleName2 = reference2.getCanonicalText();
            if (file instanceof PsiJavaFile && (module2 = ((PsiJavaFile)file).getModuleDeclaration()) != null && module2.getName().equals(moduleName2)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(module2)};
                if (resolveResultArray == null) {
                    Resolver.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }
            boolean global = incompleteCode || refElement.getParent() instanceof PsiPackageAccessibilityStatement;
            Project project = file.getProject();
            GlobalSearchScope scope2 = global ? GlobalSearchScope.allScope(project) : file.getResolveScope();
            Collection<PsiJavaModule> modules2 = JavaPsiFacade.getInstance(project).findModules(moduleName2, scope2);
            if (!modules2.isEmpty()) {
                ResolveResult[] result2 = new ResolveResult[modules2.size()];
                int i2 = 0;
                for (PsiJavaModule module3 : modules2) {
                    result2[i2++] = new PsiElementResolveResult(module3);
                }
                if (result2 == null) {
                    Resolver.$$$reportNull$$$0(2);
                }
                return result2;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                Resolver.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl$Resolver";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaModuleReferenceImpl$Resolver";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

