/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.backend.shellcheck.intention;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.ShBundle;
import com.intellij.sh.backend.shellcheck.ShShellcheckInspection;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShDisableInspectionIntention
implements IntentionAction,
LowPriorityAction,
Iconable {
    private final String myInspectionCode;
    private final String myMessage;

    public ShDisableInspectionIntention(String message, String inspectionCode) {
        this.myInspectionCode = inspectionCode;
        this.myMessage = message;
    }

    @NotNull
    public String getText() {
        String string = ShBundle.message((String)"sh.disable.inspection.text", (Object[])new Object[]{this.myMessage});
        if (string == null) {
            ShDisableInspectionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = ShBundle.message((String)"sh.shell.script", (Object[])new Object[0]);
        if (string == null) {
            ShDisableInspectionIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            ShDisableInspectionIntention.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            ShDisableInspectionIntention.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            return;
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> {
            ShShellcheckInspection tool = (ShShellcheckInspection)it.getUnwrappedTool("ShellCheck", (PsiElement)psiFile);
            if (tool != null) {
                tool.disableInspection(this.myInspectionCode);
            }
        });
        DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile, (Object)this);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            ShDisableInspectionIntention.$$$reportNull$$$0(4);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/backend/shellcheck/intention/ShDisableInspectionIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/backend/shellcheck/intention/ShDisableInspectionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

