/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.startup;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.startup.GradleProjectSettingsUpdaterKt;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\n\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater;", "Lcom/intellij/openapi/externalSystem/settings/ExternalSystemSettingsListenerEx;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "onProjectsLoaded", "", "project", "Lcom/intellij/openapi/project/Project;", "manager", "Lcom/intellij/openapi/externalSystem/ExternalSystemManager;", "settings", "", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "UpdatedSdkStatus", "Util", "intellij.gradle"})
public final class GradleProjectSettingsUpdater
implements ExternalSystemSettingsListenerEx {
    @NotNull
    private final CoroutineScope cs;

    public GradleProjectSettingsUpdater(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
    }

    public void onProjectsLoaded(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (Registry.Companion.is("gradle.auto.auto.jdk.fix.disabled")) {
            return;
        }
        if (!(manager instanceof GradleManager)) {
            return;
        }
        TrackingUtil.launchTracked$default((CoroutineScope)this.cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(settings, project, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ Collection<ExternalProjectSettings> $settings;
            final /* synthetic */ Project $project;
            {
                this.$settings = $settings;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = this.$settings.iterator();
lbl6:
                        // 4 sources

                        while (var2_3.hasNext()) {
                            projectSettings = (ExternalProjectSettings)var2_3.next();
                            if (!(projectSettings instanceof GradleProjectSettings)) continue;
                            this.L$0 = var2_3;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)projectSettings);
                            this.label = 1;
                            v0 = GradleProjectSettingsUpdaterKt.fixGradleJvm(this.$project, (GradleProjectSettings)projectSettings, (Continuation<? super Unit>)((Continuation)this));
                            if (v0 != var4_2) continue;
                            return var4_2;
                        }
                        break;
                    }
                    case 1: {
                        projectSettings = (ExternalProjectSettings)this.L$1;
                        var2_3 = (Iterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$UpdatedSdkStatus;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdkName", "", "updated", "", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Z)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getSdkName", "()Ljava/lang/String;", "getUpdated", "()Z", "intellij.gradle"})
    public static final class UpdatedSdkStatus {
        @Nullable
        private final Sdk sdk;
        @Nullable
        private final String sdkName;
        private final boolean updated;

        public UpdatedSdkStatus(@Nullable Sdk sdk, @Nullable String sdkName, boolean updated) {
            this.sdk = sdk;
            this.sdkName = sdkName;
            this.updated = updated;
        }

        @Nullable
        public final Sdk getSdk() {
            return this.sdk;
        }

        @Nullable
        public final String getSdkName() {
            return this.sdkName;
        }

        public final boolean getUpdated() {
            return this.updated;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0015\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$Util;", "", "<init>", "()V", "NOT_UPDATED_STATUS", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$UpdatedSdkStatus;", "kotlin.jvm.PlatformType", "updateGradleJvm", "project", "Lcom/intellij/openapi/project/Project;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "fixupInternalJdk", "fixupUnknownSdk", "isUnknownSdk", "", "sdkName", "", "isSdkName", "jdkReference", "isInternalSdk", "findRegisteredSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "intellij.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleProjectSettingsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectSettingsUpdater.kt\norg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        private static final CompletableFuture<UpdatedSdkStatus> NOT_UPDATED_STATUS = CompletableFuture.completedFuture(new UpdatedSdkStatus(null, null, false));

        private Util() {
        }

        @NotNull
        public final CompletableFuture<UpdatedSdkStatus> updateGradleJvm(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
            CompletableFuture<UpdatedSdkStatus> completableFuture;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
            String string = projectSettings.getGradleJvm();
            if (string == null) {
                CompletableFuture<UpdatedSdkStatus> completableFuture2 = NOT_UPDATED_STATUS;
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"NOT_UPDATED_STATUS");
                return completableFuture2;
            }
            String gradleJvm = string;
            if (this.isInternalSdk(gradleJvm)) {
                completableFuture = this.fixupInternalJdk(project, projectSettings);
            } else if (this.isSdkName(gradleJvm) && this.isUnknownSdk(gradleJvm)) {
                completableFuture = this.fixupUnknownSdk(project, projectSettings);
            } else {
                CompletableFuture<UpdatedSdkStatus> completableFuture3 = NOT_UPDATED_STATUS;
                completableFuture = completableFuture3;
                Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"NOT_UPDATED_STATUS");
            }
            return completableFuture;
        }

        private final CompletableFuture<UpdatedSdkStatus> fixupInternalJdk(Project project, GradleProjectSettings projectSettings) {
            ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
            Sdk sdk = jdkProvider.getInternalJdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"getInternalJdk(...)");
            Sdk internalSdk = sdk;
            projectSettings.setGradleJvm(internalSdk.getName());
            return this.fixupUnknownSdk(project, projectSettings);
        }

        private final CompletableFuture<UpdatedSdkStatus> fixupUnknownSdk(Project project, GradleProjectSettings projectSettings) {
            String string = projectSettings.getGradleJvm();
            if (string == null) {
                CompletableFuture<UpdatedSdkStatus> completableFuture = NOT_UPDATED_STATUS;
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"NOT_UPDATED_STATUS");
                return completableFuture;
            }
            String gradleJvm = string;
            GradleVersion gradleVersion = projectSettings.resolveGradleVersion();
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"resolveGradleVersion(...)");
            GradleVersion gradleVersion2 = gradleVersion;
            CompletableFuture<UpdatedSdkStatus> future = new CompletableFuture<UpdatedSdkStatus>();
            projectSettings.setGradleJvm(null);
            SdkLookupBuilder sdkLookupBuilder = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, projectSettings).newLookupBuilder().withSdkName(gradleJvm).withVersionFilter(arg_0 -> Util.fixupUnknownSdk$lambda$0(gradleVersion2, arg_0));
            SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"getJavaSdkType(...)");
            sdkLookupBuilder.withSdkType(sdkType).withSdkHomeFilter(Util::fixupUnknownSdk$lambda$1).onSdkNameResolved(arg_0 -> Util.fixupUnknownSdk$lambda$2(projectSettings, arg_0)).onSdkResolved(arg_0 -> Util.fixupUnknownSdk$lambda$3(projectSettings, gradleJvm, future, arg_0)).executeLookup();
            return future;
        }

        private final boolean isUnknownSdk(String sdkName) {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            Sdk sdk = projectJdkTable.findJdk(sdkName);
            return sdk == null;
        }

        private final boolean isSdkName(String jdkReference) {
            return jdkReference != null && !StringsKt.startsWith$default((CharSequence)jdkReference, (char)'#', (boolean)false, (int)2, null);
        }

        private final boolean isInternalSdk(String jdkReference) {
            return Intrinsics.areEqual((Object)jdkReference, (Object)"#JAVA_INTERNAL");
        }

        private final Sdk findRegisteredSdk(Sdk sdk) {
            return (Sdk)ActionsKt.runReadAction(() -> Util.findRegisteredSdk$lambda$0(sdk));
        }

        private static final boolean fixupUnknownSdk$lambda$0(GradleVersion $gradleVersion, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JavaVersion javaVersion = JavaVersion.Companion.tryParse(it);
            return javaVersion != null && GradleJvmSupportMatrix.Companion.isJavaSupportedByIdea(javaVersion) && GradleJvmSupportMatrix.Companion.isSupported($gradleVersion, javaVersion);
        }

        private static final boolean fixupUnknownSdk$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ExternalSystemJdkUtil.isValidJdk((String)it);
        }

        private static final Unit fixupUnknownSdk$lambda$2(GradleProjectSettings $projectSettings, Sdk sdk) {
            Sdk fakeSdk;
            Sdk sdk2 = sdk;
            if (sdk2 != null) {
                Sdk sdk3 = sdk2;
                Util util = INSTANCE;
                Sdk p0 = sdk3;
                boolean bl = false;
                v1 = util.findRegisteredSdk(p0);
            } else {
                v1 = fakeSdk = null;
            }
            if (fakeSdk != null && $projectSettings.getGradleJvm() == null) {
                $projectSettings.setGradleJvm(fakeSdk.getName());
            }
            return Unit.INSTANCE;
        }

        private static final Unit fixupUnknownSdk$lambda$3(GradleProjectSettings $projectSettings, String $gradleJvm, CompletableFuture $future, Sdk sdk) {
            if ($projectSettings.getGradleJvm() == null) {
                Object object = sdk;
                if (object == null || (object = object.getName()) == null) {
                    object = $gradleJvm;
                }
                $projectSettings.setGradleJvm((String)object);
            }
            $future.complete(new UpdatedSdkStatus(sdk, $gradleJvm, true));
            return Unit.INSTANCE;
        }

        private static final Sdk findRegisteredSdk$lambda$0(Sdk $sdk) {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            return projectJdkTable.findJdk($sdk.getName(), $sdk.getSdkType().getName());
        }
    }
}

