/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import org.jetbrains.coverage.org.objectweb.asm.ByteVector;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodWriter;
import org.jetbrains.coverage.org.objectweb.asm.Opcodes;
import org.jetbrains.coverage.org.objectweb.asm.Symbol;
import org.jetbrains.coverage.org.objectweb.asm.SymbolTable;
import org.jetbrains.coverage.org.objectweb.asm.Type;

class Frame {
    Label owner;
    private int[] inputLocals;
    private int[] inputStack;
    private int[] outputLocals;
    private int[] outputStack;
    private short outputStackStart;
    private short outputStackTop;
    private int initializationCount;
    private int[] initializations;

    /*
     * WARNING - void declaration
     */
    Frame(Label owner) {
        void var1_1;
        this.owner = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void copyFrom(Frame frame) {
        void var1_1;
        this.inputLocals = frame.inputLocals;
        this.inputStack = frame.inputStack;
        this.outputStackStart = 0;
        this.outputLocals = frame.outputLocals;
        this.outputStack = frame.outputStack;
        this.outputStackTop = frame.outputStackTop;
        this.initializationCount = frame.initializationCount;
        this.initializations = var1_1.initializations;
    }

    /*
     * WARNING - void declaration
     */
    static int getAbstractTypeFromApiFormat(SymbolTable symbolTable, Object type) {
        SymbolTable symbolTable2;
        void var1_1;
        if (type instanceof Integer) {
            return 0x400000 | (Integer)type;
        }
        if (type instanceof String) {
            String descriptor = Type.getObjectType((String)type).getDescriptor();
            return Frame.getAbstractTypeFromDescriptor(symbolTable, (String)var1_1, 0);
        }
        return 0xC00000 | symbolTable2.addUninitializedType("", ((Label)var1_1).bytecodeOffset);
    }

    /*
     * WARNING - void declaration
     */
    static int getAbstractTypeFromInternalName(SymbolTable symbolTable, String internalName) {
        void var1_1;
        SymbolTable symbolTable2;
        return 0x800000 | symbolTable2.addType((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int getAbstractTypeFromDescriptor(SymbolTable symbolTable, String buffer, int offset) {
        void var2_3;
        void var1_2;
        switch (buffer.charAt(offset)) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 0x400001;
            }
            case 'F': {
                return 0x400002;
            }
            case 'J': {
                return 0x400004;
            }
            case 'D': {
                return 0x400003;
            }
            case 'L': {
                String internalName = buffer.substring(offset + 1, buffer.length() - 1);
                return 0x800000 | symbolTable.addType(internalName);
            }
            case '[': {
                void var0_1;
                void var3_4;
                String internalName;
                int elementDescriptorOffset = offset + 1;
                while (internalName.charAt(elementDescriptorOffset) == '[') {
                    ++elementDescriptorOffset;
                }
                switch (internalName.charAt(elementDescriptorOffset)) {
                    case 'Z': {
                        int typeValue2 = 0x400009;
                        break;
                    }
                    case 'C': {
                        int typeValue2 = 0x40000B;
                        break;
                    }
                    case 'B': {
                        int typeValue2 = 0x40000A;
                        break;
                    }
                    case 'S': {
                        int typeValue2 = 0x40000C;
                        break;
                    }
                    case 'I': {
                        int typeValue2 = 0x400001;
                        break;
                    }
                    case 'F': {
                        int typeValue2 = 0x400002;
                        break;
                    }
                    case 'J': {
                        int typeValue2 = 0x400004;
                        break;
                    }
                    case 'D': {
                        int typeValue2 = 0x400003;
                        break;
                    }
                    case 'L': {
                        SymbolTable typeValue;
                        internalName = internalName.substring(elementDescriptorOffset + 1, internalName.length() - 1);
                        int typeValue2 = 0x800000 | typeValue.addType((String)var1_2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid descriptor fragment: " + var1_2.substring(elementDescriptorOffset));
                    }
                }
                return var3_4 - offset << 26 | var0_1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + var1_2.substring((int)var2_3));
    }

    /*
     * WARNING - void declaration
     */
    final void setInputFrameFromDescriptor(SymbolTable symbolTable, int access, String descriptor, int maxLocals) {
        void var3_4;
        this.inputLocals = new int[maxLocals];
        this.inputStack = new int[0];
        int inputLocalIndex = 0;
        if ((access & 8) == 0) {
            void var2_2;
            if ((var2_2 & 0x40000) == 0) {
                ++inputLocalIndex;
                SymbolTable symbolTable2 = symbolTable;
                this.inputLocals[0] = 0x800000 | symbolTable2.addType(symbolTable2.getClassName());
            } else {
                ++inputLocalIndex;
                this.inputLocals[0] = 0x400006;
            }
        }
        for (Type argumentType : Type.getArgumentTypes((String)var3_4)) {
            int abstractType = Frame.getAbstractTypeFromDescriptor(symbolTable, argumentType.getDescriptor(), 0);
            this.inputLocals[inputLocalIndex++] = abstractType;
            if (abstractType != 0x400004 && abstractType != 0x400003) continue;
            this.inputLocals[inputLocalIndex++] = 0x400000;
        }
        while (inputLocalIndex < maxLocals) {
            this.inputLocals[inputLocalIndex++] = 0x400000;
        }
    }

    final void setInputFrameFromApiFormat(SymbolTable symbolTable, int numLocal, Object[] local, int numStack, Object[] stack) {
        int inputLocalIndex = 0;
        for (int i = 0; i < numLocal; ++i) {
            this.inputLocals[inputLocalIndex++] = Frame.getAbstractTypeFromApiFormat(symbolTable, local[i]);
            if (local[i] != Opcodes.LONG && local[i] != Opcodes.DOUBLE) continue;
            this.inputLocals[inputLocalIndex++] = 0x400000;
        }
        while (inputLocalIndex < this.inputLocals.length) {
            this.inputLocals[inputLocalIndex++] = 0x400000;
        }
        int numStackTop = 0;
        for (int i = 0; i < numStack; ++i) {
            if (stack[i] != Opcodes.LONG && stack[i] != Opcodes.DOUBLE) continue;
            ++numStackTop;
        }
        this.inputStack = new int[numStack + numStackTop];
        int inputStackIndex = 0;
        for (int i = 0; i < numStack; ++i) {
            this.inputStack[inputStackIndex++] = Frame.getAbstractTypeFromApiFormat(symbolTable, stack[i]);
            if (stack[i] != Opcodes.LONG && stack[i] != Opcodes.DOUBLE) continue;
            this.inputStack[inputStackIndex++] = 0x400000;
        }
        this.outputStackTop = 0;
        this.initializationCount = 0;
    }

    final int getInputStackSize() {
        return this.inputStack.length;
    }

    /*
     * WARNING - void declaration
     */
    private int getLocal(int localIndex) {
        void var2_2;
        if (this.outputLocals == null || localIndex >= this.outputLocals.length) {
            return 0x1000000 | localIndex;
        }
        int abstractType = this.outputLocals[localIndex];
        if (abstractType == 0) {
            void var1_1;
            abstractType = this.outputLocals[localIndex] = 0x1000000 | var1_1;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void setLocal(int localIndex, int abstractType) {
        void var2_2;
        int outputLocalsLength;
        if (this.outputLocals == null) {
            this.outputLocals = new int[10];
        }
        if (localIndex >= (outputLocalsLength = this.outputLocals.length)) {
            void var3_3;
            int[] newOutputLocals = new int[Math.max(localIndex + 1, 2 * outputLocalsLength)];
            System.arraycopy(this.outputLocals, 0, newOutputLocals, 0, (int)var3_3);
            this.outputLocals = newOutputLocals;
        }
        this.outputLocals[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void push(int abstractType) {
        void var1_1;
        int outputStackLength;
        if (this.outputStack == null) {
            this.outputStack = new int[10];
        }
        if (this.outputStackTop >= (outputStackLength = this.outputStack.length)) {
            void var2_2;
            int[] newOutputStack = new int[Math.max(this.outputStackTop + 1, 2 * outputStackLength)];
            System.arraycopy(this.outputStack, 0, newOutputStack, 0, (int)var2_2);
            this.outputStack = newOutputStack;
        }
        short s = this.outputStackTop;
        this.outputStackTop = (short)(s + 1);
        this.outputStack[s] = var1_1;
        short outputStackSize = (short)(this.outputStackStart + this.outputStackTop);
        if (outputStackSize > this.owner.outputStackMax) {
            void var3_4;
            this.owner.outputStackMax = var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void push(SymbolTable symbolTable, String descriptor) {
        void var3_4;
        void var2_3;
        int typeDescriptorOffset = descriptor.charAt(0) == '(' ? Type.getReturnTypeOffset(descriptor) : 0;
        int abstractType = Frame.getAbstractTypeFromDescriptor(symbolTable, (String)var2_3, (int)var3_4);
        if (abstractType != 0) {
            void var1_2;
            this.push(abstractType);
            if (abstractType == 0x400004 || var1_2 == 0x400003) {
                this.push(0x400000);
            }
        }
    }

    private int pop() {
        if (this.outputStackTop > 0) {
            this.outputStackTop = (short)(this.outputStackTop - 1);
            return this.outputStack[this.outputStackTop];
        }
        this.outputStackStart = (short)(this.outputStackStart - 1);
        return 0x1400000 | -this.outputStackStart;
    }

    /*
     * WARNING - void declaration
     */
    private void pop(int elements) {
        void var1_1;
        if (this.outputStackTop >= elements) {
            this.outputStackTop = (short)(this.outputStackTop - elements);
            return;
        }
        this.outputStackStart = (short)(this.outputStackStart - (var1_1 - this.outputStackTop));
        this.outputStackTop = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void pop(String descriptor) {
        void var2_2;
        char firstDescriptorChar = descriptor.charAt(0);
        if (firstDescriptorChar == '(') {
            void var1_1;
            this.pop((Type.getArgumentsAndReturnSizes((String)var1_1) >> 2) - 1);
            return;
        }
        if (firstDescriptorChar == 'J' || var2_2 == 68) {
            this.pop(2);
            return;
        }
        this.pop(1);
    }

    /*
     * WARNING - void declaration
     */
    private void addInitializedType(int abstractType) {
        void var1_1;
        int initializationsLength;
        if (this.initializations == null) {
            this.initializations = new int[2];
        }
        if (this.initializationCount >= (initializationsLength = this.initializations.length)) {
            void var3_3;
            void var2_2;
            int[] newInitializations = new int[Math.max(this.initializationCount + 1, 2 * initializationsLength)];
            System.arraycopy(this.initializations, 0, newInitializations, 0, (int)var2_2);
            this.initializations = var3_3;
        }
        this.initializations[this.initializationCount++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int getInitializedType(SymbolTable symbolTable, int abstractType) {
        void var2_2;
        if (abstractType == 0x400006 || (abstractType & 0xFFC00000) == 0xC00000) {
            for (int i = 0; i < this.initializationCount; ++i) {
                int initializedType = this.initializations[i];
                int dim = initializedType & 0xFC000000;
                int kind = initializedType & 0x3C00000;
                int value = initializedType & 0xFFFFF;
                if (kind == 0x1000000) {
                    initializedType = dim + this.inputLocals[value];
                } else if (kind == 0x1400000) {
                    initializedType = dim + this.inputStack[this.inputStack.length - value];
                }
                if (abstractType != initializedType) continue;
                if (abstractType == 0x400006) {
                    SymbolTable symbolTable2 = symbolTable;
                    return 0x800000 | symbolTable2.addType(symbolTable2.getClassName());
                }
                SymbolTable symbolTable3 = symbolTable;
                return 0x800000 | symbolTable3.addType(symbolTable3.getType((int)(abstractType & 0xFFFFF)).value);
            }
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    void execute(int opcode, int arg, Symbol argSymbol, SymbolTable symbolTable) {
        switch (opcode) {
            case 0: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 145: 
            case 146: 
            case 147: 
            case 167: 
            case 177: {
                return;
            }
            case 1: {
                this.push(0x400005);
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 21: {
                this.push(0x400001);
                return;
            }
            case 9: 
            case 10: 
            case 22: {
                this.push(0x400004);
                this.push(0x400000);
                return;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: {
                this.push(0x400002);
                return;
            }
            case 14: 
            case 15: 
            case 24: {
                this.push(0x400003);
                this.push(0x400000);
                return;
            }
            case 18: {
                switch (argSymbol.tag) {
                    case 3: {
                        this.push(0x400001);
                        return;
                    }
                    case 5: {
                        this.push(0x400004);
                        this.push(0x400000);
                        return;
                    }
                    case 4: {
                        this.push(0x400002);
                        return;
                    }
                    case 6: {
                        this.push(0x400003);
                        this.push(0x400000);
                        return;
                    }
                    case 7: {
                        this.push(0x800000 | symbolTable.addType("java/lang/Class"));
                        return;
                    }
                    case 8: {
                        this.push(0x800000 | symbolTable.addType("java/lang/String"));
                        return;
                    }
                    case 16: {
                        this.push(0x800000 | symbolTable.addType("java/lang/invoke/MethodType"));
                        return;
                    }
                    case 15: {
                        this.push(0x800000 | symbolTable.addType("java/lang/invoke/MethodHandle"));
                        return;
                    }
                    case 17: {
                        this.push(symbolTable, argSymbol.value);
                        return;
                    }
                }
                throw new AssertionError();
            }
            case 25: {
                Frame frame = this;
                frame.push(frame.getLocal(arg));
                return;
            }
            case 47: 
            case 143: {
                this.pop(2);
                this.push(0x400004);
                this.push(0x400000);
                return;
            }
            case 49: 
            case 138: {
                this.pop(2);
                this.push(0x400003);
                this.push(0x400000);
                return;
            }
            case 50: {
                this.pop(1);
                int abstractType1 = this.pop();
                this.push(abstractType1 == 0x400005 ? abstractType1 : abstractType1 + -67108864);
                return;
            }
            case 54: 
            case 56: 
            case 58: {
                int abstractType1 = this.pop();
                this.setLocal(arg, abstractType1);
                if (arg <= 0) break;
                int previousLocalType = this.getLocal(arg - 1);
                if (previousLocalType == 0x400004 || previousLocalType == 0x400003) {
                    this.setLocal(arg - 1, 0x400000);
                    break;
                }
                if ((previousLocalType & 0x3C00000) == 0x1000000 || (previousLocalType & 0x3C00000) == 0x1400000) {
                    this.setLocal(arg - 1, previousLocalType | 0x100000);
                }
                return;
            }
            case 55: 
            case 57: {
                this.pop(1);
                int abstractType1 = this.pop();
                this.setLocal(arg, abstractType1);
                this.setLocal(arg + 1, 0x400000);
                if (arg <= 0) break;
                int previousLocalType = this.getLocal(arg - 1);
                if (previousLocalType == 0x400004 || previousLocalType == 0x400003) {
                    this.setLocal(arg - 1, 0x400000);
                    break;
                }
                if ((previousLocalType & 0x3C00000) == 0x1000000 || (previousLocalType & 0x3C00000) == 0x1400000) {
                    this.setLocal(arg - 1, previousLocalType | 0x100000);
                }
                return;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop(3);
                return;
            }
            case 80: 
            case 82: {
                this.pop(4);
                return;
            }
            case 87: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                this.pop(1);
                return;
            }
            case 88: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 173: 
            case 175: {
                this.pop(2);
                return;
            }
            case 89: {
                int abstractType1 = this.pop();
                this.push(abstractType1);
                this.push(abstractType1);
                return;
            }
            case 90: {
                int abstractType1 = this.pop();
                int abstractType2 = this.pop();
                this.push(abstractType1);
                this.push(abstractType2);
                this.push(abstractType1);
                return;
            }
            case 91: {
                int abstractType1 = this.pop();
                int abstractType2 = this.pop();
                int abstractType3 = this.pop();
                this.push(abstractType1);
                this.push(abstractType3);
                this.push(abstractType2);
                this.push(abstractType1);
                return;
            }
            case 92: {
                int abstractType1 = this.pop();
                int abstractType2 = this.pop();
                this.push(abstractType2);
                this.push(abstractType1);
                this.push(abstractType2);
                this.push(abstractType1);
                return;
            }
            case 93: {
                int abstractType1 = this.pop();
                int abstractType2 = this.pop();
                int abstractType3 = this.pop();
                this.push(abstractType2);
                this.push(abstractType1);
                this.push(abstractType3);
                this.push(abstractType2);
                this.push(abstractType1);
                return;
            }
            case 94: {
                void var2_4;
                void var3_6;
                int abstractType1 = this.pop();
                int abstractType2 = this.pop();
                int abstractType3 = this.pop();
                int abstractType4 = this.pop();
                this.push(abstractType2);
                this.push(abstractType1);
                this.push((int)var3_6);
                this.push((int)var2_4);
                this.push(abstractType2);
                this.push(abstractType1);
                return;
            }
            case 95: {
                int abstractType1 = this.pop();
                int abstractType2 = this.pop();
                this.push(abstractType1);
                this.push(abstractType2);
                return;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 142: 
            case 149: 
            case 150: {
                this.pop(2);
                this.push(0x400001);
                return;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.pop(4);
                this.push(0x400004);
                this.push(0x400000);
                return;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 137: 
            case 144: {
                this.pop(2);
                this.push(0x400002);
                return;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.pop(4);
                this.push(0x400003);
                this.push(0x400000);
                return;
            }
            case 121: 
            case 123: 
            case 125: {
                this.pop(3);
                this.push(0x400004);
                this.push(0x400000);
                return;
            }
            case 132: {
                void var2_4;
                this.setLocal((int)var2_4, 0x400001);
                return;
            }
            case 133: 
            case 140: {
                this.pop(1);
                this.push(0x400004);
                this.push(0x400000);
                return;
            }
            case 134: {
                this.pop(1);
                this.push(0x400002);
                return;
            }
            case 135: 
            case 141: {
                this.pop(1);
                this.push(0x400003);
                this.push(0x400000);
                return;
            }
            case 139: 
            case 190: 
            case 193: {
                this.pop(1);
                this.push(0x400001);
                return;
            }
            case 148: 
            case 151: 
            case 152: {
                this.pop(4);
                this.push(0x400001);
                return;
            }
            case 168: 
            case 169: {
                throw new IllegalArgumentException("JSR/RET are not supported with computeFrames option");
            }
            case 178: {
                void var3_5;
                this.push(symbolTable, var3_5.value);
                return;
            }
            case 179: {
                void var3_5;
                this.pop(var3_5.value);
                return;
            }
            case 180: {
                void var3_5;
                this.pop(1);
                this.push(symbolTable, var3_5.value);
                return;
            }
            case 181: {
                void var3_5;
                this.pop(var3_5.value);
                this.pop();
                return;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                void var3_5;
                int abstractType2;
                this.pop(var3_5.value);
                if (abstractType2 != 184) {
                    int abstractType1 = this.pop();
                    if (abstractType2 == 183 && var3_5.name.charAt(0) == '<') {
                        this.addInitializedType(abstractType1);
                    }
                }
                this.push(symbolTable, var3_5.value);
                return;
            }
            case 186: {
                void var3_5;
                this.pop(var3_5.value);
                this.push(symbolTable, var3_5.value);
                return;
            }
            case 187: {
                void var3_5;
                void var2_4;
                this.push(0xC00000 | symbolTable.addUninitializedType(var3_5.value, (int)var2_4));
                return;
            }
            case 188: {
                void var2_4;
                this.pop();
                switch (var2_4) {
                    case 4: {
                        this.push(0x4400009);
                        return;
                    }
                    case 5: {
                        this.push(0x440000B);
                        return;
                    }
                    case 8: {
                        this.push(0x440000A);
                        return;
                    }
                    case 9: {
                        this.push(0x440000C);
                        return;
                    }
                    case 10: {
                        this.push(0x4400001);
                        return;
                    }
                    case 6: {
                        this.push(0x4400002);
                        return;
                    }
                    case 7: {
                        this.push(0x4400003);
                        return;
                    }
                    case 11: {
                        this.push(0x4400004);
                        return;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 189: {
                void var3_5;
                String arrayElementType = var3_5.value;
                this.pop();
                if (arrayElementType.charAt(0) == '[') {
                    this.push(symbolTable, "[" + arrayElementType);
                    return;
                }
                this.push(0x4800000 | symbolTable.addType(arrayElementType));
                return;
            }
            case 192: {
                void var1_3;
                void var3_5;
                String castType = var3_5.value;
                this.pop();
                if (castType.charAt(0) == '[') {
                    this.push(symbolTable, castType);
                    return;
                }
                this.push(0x800000 | symbolTable.addType((String)var1_3));
                return;
            }
            case 197: {
                void var3_5;
                void var2_4;
                this.pop((int)var2_4);
                this.push(symbolTable, var3_5.value);
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getConcreteOutputType(int abstractOutputType, int numStack) {
        void var1_1;
        int concreteOutputType;
        int dim = abstractOutputType & 0xFC000000;
        int kind = abstractOutputType & 0x3C00000;
        if (kind == 0x1000000) {
            concreteOutputType = dim + this.inputLocals[abstractOutputType & 0xFFFFF];
            if ((abstractOutputType & 0x100000) != 0 && (concreteOutputType == 0x400004 || concreteOutputType == 0x400003)) {
                concreteOutputType = 0x400000;
            }
            return concreteOutputType;
        }
        if (kind == 0x1400000) {
            void var2_2;
            void var3_3;
            concreteOutputType = var3_3 + this.inputStack[concreteOutputType - (abstractOutputType & 0xFFFFF)];
            if ((abstractOutputType & 0x100000) != 0 && (concreteOutputType == 0x400004 || concreteOutputType == 0x400003)) {
                concreteOutputType = 0x400000;
            }
            return (int)var2_2;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final boolean merge(SymbolTable symbolTable, Frame dstFrame, int catchTypeIndex) {
        int i;
        int abstractOutputType;
        int i2;
        boolean frameChanged = false;
        int numLocal = this.inputLocals.length;
        int numStack = this.inputStack.length;
        if (dstFrame.inputLocals == null) {
            dstFrame.inputLocals = new int[numLocal];
            frameChanged = true;
        }
        for (i2 = 0; i2 < numLocal; ++i2) {
            int concreteOutputType = this.outputLocals != null && i2 < this.outputLocals.length ? ((abstractOutputType = this.outputLocals[i2]) == 0 ? this.inputLocals[i2] : this.getConcreteOutputType(abstractOutputType, numStack)) : this.inputLocals[i2];
            if (this.initializations != null) {
                concreteOutputType = this.getInitializedType(symbolTable, concreteOutputType);
            }
            frameChanged |= Frame.merge(symbolTable, concreteOutputType, dstFrame.inputLocals, i2);
        }
        if (catchTypeIndex > 0) {
            for (i2 = 0; i2 < numLocal; ++i2) {
                frameChanged |= Frame.merge(symbolTable, this.inputLocals[i2], dstFrame.inputLocals, i2);
            }
            if (dstFrame.inputStack == null) {
                dstFrame.inputStack = new int[1];
                frameChanged = true;
            }
            return frameChanged |= Frame.merge(symbolTable, catchTypeIndex, dstFrame.inputStack, 0);
        }
        int numInputStack = this.inputStack.length + this.outputStackStart;
        if (dstFrame.inputStack == null) {
            dstFrame.inputStack = new int[numInputStack + this.outputStackTop];
            frameChanged = true;
        }
        for (i = 0; i < numInputStack; ++i) {
            int concreteOutputType = this.inputStack[i];
            if (this.initializations != null) {
                concreteOutputType = this.getInitializedType(symbolTable, concreteOutputType);
            }
            frameChanged |= Frame.merge(symbolTable, concreteOutputType, dstFrame.inputStack, i);
        }
        for (i = 0; i < this.outputStackTop; ++i) {
            void var3_3;
            abstractOutputType = this.outputStack[i];
            int concreteOutputType = this.getConcreteOutputType(abstractOutputType, numStack);
            if (this.initializations != null) {
                concreteOutputType = this.getInitializedType(symbolTable, concreteOutputType);
            }
            frameChanged |= Frame.merge(symbolTable, (int)var3_3, dstFrame.inputStack, numInputStack + i);
        }
        return frameChanged;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean merge(SymbolTable symbolTable, int sourceType, int[] dstTypes, int dstIndex) {
        int n;
        int mergedType2;
        int dstType = dstTypes[dstIndex];
        if (dstType == sourceType) {
            return false;
        }
        int srcType = sourceType;
        if ((sourceType & 0x3FFFFFF) == 0x400005) {
            if (dstType == 0x400005) {
                return false;
            }
            srcType = 0x400005;
        }
        if (dstType == 0) {
            dstTypes[dstIndex] = srcType;
            return true;
        }
        if ((dstType & 0xFC000000) != 0 || (dstType & 0x3C00000) == 0x800000) {
            if (srcType == 0x400005) {
                return false;
            }
            if ((sourceType & 0xFFC00000) == (dstType & 0xFFC00000)) {
                if ((dstType & 0x3C00000) == 0x800000) {
                    mergedType2 = sourceType & 0xFC000000 | 0x800000 | symbolTable.addMergedType(sourceType & 0xFFFFF, dstType & 0xFFFFF);
                } else {
                    SymbolTable mergedType;
                    srcType = -67108864 + (sourceType & 0xFC000000);
                    mergedType2 = srcType | 0x800000 | mergedType.addType("java/lang/Object");
                }
            } else if ((sourceType & 0xFC000000) != 0 || (sourceType & 0x3C00000) == 0x800000) {
                int dstDim;
                int srcDim = sourceType & 0xFC000000;
                if (srcDim != 0 && (sourceType & 0x3C00000) != 0x800000) {
                    srcDim += -67108864;
                }
                if ((dstDim = dstType & 0xFC000000) != 0 && (dstType & 0x3C00000) != 0x800000) {
                    dstDim += -67108864;
                }
                mergedType2 = Math.min(srcDim, n) | 0x800000 | mergedType.addType("java/lang/Object");
            } else {
                mergedType2 = 0x400000;
            }
        } else {
            void var5_6;
            mergedType2 = dstType == 0x400005 ? ((var5_6 & 0xFC000000) != 0 || (var5_6 & 0x3C00000) == 0x800000 ? n : 0x400000) : 0x400000;
        }
        if (mergedType2 != dstType) {
            void var0_1;
            var2_3[var3_4] = var0_1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final void accept(MethodWriter methodWriter) {
        void var1_1;
        int i;
        int localType;
        int[] localTypes = this.inputLocals;
        int numLocal = 0;
        int numTrailingTop = 0;
        for (i = 0; i < localTypes.length; i += (localType = localTypes[i]) == 0x400004 || localType == 0x400003 ? 2 : 1) {
            if (localType == 0x400000) {
                ++numTrailingTop;
                continue;
            }
            numLocal += numTrailingTop + 1;
            numTrailingTop = 0;
        }
        int[] stackTypes = this.inputStack;
        int numStack = 0;
        i = 0;
        while (i < stackTypes.length) {
            int stackType;
            i += (stackType = stackTypes[i]) == 0x400004 || stackType == 0x400003 ? 2 : 1;
            ++numStack;
        }
        int frameIndex = methodWriter.visitFrameStart(this.owner.bytecodeOffset, numLocal, numStack);
        i = 0;
        while (numLocal-- > 0) {
            int localType2;
            i += (localType2 = localTypes[i]) == 0x400004 || localType2 == 0x400003 ? 2 : 1;
            methodWriter.visitAbstractType(frameIndex++, localType2);
        }
        i = 0;
        while (numStack-- > 0) {
            int stackType;
            i += (stackType = stackTypes[i]) == 0x400004 || stackType == 0x400003 ? 2 : 1;
            methodWriter.visitAbstractType(frameIndex++, stackType);
        }
        var1_1.visitFrameEnd();
    }

    /*
     * WARNING - void declaration
     */
    static void putAbstractType(SymbolTable symbolTable, int abstractType, ByteVector output) {
        block19: {
            SymbolTable symbolTable2;
            void var2_2;
            int arrayDimensions;
            block18: {
                arrayDimensions = (abstractType & 0xFC000000) >> 26;
                if (arrayDimensions != 0) break block18;
                int typeValue = abstractType & 0xFFFFF;
                switch (abstractType & 0x3C00000) {
                    case 0x400000: {
                        output.putByte(typeValue);
                        break block19;
                    }
                    case 0x800000: {
                        SymbolTable symbolTable3 = symbolTable;
                        output.putByte(7).putShort(symbolTable3.addConstantClass((String)symbolTable3.getType((int)typeValue).value).index);
                        break block19;
                    }
                    case 0xC00000: {
                        output.putByte(8).putShort((int)symbolTable.getType((int)typeValue).data);
                        break block19;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            StringBuilder typeDescriptor = new StringBuilder();
            while (arrayDimensions-- > 0) {
                typeDescriptor.append('[');
            }
            if ((abstractType & 0x3C00000) == 0x800000) {
                typeDescriptor.append('L').append(symbolTable.getType((int)(abstractType & 0xFFFFF)).value).append(';');
            } else {
                void var1_1;
                switch (var1_1 & 0xFFFFF) {
                    case 9: {
                        typeDescriptor.append('Z');
                        break;
                    }
                    case 10: {
                        typeDescriptor.append('B');
                        break;
                    }
                    case 11: {
                        typeDescriptor.append('C');
                        break;
                    }
                    case 12: {
                        typeDescriptor.append('S');
                        break;
                    }
                    case 1: {
                        typeDescriptor.append('I');
                        break;
                    }
                    case 2: {
                        typeDescriptor.append('F');
                        break;
                    }
                    case 4: {
                        typeDescriptor.append('J');
                        break;
                    }
                    case 3: {
                        typeDescriptor.append('D');
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            var2_2.putByte(7).putShort(symbolTable2.addConstantClass((String)typeDescriptor.toString()).index);
        }
    }
}

