/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

final class SelectInCoverageView
implements SelectInTarget {
    private final Project myProject;

    private SelectInCoverageView(@NotNull Project project) {
        if (project == null) {
            SelectInCoverageView.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public String toString() {
        return CoverageBundle.message("coverage.view.title", new Object[0]);
    }

    public boolean canSelect(SelectInContext context) {
        CoverageDataManager manager = CoverageDataManager.getInstance(this.myProject);
        for (CoverageSuitesBundle suitesBundle : manager.activeSuites()) {
            CoverageView coverageView = CoverageViewManager.getInstance(this.myProject).getView(suitesBundle);
            if (coverageView == null) continue;
            VirtualFile file = context.getVirtualFile();
            return !file.isDirectory() && coverageView.canSelect(file);
        }
        return false;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        CoverageDataManager manager = CoverageDataManager.getInstance(this.myProject);
        for (CoverageSuitesBundle suitesBundle : manager.activeSuites()) {
            CoverageViewManager coverageViewManager = CoverageViewManager.getInstance(this.myProject);
            CoverageView coverageView = coverageViewManager.getView(suitesBundle);
            if (coverageView == null) {
                return;
            }
            coverageView.select(context.getVirtualFile());
            if (!requestFocus) continue;
            ApplicationManager.getApplication().invokeLater(() -> coverageViewManager.activateToolwindow(coverageView));
        }
    }

    public String getToolWindowId() {
        return "Coverage";
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 4.5f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/view/SelectInCoverageView", "<init>"));
    }
}

