/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.AnnotationData;
import com.intellij.openapi.vcs.actions.ShowAnnotateOperationsPopup;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/ui/actions/history/ShowInFileHistoryAnnotationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "service", "Lcom/intellij/vcs/log/VcsLogFileHistoryProvider;", "annotation", "Lcom/intellij/openapi/vcs/annotate/FileAnnotation;", "<init>", "(Lcom/intellij/vcs/log/VcsLogFileHistoryProvider;Lcom/intellij/openapi/vcs/annotate/FileAnnotation;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getLineRevisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.vcs.log.impl"})
final class ShowInFileHistoryAnnotationAction
extends DumbAwareAction {
    @NotNull
    private final VcsLogFileHistoryProvider service;
    @NotNull
    private final FileAnnotation annotation;

    public ShowInFileHistoryAnnotationAction(@NotNull VcsLogFileHistoryProvider service, @NotNull FileAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        super(VcsLogBundle.message("vcs.log.action.show.in.file.history.text", new Object[0]));
        this.service = service;
        this.annotation = annotation;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile file = this.annotation.getFile();
        VcsRevisionNumber lineRevisionNumber = this.getLineRevisionNumber(e);
        if (project == null || file == null || lineRevisionNumber == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        AnnotationData annotationData = AnnotationData.Companion.extractFrom(project, file);
        AnnotationData annotationData2 = annotationData;
        if (annotationData2 == null || (annotationData2 = annotationData2.getFilePath()) == null) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            annotationData2 = filePath;
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        }
        AnnotationData annotatedFilePath = annotationData2;
        AnnotationData annotationData3 = annotationData;
        VcsRevisionNumber annotatedRevisionNumber = annotationData3 != null ? annotationData3.getRevisionNumber() : null;
        e.getPresentation().setEnabledAndVisible(this.service.canShowFileHistory((Collection)CollectionsKt.listOf((Object)annotatedFilePath), annotatedRevisionNumber));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = this.annotation.getFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        VcsRevisionNumber vcsRevisionNumber = this.getLineRevisionNumber(e);
        if (vcsRevisionNumber == null) {
            return;
        }
        VcsRevisionNumber lineRevisionNumber = vcsRevisionNumber;
        AnnotationData annotationData = AnnotationData.Companion.extractFrom(project2, file);
        AnnotationData annotationData2 = annotationData;
        if (annotationData2 == null || (annotationData2 = annotationData2.getFilePath()) == null) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            annotationData2 = filePath;
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        }
        AnnotationData annotatedFilePath = annotationData2;
        AnnotationData annotationData3 = annotationData;
        VcsRevisionNumber annotatedRevisionNumber = annotationData3 != null ? annotationData3.getRevisionNumber() : null;
        this.service.showFileHistory((Collection)CollectionsKt.listOf((Object)annotatedFilePath), annotatedRevisionNumber, lineRevisionNumber);
    }

    private final VcsRevisionNumber getLineRevisionNumber(AnActionEvent e) {
        int lineNumber = ShowAnnotateOperationsPopup.getAnnotationLineNumber((DataContext)e.getDataContext());
        return this.annotation.getLineRevisionNumber(lineNumber);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

