﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/storagegateway/StorageGateway_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace StorageGateway {
namespace Model {
/**
 * <p>A JSON object containing the Amazon Resource Name (ARN) of the storage volume
 * that was deleted.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolumeOutput">AWS
 * API Reference</a></p>
 */
class DeleteVolumeResult {
 public:
  AWS_STORAGEGATEWAY_API DeleteVolumeResult() = default;
  AWS_STORAGEGATEWAY_API DeleteVolumeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_STORAGEGATEWAY_API DeleteVolumeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the storage volume that was deleted. It is
   * the same ARN you provided in the request.</p>
   */
  inline const Aws::String& GetVolumeARN() const { return m_volumeARN; }
  template <typename VolumeARNT = Aws::String>
  void SetVolumeARN(VolumeARNT&& value) {
    m_volumeARNHasBeenSet = true;
    m_volumeARN = std::forward<VolumeARNT>(value);
  }
  template <typename VolumeARNT = Aws::String>
  DeleteVolumeResult& WithVolumeARN(VolumeARNT&& value) {
    SetVolumeARN(std::forward<VolumeARNT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteVolumeResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_volumeARN;
  bool m_volumeARNHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace StorageGateway
}  // namespace Aws
