/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.List;
import org.eclipse.core.resources.IResourceChangeListener;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDesktop;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.NavigatorResourceListener;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DesktopNavigatorModel
extends DBNModel {
    private NavigatorResourceListener resourceListener;

    public DesktopNavigatorModel(DBPPlatform platform, @Nullable List<? extends DBPProject> modelProjects) {
        super(platform, modelProjects);
    }

    public void initialize() {
        DBPPlatform platform;
        super.initialize();
        if (this.isGlobal() && (platform = DBWorkbench.getPlatform()) instanceof DBPPlatformDesktop) {
            DBPPlatformDesktop platformDesktop = (DBPPlatformDesktop)platform;
            this.resourceListener = new NavigatorResourceListener(this);
            platformDesktop.getWorkspace().getEclipseWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
    }

    public void dispose() {
        DBPPlatform platform;
        if (this.isGlobal() && (platform = DBWorkbench.getPlatform()) instanceof DBPPlatformDesktop) {
            DBPPlatformDesktop platformDesktop = (DBPPlatformDesktop)platform;
            platformDesktop.getWorkspace().getEclipseWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.resourceListener = null;
        }
        super.dispose();
    }

    protected DBNProject createProjectNode(DBNRoot parent, DBPProject project) {
        DBPPlatform platform = DBWorkbench.getPlatform();
        if (platform instanceof DBPPlatformDesktop) {
            DBPPlatformDesktop platformDesktop = (DBPPlatformDesktop)platform;
            if (project instanceof RCPProject) {
                RCPProject rcpProject = (RCPProject)project;
                return new DBNProjectDesktop((DBNNode)parent, rcpProject);
            }
        }
        throw new IllegalStateException("Desktop navigator model can be used only in RCP applications");
    }
}

