/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowBar;

public class DeveloperUtil {
    private static String INDENT_STRING = "    ";

    public static String getWindowLayoutAsString(DockingWindow window) {
        return DeveloperUtil.getDockingWindowLayout(window, 0);
    }

    public static JFrame createWindowLayoutFrame(String title, final DockingWindow window) {
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(2);
        final JTextArea layoutArea = new JTextArea(DeveloperUtil.getWindowLayoutAsString(window));
        JButton getLayoutButton = new JButton("Get Current Layout");
        getLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                layoutArea.setText(DeveloperUtil.getWindowLayoutAsString(window));
            }
        });
        Box box = new Box(0);
        box.add(getLayoutButton);
        frame.getContentPane().add((Component)new JScrollPane(layoutArea), "Center");
        frame.getContentPane().add((Component)box, "North");
        frame.pack();
        return frame;
    }

    private static String getDockingWindowLayout(DockingWindow window, int depth) {
        if (window instanceof RootWindow) {
            return DeveloperUtil.getRootWindowLayout((RootWindow)window, depth);
        }
        String s = depth > 0 ? "\n" : "";
        int i = 0;
        while (i < depth) {
            s = String.valueOf(s) + INDENT_STRING;
            ++i;
        }
        s = window instanceof TabWindow ? String.valueOf(s) + DeveloperUtil.getTabWindowLayout((TabWindow)window, depth + 1) : (window instanceof SplitWindow ? String.valueOf(s) + DeveloperUtil.getSplitWindowLayout((SplitWindow)window, depth + 1) : String.valueOf(s) + DeveloperUtil.getViewLayout((View)window, depth + 1));
        return s;
    }

    private static String getRootWindowLayout(RootWindow window, int depth) {
        String s = "";
        if (window.getWindow() != null) {
            s = String.valueOf(s) + "<rootWindow>.setWindow(" + DeveloperUtil.getDockingWindowLayout(window.getWindow(), depth) + ");\n\n";
        }
        int i = 0;
        while (i < window.getChildWindowCount()) {
            DockingWindow w = window.getChildWindow(i);
            if (w != window.getWindow()) {
                if (w instanceof WindowBar) {
                    WindowBar bar = (WindowBar)w;
                    if (bar.getChildWindowCount() > 0) {
                        int k = 0;
                        while (k < bar.getChildWindowCount()) {
                            s = String.valueOf(s) + "<rootWindow>.getWindowBar(Direction." + bar.getDirection().toString().toUpperCase() + ").addTab(" + DeveloperUtil.getDockingWindowLayout(bar.getChildWindow(k), depth) + ");\n";
                            ++k;
                        }
                        s = String.valueOf(s) + "\n";
                    }
                } else if (w instanceof FloatingWindow) {
                    FloatingWindow fw = (FloatingWindow)w;
                    Point loc = fw.getTopLevelAncestor().getLocation();
                    Dimension size = fw.getRootPane().getSize();
                    s = String.valueOf(s) + "<rootWindow>.createFloatingWindow(new Point(" + loc.x + ", " + loc.y + "), new Dimension(" + size.width + ", " + size.height + "), ";
                    s = String.valueOf(s) + DeveloperUtil.getDockingWindowLayout(fw.getChildWindow(0), depth);
                    s = String.valueOf(s) + ");\n\n";
                }
            }
            ++i;
        }
        return s;
    }

    private static String getTabWindowLayout(TabWindow window, int depth) {
        if (window.getChildWindowCount() == 1 && window.getChildWindow(0) instanceof View) {
            return DeveloperUtil.getViewLayout((View)window.getChildWindow(0), depth);
        }
        String s = "new TabWindow(new DockingWindow[]{";
        int i = 0;
        while (i < window.getChildWindowCount()) {
            s = String.valueOf(s) + DeveloperUtil.getDockingWindowLayout(window.getChildWindow(i), depth);
            if (i < window.getChildWindowCount() - 1) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
        }
        s = String.valueOf(s) + "})";
        return s;
    }

    private static String getSplitWindowLayout(SplitWindow window, int depth) {
        String s = "new SplitWindow(" + window.isHorizontal() + ", " + window.getDividerLocation() + "f, ";
        s = String.valueOf(s) + DeveloperUtil.getDockingWindowLayout(window.getLeftWindow(), depth) + ", ";
        s = String.valueOf(s) + DeveloperUtil.getDockingWindowLayout(window.getRightWindow(), depth);
        s = String.valueOf(s) + ")";
        return s;
    }

    private static String getViewLayout(View view, int depth) {
        return "View: \"" + view.getTitle() + "\" - " + view.getClass();
    }
}

