/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.RGBColorValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class LABColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.LABColorValue {
    private static final long serialVersionUID = 2L;
    private final LABColorImpl labColor;

    public LABColorValue() {
        this(new LABColorImpl(BaseColor.Space.CIE_Lab, "lab"));
    }

    LABColorValue(LABColorImpl lABColorImpl) {
        this.labColor = lABColorImpl;
    }

    LABColorValue(LABColorValue lABColorValue) {
        super(lABColorValue);
        this.labColor = lABColorValue.labColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LAB;
    }

    @Override
    void set(StyleValue styleValue) {
        super.set(styleValue);
        LABColorValue lABColorValue = (LABColorValue)styleValue;
        this.labColor.set(lABColorValue.labColor);
    }

    @Override
    public String getCssText() {
        return this.labColor.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        return this.labColor.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        this.labColor.writeCssText(simpleWriter);
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        return this.labColor.item(n);
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        this.labColor.setComponent(n, (PrimitiveValue)styleValue);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean bl) throws DOMException {
        double[] dArray = this.labColor.toSRGB(bl);
        ColorValue.CSSRGBColor cSSRGBColor = new ColorValue.CSSRGBColor();
        cSSRGBColor.setColorComponents(dArray);
        cSSRGBColor.setAlpha(this.labColor.getAlpha().clone());
        return cSSRGBColor;
    }

    @Override
    public LABColorValue toLABColorValue() {
        return this;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        if (!this.labColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float f = ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0);
        float f2 = ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0);
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        float f4 = (float)(Math.atan2(f2, f) * 180.0 / Math.PI);
        if (f4 < 0.0f) {
            f4 += 360.0f;
        }
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, f3);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)80, f4);
        numberValue.setAbsolutizedUnit();
        numberValue2.setAbsolutizedUnit();
        LCHColorValue lCHColorValue = new LCHColorValue();
        lCHColorValue.setComponent(0, this.labColor.getAlpha().clone());
        lCHColorValue.setComponent(1, this.labColor.getLightness().clone());
        lCHColorValue.setComponent(2, numberValue);
        lCHColorValue.setComponent(3, numberValue2);
        return lCHColorValue;
    }

    @Override
    public LABColor getColor() {
        return this.labColor;
    }

    LABColorImpl getLABColorImpl() {
        return this.labColor;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.labColor.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue cSSColorValue) {
        LABColor lABColor;
        if (!this.labColor.hasConvertibleComponents() || !((ColorValue)cSSColorValue).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (cSSColorValue.getColorModel()) {
            case LAB: {
                lABColor = (LABColor)cSSColorValue.getColor();
                if (!"oklab".equals(lABColor.getColorSpace())) break;
                lABColor = cSSColorValue.toLABColorValue().getColor();
                break;
            }
            case LCH: {
                lABColor = cSSColorValue.toLABColorValue().getColor();
                break;
            }
            case RGB: {
                RGBColor rGBColor = (RGBColor)cSSColorValue.getColor();
                LABColorImpl lABColorImpl = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                rGBColor.toLABColor(lABColorImpl);
                lABColor = lABColorImpl;
                break;
            }
            case XYZ: {
                XYZColorImpl xYZColorImpl = (XYZColorImpl)cSSColorValue.getColor();
                LABColorImpl lABColorImpl = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                xYZColorImpl.toLABColor(lABColorImpl);
                lABColor = lABColorImpl;
                break;
            }
            default: {
                RGBAColor rGBAColor = cSSColorValue.toRGBColor(false);
                RGBColorValue rGBColorValue = new RGBColorValue();
                rGBColorValue.setComponent(0, (StyleValue)((Object)rGBAColor.getAlpha()));
                rGBColorValue.setComponent(1, (StyleValue)((Object)rGBAColor.getRed()));
                rGBColorValue.setComponent(2, (StyleValue)((Object)rGBAColor.getGreen()));
                rGBColorValue.setComponent(3, (StyleValue)((Object)rGBAColor.getBlue()));
                lABColor = rGBColorValue.toLABColorValue().getColor();
            }
        }
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)((Object)this.labColor.getLightness())).getFloatValue((short)0), ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0), ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0), ((CSSTypedValue)lABColor.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getA()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getB()).getFloatValue((short)0));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.labColor.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LABColorValue lABColorValue = (LABColorValue)object;
        return this.labColor.equals(lABColorValue.labColor);
    }

    @Override
    public LABColorValue clone() {
        return new LABColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(LABColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            try {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.LABCOLOR) {
                    throw new DOMException(13, "No lab() value: " + lexicalUnit.toString());
                }
                this.setLexicalLAB(lexicalUnit);
            }
            catch (DOMException dOMException) {
                throw dOMException;
            }
            catch (RuntimeException runtimeException) {
                throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void setLexicalLAB(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            ValueFactory valueFactory = new ValueFactory();
            PrimitiveValue primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue2 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue3 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    throw new DOMException(12, "Expected slash in: " + lexicalUnit.toString());
                }
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                PrimitiveValue primitiveValue4 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                LABColorValue.this.labColor.setAlpha(primitiveValue4);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2 != null) {
                    throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
                }
            }
            LABColorValue.this.labColor.setLightness(primitiveValue);
            LABColorValue.this.labColor.setA(primitiveValue2);
            LABColorValue.this.labColor.setB(primitiveValue3);
        }
    }
}

