/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class StringValue
extends AbstractTextValue {
    private static final long serialVersionUID = 1L;
    private String stringValue = null;
    private final short flags;
    char quote;

    public StringValue() {
        this(0);
    }

    public StringValue(short flags) {
        this(CSSValue.Type.STRING, flags);
    }

    StringValue(CSSValue.Type primitiveType, short flags) {
        super(primitiveType);
        this.flags = flags;
        this.quote = (char)39;
        this.setQuote();
    }

    protected StringValue(StringValue copied) {
        super(copied);
        this.stringValue = copied.stringValue;
        this.flags = copied.flags;
        this.quote = copied.quote;
    }

    private void setQuote() {
        if (this.isDoubleQuoteSet()) {
            this.quote = (char)34;
        } else if ((this.flags & 1) == 1) {
            this.quote = (char)39;
        }
    }

    private boolean isDoubleQuoteSet() {
        return (this.flags & 2) == 2;
    }

    private boolean isNoQuotePreferenceSet() {
        return (this.flags & 3) == 0;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        boolean doubleQuotes = false;
        boolean singleQuotes = false;
        String text = cssText = cssText.trim();
        int tlm1 = cssText.length() - 1;
        if (tlm1 > 1) {
            char c = cssText.charAt(0);
            char d = cssText.charAt(tlm1);
            if (c == '\'') {
                if (d == '\'') {
                    text = cssText.substring(1, tlm1);
                    singleQuotes = true;
                }
            } else if (c == '\"' && d == '\"') {
                text = cssText.substring(1, tlm1);
                doubleQuotes = true;
            }
        }
        this.stringValue = ParseHelper.unescapeStringValue(text);
        if (this.isNoQuotePreferenceSet() || this.isDoubleQuoteSet() && doubleQuotes || !singleQuotes && !doubleQuotes) {
            if (doubleQuotes) {
                this.quote = (char)34;
            }
            text = ParseHelper.escapeControl(text);
            this.setPlainCssText(ParseHelper.quote(text, this.quote));
        } else {
            this.setUnescapedCssText(this.stringValue);
        }
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public void setStringValue(CSSValue.Type stringType, String stringValue) throws DOMException {
        this.checkModifiableProperty();
        if (this.getPrimitiveType() != stringType) {
            throw new DOMException(13, "This value is a different type. To have a new type, set it at the style-declaration level.");
        }
        if (stringValue == null) {
            throw new DOMException(5, "Null value.");
        }
        this.setStringValue(stringValue);
        this.setUnescapedCssText(stringValue);
    }

    protected void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        switch (syntax.getCategory()) {
            case string: 
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    boolean usesDoubleQuote(String text) {
        return text.charAt(0) == '\"';
    }

    protected void setUnescapedCssText(String css) {
        this.setPlainCssText(StringValue.escapeControlBackslashAndQuote(css, this.quote));
    }

    private static String escapeControlBackslashAndQuote(String css, char quote) {
        boolean hasSingleQuotes;
        boolean useDQ = true;
        boolean hasDoubleQuotes = css.indexOf(34) != -1;
        boolean bl = hasSingleQuotes = css.indexOf(39) != -1;
        if (hasSingleQuotes) {
            quote = (char)34;
            if (hasDoubleQuotes) {
                int len = css.length();
                int sqc = 0;
                int dqc = 0;
                for (int i = 0; i < len; ++i) {
                    char c = css.charAt(i);
                    if (c == '\'') {
                        ++sqc;
                        continue;
                    }
                    if (c != '\"') continue;
                    ++dqc;
                }
                if (sqc > dqc) {
                    quote = (char)34;
                } else {
                    quote = (char)39;
                    useDQ = false;
                }
            }
        } else if (hasDoubleQuotes) {
            useDQ = false;
            quote = (char)39;
        }
        css = ParseHelper.escapeString(css, quote, true);
        css = hasSingleQuotes || hasDoubleQuotes ? (useDQ ? '\"' + css + '\"' : '\'' + css + '\'') : quote + css + quote;
        return css;
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return StringValue.escapeControlBackslashAndQuote(this.stringValue, this.quote);
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.getCssText());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        String sv = this.getStringValue();
        result = 31 * result + (sv == null ? 0 : sv.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof StringValue)) {
            return false;
        }
        StringValue other = (StringValue)obj;
        if (this.stringValue == null) {
            return other.stringValue == null;
        }
        return this.stringValue.equals(other.stringValue);
    }

    @Override
    public StringValue clone() {
        return new StringValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            super.setLexicalUnit(lunit);
            String strval = lunit.getStringValue();
            StringValue.this.setStringValue(strval);
            if (StringValue.this.isNoQuotePreferenceSet() && lunit instanceof LexicalUnit) {
                String text = lunit.getCssText();
                if (text.length() != 0 && StringValue.this.usesDoubleQuote(text)) {
                    StringValue.this.quote = (char)34;
                }
                StringValue.this.setPlainCssText(text);
            } else {
                StringValue.this.setUnescapedCssText(strval);
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

