/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.variable;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.ConflictReporter;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceValidatorEngine;

public class GroovyVariableValidator
extends GrIntroduceValidatorEngine
implements GrIntroduceHandlerBase.Validator {
    public GroovyVariableValidator(GrIntroduceContext context) {
        super(context, new ConflictReporter(){

            @Override
            public void check(PsiElement element, MultiMap<PsiElement, String> conflicts, String varName) {
                if (!(element instanceof GrVariable)) {
                    return;
                }
                GrVariable var = (GrVariable)element;
                if (var instanceof GrField) {
                    return;
                }
                if (var instanceof GrParameter && varName.equals(var.getName())) {
                    conflicts.putValue((Object)var, (Object)GroovyRefactoringBundle.message("introduced.variable.conflicts.with.parameter.0", CommonRefactoringUtil.htmlEmphasize((String)varName)));
                } else if (varName.equals(var.getName())) {
                    conflicts.putValue((Object)var, (Object)GroovyRefactoringBundle.message("introduced.variable.conflicts.with.variable.0", CommonRefactoringUtil.htmlEmphasize((String)varName)));
                }
            }
        });
    }
}

