/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchDataInfo;

public record LogReadResult(FetchDataInfo info, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, long highWatermark, long leaderLogStartOffset, long leaderLogEndOffset, long followerLogStartOffset, long fetchTimeMs, OptionalLong lastStableOffset, OptionalInt preferredReadReplica, Optional<Throwable> exception) {
    public LogReadResult(FetchDataInfo info, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, long highWatermark, long leaderLogStartOffset, long leaderLogEndOffset, long followerLogStartOffset, long fetchTimeMs, OptionalLong lastStableOffset) {
        this(info, divergingEpoch, highWatermark, leaderLogStartOffset, leaderLogEndOffset, followerLogStartOffset, fetchTimeMs, lastStableOffset, OptionalInt.empty(), Optional.empty());
    }

    public LogReadResult(FetchDataInfo info, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, long highWatermark, long leaderLogStartOffset, long leaderLogEndOffset, long followerLogStartOffset, long fetchTimeMs, OptionalLong lastStableOffset, Optional<Throwable> exception) {
        this(info, divergingEpoch, highWatermark, leaderLogStartOffset, leaderLogEndOffset, followerLogStartOffset, fetchTimeMs, lastStableOffset, OptionalInt.empty(), exception);
    }

    public LogReadResult(FetchDataInfo info, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, long highWatermark, long leaderLogStartOffset, long leaderLogEndOffset, long followerLogStartOffset, long fetchTimeMs, OptionalLong lastStableOffset, OptionalInt preferredReadReplica) {
        this(info, divergingEpoch, highWatermark, leaderLogStartOffset, leaderLogEndOffset, followerLogStartOffset, fetchTimeMs, lastStableOffset, preferredReadReplica, Optional.empty());
    }

    public Errors error() {
        if (this.exception.isPresent()) {
            return Errors.forException((Throwable)this.exception.get());
        }
        return Errors.NONE;
    }

    @Override
    public String toString() {
        return "LogReadResult(info=" + String.valueOf(this.info) + ", divergingEpoch=" + String.valueOf(this.divergingEpoch) + ", highWatermark=" + this.highWatermark + ", leaderLogStartOffset" + this.leaderLogStartOffset + ", leaderLogEndOffset" + this.leaderLogEndOffset + ", followerLogStartOffset" + this.followerLogStartOffset + ", fetchTimeMs=" + this.fetchTimeMs + ", preferredReadReplica=" + String.valueOf(this.preferredReadReplica) + ", lastStableOffset=" + String.valueOf(this.lastStableOffset) + ", error=" + String.valueOf(this.error()) + ")";
    }

    public FetchPartitionData toFetchPartitionData(boolean isReassignmentFetch) {
        return new FetchPartitionData(this.error(), this.highWatermark, this.leaderLogStartOffset, this.info.records, this.divergingEpoch, this.lastStableOffset, this.info.abortedTransactions, this.preferredReadReplica, isReassignmentFetch);
    }
}

