/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.GroupSpecImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.coordinator.group.modern.SubscribedTopicDescriberImpl;
import org.apache.kafka.coordinator.group.modern.TopicIds;
import org.apache.kafka.coordinator.group.modern.UnionSet;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.apache.kafka.image.MetadataImage;

public abstract class TargetAssignmentBuilder<T extends ModernGroupMember, U extends TargetAssignmentBuilder<T, U>> {
    private final String groupId;
    private final int groupEpoch;
    private final PartitionAssignor assignor;
    private Map<String, T> members = Map.of();
    private SubscriptionType subscriptionType;
    private Map<String, Assignment> targetAssignment = Map.of();
    private Map<Uuid, Map<Integer, String>> invertedTargetAssignment = Map.of();
    private MetadataImage metadataImage = MetadataImage.EMPTY;
    private final Map<String, T> updatedMembers = new HashMap<String, T>();
    private Map<String, String> staticMembers = new HashMap<String, String>();
    private Optional<Map<Uuid, Set<Integer>>> topicAssignablePartitionsMap = Optional.empty();

    public TargetAssignmentBuilder(String groupId, int groupEpoch, PartitionAssignor assignor) {
        this.groupId = Objects.requireNonNull(groupId);
        this.groupEpoch = groupEpoch;
        this.assignor = Objects.requireNonNull(assignor);
    }

    public U withMembers(Map<String, T> members) {
        this.members = members;
        return this.self();
    }

    public U withStaticMembers(Map<String, String> staticMembers) {
        this.staticMembers = staticMembers;
        return this.self();
    }

    public U withSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
        return this.self();
    }

    public U withTargetAssignment(Map<String, Assignment> targetAssignment) {
        this.targetAssignment = targetAssignment;
        return this.self();
    }

    public U withInvertedTargetAssignment(Map<Uuid, Map<Integer, String>> invertedTargetAssignment) {
        this.invertedTargetAssignment = invertedTargetAssignment;
        return this.self();
    }

    public U withMetadataImage(MetadataImage metadataImage) {
        this.metadataImage = metadataImage;
        return this.self();
    }

    public U withTopicAssignablePartitionsMap(Map<Uuid, Set<Integer>> topicAssignablePartitionsMap) {
        this.topicAssignablePartitionsMap = Optional.of(topicAssignablePartitionsMap);
        return this.self();
    }

    public U addOrUpdateMember(String memberId, T member) {
        this.updatedMembers.put(memberId, member);
        return this.self();
    }

    public U removeMember(String memberId) {
        return this.addOrUpdateMember(memberId, null);
    }

    public TargetAssignmentResult build() throws PartitionAssignorException {
        HashMap memberSpecs = new HashMap();
        TopicIds.CachedTopicResolver topicResolver = new TopicIds.CachedTopicResolver(this.metadataImage.topics());
        this.members.forEach((memberId, member) -> memberSpecs.put(memberId, this.newMemberSubscriptionAndAssignment(member, this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY), topicResolver)));
        this.updatedMembers.forEach((memberId, updatedMemberOrNull) -> {
            if (updatedMemberOrNull == null) {
                memberSpecs.remove(memberId);
            } else {
                String previousMemberId;
                Assignment assignment = this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY);
                if (updatedMemberOrNull.instanceId() != null && (previousMemberId = this.staticMembers.get(updatedMemberOrNull.instanceId())) != null && !previousMemberId.equals(memberId)) {
                    assignment = this.targetAssignment.getOrDefault(previousMemberId, Assignment.EMPTY);
                }
                memberSpecs.put(memberId, this.newMemberSubscriptionAndAssignment(updatedMemberOrNull, assignment, topicResolver));
            }
        });
        GroupAssignment newGroupAssignment = this.assignor.assign((GroupSpec)new GroupSpecImpl(Collections.unmodifiableMap(memberSpecs), this.subscriptionType, this.invertedTargetAssignment, this.topicAssignablePartitionsMap), (SubscribedTopicDescriber)new SubscribedTopicDescriberImpl(this.metadataImage));
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        for (String memberId2 : memberSpecs.keySet()) {
            Assignment oldMemberAssignment = this.targetAssignment.get(memberId2);
            Assignment newMemberAssignment = this.newMemberAssignment(newGroupAssignment, memberId2);
            if (newMemberAssignment.equals(oldMemberAssignment)) continue;
            records.add(this.newTargetAssignmentRecord(this.groupId, memberId2, newMemberAssignment.partitions()));
        }
        records.add(this.newTargetAssignmentEpochRecord(this.groupId, this.groupEpoch));
        return new TargetAssignmentResult(records, newGroupAssignment.members());
    }

    protected abstract U self();

    protected abstract CoordinatorRecord newTargetAssignmentRecord(String var1, String var2, Map<Uuid, Set<Integer>> var3);

    protected abstract CoordinatorRecord newTargetAssignmentEpochRecord(String var1, int var2);

    protected abstract MemberSubscriptionAndAssignmentImpl newMemberSubscriptionAndAssignment(T var1, Assignment var2, TopicIds.TopicResolver var3);

    private Assignment newMemberAssignment(GroupAssignment newGroupAssignment, String memberId) {
        MemberAssignment newMemberAssignment = (MemberAssignment)newGroupAssignment.members().get(memberId);
        if (newMemberAssignment != null) {
            return new Assignment(newMemberAssignment.partitions());
        }
        return Assignment.EMPTY;
    }

    public static class TargetAssignmentResult {
        private final List<CoordinatorRecord> records;
        private final Map<String, MemberAssignment> targetAssignment;

        TargetAssignmentResult(List<CoordinatorRecord> records, Map<String, MemberAssignment> targetAssignment) {
            Objects.requireNonNull(records);
            Objects.requireNonNull(targetAssignment);
            this.records = records;
            this.targetAssignment = targetAssignment;
        }

        public List<CoordinatorRecord> records() {
            return this.records;
        }

        public Map<String, MemberAssignment> targetAssignment() {
            return this.targetAssignment;
        }
    }

    public static class ShareTargetAssignmentBuilder
    extends TargetAssignmentBuilder<ShareGroupMember, ShareTargetAssignmentBuilder> {
        public ShareTargetAssignmentBuilder(String groupId, int groupEpoch, PartitionAssignor assignor) {
            super(groupId, groupEpoch, assignor);
        }

        @Override
        protected ShareTargetAssignmentBuilder self() {
            return this;
        }

        @Override
        protected CoordinatorRecord newTargetAssignmentRecord(String groupId, String memberId, Map<Uuid, Set<Integer>> partitions) {
            return GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentRecord(groupId, memberId, partitions);
        }

        @Override
        protected CoordinatorRecord newTargetAssignmentEpochRecord(String groupId, int assignmentEpoch) {
            return GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentEpochRecord(groupId, assignmentEpoch);
        }

        @Override
        protected MemberSubscriptionAndAssignmentImpl newMemberSubscriptionAndAssignment(ShareGroupMember member, Assignment memberAssignment, TopicIds.TopicResolver topicResolver) {
            return new MemberSubscriptionAndAssignmentImpl(Optional.ofNullable(member.rackId()), Optional.ofNullable(member.instanceId()), new TopicIds(member.subscribedTopicNames(), topicResolver), memberAssignment);
        }
    }

    public static class ConsumerTargetAssignmentBuilder
    extends TargetAssignmentBuilder<ConsumerGroupMember, ConsumerTargetAssignmentBuilder> {
        private Map<String, ResolvedRegularExpression> resolvedRegularExpressions = Map.of();

        public ConsumerTargetAssignmentBuilder(String groupId, int groupEpoch, PartitionAssignor assignor) {
            super(groupId, groupEpoch, assignor);
        }

        public ConsumerTargetAssignmentBuilder withResolvedRegularExpressions(Map<String, ResolvedRegularExpression> resolvedRegularExpressions) {
            this.resolvedRegularExpressions = resolvedRegularExpressions;
            return this.self();
        }

        @Override
        protected ConsumerTargetAssignmentBuilder self() {
            return this;
        }

        @Override
        protected CoordinatorRecord newTargetAssignmentRecord(String groupId, String memberId, Map<Uuid, Set<Integer>> partitions) {
            return GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord(groupId, memberId, partitions);
        }

        @Override
        protected CoordinatorRecord newTargetAssignmentEpochRecord(String groupId, int assignmentEpoch) {
            return GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord(groupId, assignmentEpoch);
        }

        @Override
        protected MemberSubscriptionAndAssignmentImpl newMemberSubscriptionAndAssignment(ConsumerGroupMember member, Assignment memberAssignment, TopicIds.TopicResolver topicResolver) {
            ResolvedRegularExpression resolvedRegularExpression;
            Set<String> subscriptions = member.subscribedTopicNames();
            String subscribedTopicRegex = member.subscribedTopicRegex();
            if (subscribedTopicRegex != null && !subscribedTopicRegex.isEmpty() && (resolvedRegularExpression = this.resolvedRegularExpressions.get(subscribedTopicRegex)) != null) {
                if (subscriptions.isEmpty()) {
                    subscriptions = resolvedRegularExpression.topics;
                } else if (!resolvedRegularExpression.topics.isEmpty()) {
                    subscriptions = new UnionSet<String>(subscriptions, resolvedRegularExpression.topics);
                }
            }
            return new MemberSubscriptionAndAssignmentImpl(Optional.ofNullable(member.rackId()), Optional.ofNullable(member.instanceId()), new TopicIds(subscriptions, topicResolver), memberAssignment);
        }
    }
}

