/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.connect.mirror.MirrorCheckpointConnector;
import org.apache.kafka.connect.mirror.MirrorCheckpointTaskConfig;

class MirrorCheckpointMetrics
implements AutoCloseable {
    private static final String CHECKPOINT_CONNECTOR_GROUP = MirrorCheckpointConnector.class.getSimpleName();
    private static final Set<String> GROUP_TAGS = new HashSet<String>(Arrays.asList("source", "target", "group", "topic", "partition"));
    private static final MetricNameTemplate CHECKPOINT_LATENCY = new MetricNameTemplate("checkpoint-latency-ms", CHECKPOINT_CONNECTOR_GROUP, "Time it takes consumer group offsets to replicate from source to target cluster.", GROUP_TAGS);
    private static final MetricNameTemplate CHECKPOINT_LATENCY_MAX = new MetricNameTemplate("checkpoint-latency-ms-max", CHECKPOINT_CONNECTOR_GROUP, "Max time it takes consumer group offsets to replicate from source to target cluster.", GROUP_TAGS);
    private static final MetricNameTemplate CHECKPOINT_LATENCY_MIN = new MetricNameTemplate("checkpoint-latency-ms-min", CHECKPOINT_CONNECTOR_GROUP, "Min time it takes consumer group offsets to replicate from source to target cluster.", GROUP_TAGS);
    private static final MetricNameTemplate CHECKPOINT_LATENCY_AVG = new MetricNameTemplate("checkpoint-latency-ms-avg", CHECKPOINT_CONNECTOR_GROUP, "Average time it takes consumer group offsets to replicate from source to target cluster.", GROUP_TAGS);
    private final Metrics metrics;
    private final Map<String, GroupMetrics> groupMetrics = new HashMap<String, GroupMetrics>();
    private final String source;
    private final String target;

    MirrorCheckpointMetrics(MirrorCheckpointTaskConfig taskConfig) {
        this.target = taskConfig.targetClusterAlias();
        this.source = taskConfig.sourceClusterAlias();
        this.metrics = new Metrics();
        this.metrics.sensor("record-count");
        this.metrics.sensor("byte-rate");
        this.metrics.sensor("record-age");
        this.metrics.sensor("replication-latency");
    }

    @Override
    public void close() {
        this.metrics.close();
    }

    void checkpointLatency(TopicPartition topicPartition, String group, long millis) {
        this.group((TopicPartition)topicPartition, (String)group).checkpointLatencySensor.record((double)millis);
    }

    GroupMetrics group(TopicPartition topicPartition, String group) {
        return this.groupMetrics.computeIfAbsent(String.join((CharSequence)"-", topicPartition.toString(), group), x -> new GroupMetrics(topicPartition, group));
    }

    void addReporter(MetricsReporter reporter) {
        this.metrics.addReporter(reporter);
    }

    private class GroupMetrics {
        private final Sensor checkpointLatencySensor;

        GroupMetrics(TopicPartition topicPartition, String group) {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("source", MirrorCheckpointMetrics.this.source);
            tags.put("target", MirrorCheckpointMetrics.this.target);
            tags.put("group", group);
            tags.put("topic", topicPartition.topic());
            tags.put("partition", Integer.toString(topicPartition.partition()));
            this.checkpointLatencySensor = MirrorCheckpointMetrics.this.metrics.sensor("checkpoint-latency");
            this.checkpointLatencySensor.add(MirrorCheckpointMetrics.this.metrics.metricInstance(CHECKPOINT_LATENCY, tags), (MeasurableStat)new Value());
            this.checkpointLatencySensor.add(MirrorCheckpointMetrics.this.metrics.metricInstance(CHECKPOINT_LATENCY_MAX, tags), (MeasurableStat)new Max());
            this.checkpointLatencySensor.add(MirrorCheckpointMetrics.this.metrics.metricInstance(CHECKPOINT_LATENCY_MIN, tags), (MeasurableStat)new Min());
            this.checkpointLatencySensor.add(MirrorCheckpointMetrics.this.metrics.metricInstance(CHECKPOINT_LATENCY_AVG, tags), (MeasurableStat)new Avg());
        }
    }
}

