/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.owasp.html.Handler;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;

public class SlashdotPolicyExample {
    public static final Function<HtmlStreamEventReceiver, HtmlSanitizer.Policy> POLICY_DEFINITION = new HtmlPolicyBuilder().allowStandardUrlProtocols().allowAttributes("title").globally().allowAttributes("href").onElements("a").requireRelNofollowOnLinks().allowAttributes("lang").matching(Pattern.compile("[a-zA-Z]{2,20}")).globally().allowAttributes("align").matching(true, "center", "left", "right", "justify", "char").onElements("p").allowElements("a", "p", "div", "i", "b", "em", "blockquote", "tt", "strong", "br", "ul", "ol", "li").allowElements("quote", "ecode").toFactory();

    public static void main(String[] args) throws IOException {
        if (args.length != 0) {
            System.err.println("Reads from STDIN and writes to STDOUT");
            System.exit(-1);
        }
        System.err.println("[Reading from STDIN]");
        String html = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        HtmlStreamRenderer renderer = HtmlStreamRenderer.create(System.out, (Handler<? super IOException>)new Handler<IOException>(){

            @Override
            public void handle(IOException ex) {
                throw new AssertionError(null, ex);
            }
        }, (Handler<? super String>)new Handler<String>(){

            @Override
            public void handle(String x) {
                throw new AssertionError((Object)x);
            }
        });
        HtmlSanitizer.sanitize(html, POLICY_DEFINITION.apply(renderer));
    }
}

