/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.InstrumenterVertxTracer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.spi.tracing.TagExtractor;

public class EventBusInstrumenterVertxTracer
implements InstrumenterVertxTracer<Message, Message> {
    private final Instrumenter<Message, Message> consumerInstrumenter;
    private final Instrumenter<Message, Message> producerInstrumenter;

    public EventBusInstrumenterVertxTracer(OpenTelemetry openTelemetry, OTelRuntimeConfig runtimeConfig) {
        this.consumerInstrumenter = EventBusInstrumenterVertxTracer.getConsumerInstrumenter(openTelemetry, runtimeConfig);
        this.producerInstrumenter = EventBusInstrumenterVertxTracer.getProducerInstrumenter(openTelemetry, runtimeConfig);
    }

    @Override
    public <R> boolean canHandle(R request, TagExtractor<R> tagExtractor) {
        return request instanceof Message;
    }

    @Override
    public Instrumenter<Message, Message> getReceiveRequestInstrumenter() {
        return this.consumerInstrumenter;
    }

    @Override
    public Instrumenter<Message, Message> getSendResponseInstrumenter() {
        return this.consumerInstrumenter;
    }

    @Override
    public Instrumenter<Message, Message> getSendRequestInstrumenter() {
        return this.producerInstrumenter;
    }

    @Override
    public Instrumenter<Message, Message> getReceiveResponseInstrumenter() {
        return this.producerInstrumenter;
    }

    private static Instrumenter<Message, Message> getConsumerInstrumenter(OpenTelemetry openTelemetry, OTelRuntimeConfig runtimeConfig) {
        InstrumenterBuilder serverBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)EventBusAttributesGetter.INSTANCE, (MessageOperation)MessageOperation.RECEIVE));
        serverBuilder.setEnabled(!runtimeConfig.sdkDisabled());
        return serverBuilder.addAttributesExtractor(MessagingAttributesExtractor.create((MessagingAttributesGetter)EventBusAttributesGetter.INSTANCE, (MessageOperation)MessageOperation.RECEIVE)).buildConsumerInstrumenter((TextMapGetter)new TextMapGetter<Message>(){

            public Iterable<String> keys(Message message) {
                return message.headers().names();
            }

            public String get(Message message, String key) {
                if (message == null) {
                    return null;
                }
                return message.headers().get(key);
            }
        });
    }

    private static Instrumenter<Message, Message> getProducerInstrumenter(OpenTelemetry openTelemetry, OTelRuntimeConfig runtimeConfig) {
        InstrumenterBuilder serverBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)EventBusAttributesGetter.INSTANCE, (MessageOperation)MessageOperation.PUBLISH));
        serverBuilder.setEnabled(!runtimeConfig.sdkDisabled());
        return serverBuilder.addAttributesExtractor(MessagingAttributesExtractor.create((MessagingAttributesGetter)EventBusAttributesGetter.INSTANCE, (MessageOperation)MessageOperation.PUBLISH)).buildProducerInstrumenter((message, key, value) -> {
            if (message != null) {
                message.headers().set(key, value);
            }
        });
    }

    private static enum EventBusAttributesGetter implements MessagingAttributesGetter<Message, Message>
    {
        INSTANCE;


        public String getSystem(Message message) {
            return "vert.x";
        }

        public String getDestination(Message message) {
            return message.address();
        }

        public String getDestinationTemplate(Message message) {
            return "";
        }

        public boolean isTemporaryDestination(Message message) {
            return false;
        }

        public boolean isAnonymousDestination(Message message) {
            return false;
        }

        public String getConversationId(Message message) {
            return message.replyAddress();
        }

        public Long getMessageBodySize(Message message) {
            return 0L;
        }

        public Long getMessageEnvelopeSize(Message message) {
            return 0L;
        }

        public String getMessageId(Message message, Message message2) {
            return null;
        }

        public String getClientId(Message message) {
            return "";
        }

        public Long getBatchMessageCount(Message message, Message message2) {
            return 0L;
        }
    }
}

