/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.reflection.ReflectionBeanFactoryCreator;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.multipart.FileDownload;
import org.jboss.resteasy.reactive.server.NoopCloseAndFlushOutputStream;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartOutputInjectionTarget;
import org.jboss.resteasy.reactive.server.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.reactive.server.multipart.PartItem;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class MultipartMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    private static final String DOUBLE_DASH = "--";
    private static final String LINE_SEPARATOR = "\r\n";
    private static final String BOUNDARY_PARAM = "boundary";

    public void writeTo(Object o, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException, WebApplicationException {
        this.writeMultiformData(o, mediaType, outputStream);
    }

    @Override
    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        this.writeMultiformData(o, context.getResponseMediaType(), context.getOrCreateOutputStream());
    }

    public static final String getGeneratedMapperClassNameFor(String className) {
        return className + "_generated_mapper";
    }

    private void writeMultiformData(Object o, MediaType mediaType, OutputStream outputStream) throws IOException {
        ResteasyReactiveRequestContext requestContext = CurrentRequestManager.get();
        String boundary = this.generateBoundary();
        this.appendBoundaryIntoMediaType(requestContext, boundary, mediaType);
        MultipartFormDataOutput formData = o instanceof MultipartFormDataOutput ? (MultipartFormDataOutput)o : this.toFormData(o);
        this.write(formData, boundary, outputStream, requestContext);
    }

    private MultipartFormDataOutput toFormData(Object o) {
        String transformer = MultipartMessageBodyWriter.getGeneratedMapperClassNameFor(o.getClass().getName());
        BeanFactory.BeanInstance instance = new ReflectionBeanFactoryCreator().apply(transformer).createInstance();
        return ((MultipartOutputInjectionTarget)instance.getInstance()).mapFrom(o);
    }

    private void write(MultipartFormDataOutput formDataOutput, String boundary, OutputStream outputStream, ResteasyReactiveRequestContext requestContext) throws IOException {
        Charset charset = requestContext.getDeployment().getRuntimeConfiguration().body().defaultCharset();
        String boundaryLine = DOUBLE_DASH + boundary;
        Map<String, List<PartItem>> parts = formDataOutput.getAllFormData();
        for (Map.Entry<String, List<PartItem>> entry : parts.entrySet()) {
            String partName = entry.getKey();
            List<PartItem> partItems = entry.getValue();
            if (partItems.isEmpty()) continue;
            for (PartItem part : partItems) {
                Object partValue = part.getEntity();
                if (partValue == null) continue;
                if (this.isListOf(part, File.class) || this.isListOf(part, FileDownload.class)) {
                    List list = (List)partValue;
                    for (int i = 0; i < list.size(); ++i) {
                        this.writePart(partName, list.get(i), part, boundaryLine, charset, outputStream, requestContext);
                    }
                    continue;
                }
                this.writePart(partName, partValue, part, boundaryLine, charset, outputStream, requestContext);
            }
        }
        this.write(outputStream, boundaryLine + DOUBLE_DASH, charset);
    }

    private void writePart(String partName, Object partValue, PartItem part, String boundaryLine, Charset charset, OutputStream outputStream, ResteasyReactiveRequestContext requestContext) throws IOException {
        MediaType partType = part.getMediaType();
        if (partValue instanceof FileDownload) {
            FileDownload fileDownload = (FileDownload)partValue;
            partValue = fileDownload.filePath().toFile();
            partName = this.isNotEmpty(fileDownload.name()) ? fileDownload.name() : partName;
            partType = this.isNotEmpty(fileDownload.contentType()) ? MediaType.valueOf((String)fileDownload.contentType()) : partType;
            charset = this.isNotEmpty(fileDownload.charSet()) ? Charset.forName(fileDownload.charSet()) : charset;
        }
        this.writeLine(outputStream, boundaryLine, charset);
        this.writeHeaders(partName, partValue, part, charset, outputStream);
        this.writeLine(outputStream, charset);
        this.writeEntity(outputStream, partValue, partType, requestContext);
        this.writeLine(outputStream, charset);
    }

    private void writeHeaders(String partName, Object partValue, PartItem part, Charset charset, OutputStream outputStream) throws IOException {
        part.getHeaders().put((Object)"Content-Disposition", List.of("form-data; name=\"" + partName + "\"" + this.getFileNameIfFile(partValue, part.getFilename())));
        part.getHeaders().put((Object)"Content-Type", List.of(part.getMediaType()));
        for (Map.Entry entry : part.getHeaders().entrySet()) {
            this.writeLine(outputStream, (String)entry.getKey() + ": " + ((List)entry.getValue()).stream().map(String::valueOf).collect(Collectors.joining("; ")), charset);
        }
    }

    private String getFileNameIfFile(Object value, String partFileName) {
        if (value instanceof File) {
            return "; filename=\"" + ((File)value).getName() + "\"";
        }
        if (value instanceof FileDownload) {
            return "; filename=\"" + ((FileDownload)value).fileName() + "\"";
        }
        if (partFileName != null) {
            return "; filename=\"" + partFileName + "\"";
        }
        return "";
    }

    private void writeLine(OutputStream os, String text, Charset defaultCharset) throws IOException {
        this.write(os, text, defaultCharset);
        this.writeLine(os, defaultCharset);
    }

    private void write(OutputStream os, String text, Charset defaultCharset) throws IOException {
        this.write(os, text.getBytes(defaultCharset));
    }

    private void write(OutputStream os, byte[] bytes) throws IOException {
        os.write(bytes);
    }

    private void writeLine(OutputStream os, Charset defaultCharset) throws IOException {
        os.write(LINE_SEPARATOR.getBytes(defaultCharset));
    }

    private void writeEntity(OutputStream os, Object entity, MediaType mediaType, ResteasyReactiveRequestContext context) throws IOException {
        ServerSerialisers serializers = context.getDeployment().getSerialisers();
        Class<?> entityClass = entity.getClass();
        Type entityType = null;
        MessageBodyWriter<?>[] writers = serializers.findWriters(null, entityClass, mediaType, RuntimeType.SERVER).toArray(ServerSerialisers.NO_WRITER);
        boolean wrote = false;
        for (MessageBodyWriter<?> writer : writers) {
            if (!writer.isWriteable(entityClass, entityType, Serialisers.NO_ANNOTATION, mediaType)) continue;
            try (NoopCloseAndFlushOutputStream writerOutput = new NoopCloseAndFlushOutputStream(os);){
                writer.writeTo(entity, entityClass, entityType, Serialisers.NO_ANNOTATION, mediaType, (MultivaluedMap)new QuarkusMultivaluedHashMap(), (OutputStream)writerOutput);
                wrote = true;
                break;
            }
        }
        if (!wrote) {
            throw new IllegalStateException("Could not find MessageBodyWriter for " + String.valueOf(entityClass) + " as " + String.valueOf(mediaType));
        }
    }

    private String generateBoundary() {
        return UUID.randomUUID().toString();
    }

    private void appendBoundaryIntoMediaType(ResteasyReactiveRequestContext requestContext, String boundary, MediaType mediaType) {
        MediaType mediaTypeWithBoundary = new MediaType(mediaType.getType(), mediaType.getSubtype(), Collections.singletonMap(BOUNDARY_PARAM, boundary));
        requestContext.setResponseContentType(mediaTypeWithBoundary);
        requestContext.serverResponse().setResponseHeader((CharSequence)"Content-Type", mediaTypeWithBoundary.toString());
        if (requestContext.getResponse().isCreated()) {
            requestContext.getResponse().get().getHeaders().remove((Object)"Content-Type");
        }
    }

    private boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    private boolean isListOf(PartItem part, Class<?> paramType) {
        if (!(part.getEntity() instanceof Collection)) {
            return false;
        }
        return paramType.getName().equals(part.getGenericType());
    }
}

