/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ContainerRequestContextImpl
implements ResteasyReactiveContainerRequestContext {
    private final ResteasyReactiveRequestContext quarkusRestContext;
    private boolean aborted;
    private boolean preMatch;
    private boolean response;

    public ContainerRequestContextImpl(ResteasyReactiveRequestContext requestContext) {
        this.quarkusRestContext = requestContext;
    }

    public Object getProperty(String name) {
        return this.quarkusRestContext.getProperty(name);
    }

    public Collection<String> getPropertyNames() {
        return this.quarkusRestContext.getPropertyNames();
    }

    public void setProperty(String name, Object object) {
        this.quarkusRestContext.setProperty(name, object);
    }

    public void removeProperty(String name) {
        this.quarkusRestContext.removeProperty(name);
    }

    public UriInfo getUriInfo() {
        return this.quarkusRestContext.getUriInfo();
    }

    public void setRequestUri(URI requestUri) {
        this.setRequestUri(this.getUriInfo().getBaseUri(), requestUri);
    }

    public void setRequestUri(URI baseUri, URI requestUri) {
        this.assertPreMatch();
        this.quarkusRestContext.setRequestUri(baseUri.resolve(requestUri));
    }

    public Request getRequest() {
        return this.quarkusRestContext.getRequest();
    }

    public String getMethod() {
        return this.quarkusRestContext.getMethod();
    }

    public void setMethod(String method) {
        this.assertPreMatch();
        this.quarkusRestContext.setMethod(method);
    }

    public void assertPreMatch() {
        if (!this.isPreMatch()) {
            throw new IllegalStateException("Can only be called from a @PreMatch filter");
        }
    }

    public void assertNotResponse() {
        if (this.isResponse()) {
            throw new IllegalStateException("Cannot be called from response filter");
        }
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.quarkusRestContext.getHttpHeaders().getMutableHeaders();
    }

    public String getHeaderString(String name) {
        return this.quarkusRestContext.getHttpHeaders().getHeaderString(name);
    }

    public Date getDate() {
        return this.quarkusRestContext.getHttpHeaders().getDate();
    }

    public Locale getLanguage() {
        return this.quarkusRestContext.getHttpHeaders().getLanguage();
    }

    public int getLength() {
        return this.quarkusRestContext.getHttpHeaders().getLength();
    }

    public MediaType getMediaType() {
        return this.quarkusRestContext.getHttpHeaders().getMediaType();
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.quarkusRestContext.getHttpHeaders().getAcceptableMediaTypes();
    }

    public List<Locale> getAcceptableLanguages() {
        return this.quarkusRestContext.getHttpHeaders().getAcceptableLanguages();
    }

    public Map<String, Cookie> getCookies() {
        return this.quarkusRestContext.getHttpHeaders().getCookies();
    }

    public boolean hasEntity() {
        return this.getMediaType() != null;
    }

    public InputStream getEntityStream() {
        return this.quarkusRestContext.getInputStream();
    }

    public void setEntityStream(InputStream input) {
        this.assertNotResponse();
        this.quarkusRestContext.setInputStream(input);
    }

    public SecurityContext getSecurityContext() {
        return this.quarkusRestContext.getSecurityContext();
    }

    public void setSecurityContext(SecurityContext context) {
        this.assertNotResponse();
        this.quarkusRestContext.setSecurityContext(context);
    }

    public boolean isPreMatch() {
        return this.preMatch;
    }

    public ContainerRequestContextImpl setPreMatch(boolean preMatch) {
        this.preMatch = preMatch;
        return this;
    }

    public void abortWith(Response response) {
        this.assertNotResponse();
        this.quarkusRestContext.setResult(response);
        this.quarkusRestContext.setAbortHandlerChainStarted(true);
        this.quarkusRestContext.restart((ServerRestHandler[])this.quarkusRestContext.getAbortHandlerChain(), true);
        this.aborted = true;
        if (this.quarkusRestContext.isSuspended()) {
            this.quarkusRestContext.resume();
        }
    }

    public boolean isResponse() {
        return this.response;
    }

    public ContainerRequestContextImpl setResponse(boolean response) {
        this.response = response;
        return this;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public ServerRequestContext getServerRequestContext() {
        return this.quarkusRestContext;
    }

    @Override
    public void suspend() {
        this.quarkusRestContext.suspend();
    }

    @Override
    public void resume() {
        this.quarkusRestContext.resume();
    }

    @Override
    public void resume(Throwable t) {
        this.quarkusRestContext.resume(t);
    }
}

