/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import com.sun.management.GarbageCollectionNotificationInfo;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import io.opentelemetry.semconv.JvmAttributes;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public final class GarbageCollector {
    private static final Logger logger = Logger.getLogger(GarbageCollector.class.getName());
    private static final double MILLIS_PER_S = TimeUnit.SECONDS.toMillis(1L);
    static final List<Double> GC_DURATION_BUCKETS = Collections.unmodifiableList(Arrays.asList(0.01, 0.1, 1.0, 10.0));
    private static final NotificationFilter GC_FILTER = notification -> notification.getType().equals("com.sun.management.gc.notification");

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        if (!GarbageCollector.isNotificationClassPresent()) {
            logger.fine("The com.sun.management.GarbageCollectionNotificationInfo class is not available; GC metrics will not be reported.");
            return Collections.emptyList();
        }
        return GarbageCollector.registerObservers(openTelemetry, ManagementFactory.getGarbageCollectorMXBeans(), GarbageCollector::extractNotificationInfo);
    }

    static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, List<GarbageCollectorMXBean> gcBeans, Function<Notification, GarbageCollectionNotificationInfo> notificationInfoExtractor) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        DoubleHistogram gcDuration = meter.histogramBuilder("jvm.gc.duration").setDescription("Duration of JVM garbage collection actions.").setUnit("s").setExplicitBucketBoundariesAdvice(GC_DURATION_BUCKETS).build();
        ArrayList<AutoCloseable> result = new ArrayList<AutoCloseable>();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            if (!(gcBean instanceof NotificationEmitter)) continue;
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)gcBean);
            GcNotificationListener listener = new GcNotificationListener(gcDuration, notificationInfoExtractor);
            notificationEmitter.addNotificationListener(listener, GC_FILTER, null);
            result.add(() -> notificationEmitter.removeNotificationListener(listener));
        }
        return result;
    }

    private static GarbageCollectionNotificationInfo extractNotificationInfo(Notification notification) {
        return GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
    }

    private static boolean isNotificationClassPresent() {
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, GarbageCollectorMXBean.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private GarbageCollector() {
    }

    private static final class GcNotificationListener
    implements NotificationListener {
        private final DoubleHistogram gcDuration;
        private final Function<Notification, GarbageCollectionNotificationInfo> notificationInfoExtractor;

        private GcNotificationListener(DoubleHistogram gcDuration, Function<Notification, GarbageCollectionNotificationInfo> notificationInfoExtractor) {
            this.gcDuration = gcDuration;
            this.notificationInfoExtractor = notificationInfoExtractor;
        }

        @Override
        public void handleNotification(Notification notification, Object unused) {
            GarbageCollectionNotificationInfo notificationInfo = this.notificationInfoExtractor.apply(notification);
            String gcName = notificationInfo.getGcName();
            String gcAction = notificationInfo.getGcAction();
            double duration = (double)notificationInfo.getGcInfo().getDuration() / MILLIS_PER_S;
            this.gcDuration.record(duration, Attributes.of((AttributeKey)JvmAttributes.JVM_GC_NAME, (Object)gcName, (AttributeKey)JvmAttributes.JVM_GC_ACTION, (Object)gcAction));
        }
    }
}

