//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_MESH_TOPOLOGY_SCHEMA_H
#define PXR_IMAGING_HD_MESH_TOPOLOGY_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"
#include "pxr/imaging/hd/subdivisionTagsSchema.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_MESH_TOPOLOGY_SCHEMA_TOKENS \
    (topology) \
    (faceVertexCounts) \
    (faceVertexIndices) \
    (holeIndices) \
    (orientation) \
    (leftHanded) \
    (rightHanded) \

TF_DECLARE_PUBLIC_TOKENS(HdMeshTopologySchemaTokens, HD_API,
    HD_MESH_TOPOLOGY_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class HdMeshTopologySchema
///
class HdMeshTopologySchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdMeshTopologySchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "topology" from the parent container and constructs a
    /// HdMeshTopologySchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdMeshTopologySchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HD_API
    HdIntArrayDataSourceHandle GetFaceVertexCounts() const;

    HD_API
    HdIntArrayDataSourceHandle GetFaceVertexIndices() const;

    HD_API
    HdIntArrayDataSourceHandle GetHoleIndices() const;

    HD_API
    HdTokenDataSourceHandle GetOrientation() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdIntArrayDataSourceHandle &faceVertexCounts,
        const HdIntArrayDataSourceHandle &faceVertexIndices,
        const HdIntArrayDataSourceHandle &holeIndices,
        const HdTokenDataSourceHandle &orientation
    );

    /// \class HdMeshTopologySchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetFaceVertexCounts(
            const HdIntArrayDataSourceHandle &faceVertexCounts);
        HD_API
        Builder &SetFaceVertexIndices(
            const HdIntArrayDataSourceHandle &faceVertexIndices);
        HD_API
        Builder &SetHoleIndices(
            const HdIntArrayDataSourceHandle &holeIndices);
        HD_API
        Builder &SetOrientation(
            const HdTokenDataSourceHandle &orientation);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdIntArrayDataSourceHandle _faceVertexCounts;
        HdIntArrayDataSourceHandle _faceVertexIndices;
        HdIntArrayDataSourceHandle _holeIndices;
        HdTokenDataSourceHandle _orientation;

    };

    /// Returns token data source for use as orientation value.
    ///
    /// The following values will be stored statically and reused for future
    /// calls:
    /// - HdMeshTopologySchemaTokens->leftHanded
    /// - HdMeshTopologySchemaTokens->rightHanded
    HD_API
    static HdTokenDataSourceHandle BuildOrientationDataSource(
        const TfToken &orientation);

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif