﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appstream/AppStreamRequest.h>
#include <aws/appstream/AppStream_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AppStream {
namespace Model {

/**
 */
class DisassociateFleetRequest : public AppStreamRequest {
 public:
  AWS_APPSTREAM_API DisassociateFleetRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DisassociateFleet"; }

  AWS_APPSTREAM_API Aws::String SerializePayload() const override;

  AWS_APPSTREAM_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the fleet.</p>
   */
  inline const Aws::String& GetFleetName() const { return m_fleetName; }
  inline bool FleetNameHasBeenSet() const { return m_fleetNameHasBeenSet; }
  template <typename FleetNameT = Aws::String>
  void SetFleetName(FleetNameT&& value) {
    m_fleetNameHasBeenSet = true;
    m_fleetName = std::forward<FleetNameT>(value);
  }
  template <typename FleetNameT = Aws::String>
  DisassociateFleetRequest& WithFleetName(FleetNameT&& value) {
    SetFleetName(std::forward<FleetNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the stack.</p>
   */
  inline const Aws::String& GetStackName() const { return m_stackName; }
  inline bool StackNameHasBeenSet() const { return m_stackNameHasBeenSet; }
  template <typename StackNameT = Aws::String>
  void SetStackName(StackNameT&& value) {
    m_stackNameHasBeenSet = true;
    m_stackName = std::forward<StackNameT>(value);
  }
  template <typename StackNameT = Aws::String>
  DisassociateFleetRequest& WithStackName(StackNameT&& value) {
    SetStackName(std::forward<StackNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_fleetName;

  Aws::String m_stackName;
  bool m_fleetNameHasBeenSet = false;
  bool m_stackNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppStream
}  // namespace Aws
