﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/ConnectRequest.h>
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Connect {
namespace Model {

/**
 */
class DeleteViewRequest : public ConnectRequest {
 public:
  AWS_CONNECT_API DeleteViewRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteView"; }

  AWS_CONNECT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The identifier of the Amazon Connect instance. You can find the instanceId in
   * the ARN of the instance.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  DeleteViewRequest& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code>
   * can be used.</p>
   */
  inline const Aws::String& GetViewId() const { return m_viewId; }
  inline bool ViewIdHasBeenSet() const { return m_viewIdHasBeenSet; }
  template <typename ViewIdT = Aws::String>
  void SetViewId(ViewIdT&& value) {
    m_viewIdHasBeenSet = true;
    m_viewId = std::forward<ViewIdT>(value);
  }
  template <typename ViewIdT = Aws::String>
  DeleteViewRequest& WithViewId(ViewIdT&& value) {
    SetViewId(std::forward<ViewIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;

  Aws::String m_viewId;
  bool m_instanceIdHasBeenSet = false;
  bool m_viewIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
