/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.folders;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderState;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.xml.sax.Attributes;

class TabbedFoldersRegistry {
    private static final Log log = Log.getLog(TabbedFoldersRegistry.class);
    private static final String COLUMNS_CONFIG_FILE = "tabs_settings.xml";
    private static TabbedFoldersRegistry instance;
    private final Map<String, TabbedFolderState> savedStates = new HashMap<String, TabbedFolderState>();
    private volatile ConfigSaver saver = null;

    public static synchronized TabbedFoldersRegistry getInstance() {
        if (instance == null) {
            instance = new TabbedFoldersRegistry();
        }
        return instance;
    }

    public TabbedFoldersRegistry() {
        Path savedStates = DBWorkbench.getPlatform().getLocalConfigurationFile(COLUMNS_CONFIG_FILE);
        if (Files.exists(savedStates, new LinkOption[0])) {
            this.loadConfiguration(savedStates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    TabbedFolderState getFolderState(String objectId) {
        Map<String, TabbedFolderState> map = this.savedStates;
        synchronized (map) {
            TabbedFolderState folderState = this.savedStates.get(objectId);
            if (folderState == null) {
                folderState = new TabbedFolderState();
                this.savedStates.put(objectId, folderState);
            }
            return folderState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveConfig() {
        Map<String, TabbedFolderState> map = this.savedStates;
        synchronized (map) {
            if (this.saver == null) {
                this.saver = new ConfigSaver();
                this.saver.schedule(3000L);
            }
        }
    }

    private void loadConfiguration(Path configFile) {
        this.savedStates.clear();
        try (InputStream in = Files.newInputStream(configFile, new OpenOption[0]);){
            SAXReader parser = new SAXReader(in);
            FolderStateParser dsp = new FolderStateParser();
            parser.parse((SAXListener)dsp);
        }
        catch (Exception e) {
            log.error((Object)"Error loading columns configuration", (Throwable)e);
        }
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Tab folders configuration save");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            Map<String, TabbedFolderState> map = TabbedFoldersRegistry.this.savedStates;
            synchronized (map) {
                this.flushConfig();
                TabbedFoldersRegistry.this.saver = null;
            }
            return Status.OK_STATUS;
        }

        private void flushConfig() {
            Path configFile = DBWorkbench.getPlatform().getLocalConfigurationFile(TabbedFoldersRegistry.COLUMNS_CONFIG_FILE);
            try (OutputStream out = Files.newOutputStream(configFile, new OpenOption[0]);){
                XMLBuilder xml = new XMLBuilder(out, GeneralUtils.UTF8_ENCODING);
                xml.setBeautify(true);
                try (XMLBuilder.Element ignored = xml.startElement("folders");){
                    for (Map.Entry<String, TabbedFolderState> entry : TabbedFoldersRegistry.this.savedStates.entrySet()) {
                        XMLBuilder.Element ignored2 = xml.startElement("folder");
                        try {
                            xml.addAttribute("id", entry.getKey());
                            for (Map.Entry<String, TabbedFolderState.TabState> tab : entry.getValue().getTabStates().entrySet()) {
                                XMLBuilder.Element ignored3 = xml.startElement("tab");
                                try {
                                    xml.addAttribute("id", tab.getKey());
                                    xml.addAttribute("height", tab.getValue().height);
                                    xml.addAttribute("width", tab.getValue().width);
                                    xml.addAttribute("embedded", tab.getValue().embedded);
                                }
                                finally {
                                    if (ignored3 == null) continue;
                                    ignored3.close();
                                }
                            }
                        }
                        finally {
                            if (ignored2 == null) continue;
                            ignored2.close();
                        }
                    }
                }
                xml.flush();
            }
            catch (Exception e) {
                log.error((Object)"Error saving tabs configuration", (Throwable)e);
            }
        }
    }

    private class FolderStateParser
    extends SAXListener.BaseListener {
        private TabbedFolderState curTabbedFolderState = null;

        private FolderStateParser() {
        }

        public void saxStartElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName, @NotNull Attributes attributes) {
            switch (localName) {
                case "folders": {
                    break;
                }
                case "folder": {
                    this.curTabbedFolderState = new TabbedFolderState();
                    TabbedFoldersRegistry.this.savedStates.put(attributes.getValue("id"), this.curTabbedFolderState);
                    break;
                }
                case "tab": {
                    if (this.curTabbedFolderState == null) break;
                    TabbedFolderState.TabState tabState = new TabbedFolderState.TabState();
                    tabState.height = CommonUtils.toInt((Object)attributes.getValue("height"), (int)0);
                    tabState.width = CommonUtils.toInt((Object)attributes.getValue("width"), (int)0);
                    tabState.embedded = CommonUtils.toBoolean((Object)attributes.getValue("embedded"));
                    this.curTabbedFolderState.setTabState(attributes.getValue("id"), tabState);
                }
            }
        }
    }
}

