/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListControl;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListViewer;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewItem;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfigurationList;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;

public class DashboardItemViewDialog
extends AbstractPopupPanel {
    private static final String DIALOG_ID = "DBeaver.DashboardItemViewDialog";
    private final DashboardContainer parentPart;
    private final DashboardConfigurationList configuration;
    private final DashboardViewItem sourceItem;

    public DashboardItemViewDialog(DashboardContainer parentPart, DashboardConfigurationList configuration, DashboardViewItem sourceItem) {
        super(parentPart.getWorkbenchSite().getShell(), UIDashboardMessages.dialog_dashboard_item_view_title);
        this.parentPart = parentPart;
        this.configuration = configuration;
        this.sourceItem = sourceItem;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)UIDashboardActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite chartGroup = UIUtils.createPlaceholder((Composite)parent, (int)1);
        GridData gd = new GridData(1808);
        gd.widthHint = 450;
        gd.heightHint = 300;
        chartGroup.setLayoutData((Object)gd);
        chartGroup.setLayout((Layout)new FillLayout());
        DashboardListViewer dashboardListViewer = new DashboardListViewer(this.parentPart.getWorkbenchSite(), null, this.configuration, this.parentPart.getViewConfiguration());
        dashboardListViewer.setSingleChartMode(true);
        dashboardListViewer.createControl(chartGroup);
        DashboardViewItem targetItem = new DashboardViewItem((DashboardListControl)dashboardListViewer.getDefaultGroup(), this.sourceItem.getItemDescriptor());
        targetItem.moveViewFrom(this.sourceItem, false);
        this.closeOnFocusLost(new Control[]{dashboardListViewer.getControl(), chartGroup});
        return chartGroup;
    }

    protected Control createButtonBar(@NotNull Composite parent) {
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        UIUtils.asyncExec(() -> ((Button)okButton).setFocus());
    }
}

