/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTypeType;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructImpl;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeStatic;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.csv.CSVReaderBuilder;
import org.jkiss.utils.csv.CSVReaderNullFieldIndicator;
import org.jkiss.utils.csv.CSVWriter;

public class PostgreValueParser {
    private static final Log log = Log.getLog(PostgreValueParser.class);

    public static Object convertStringToValue(DBCSession session, DBSTypedObject arrayType, String string) throws DBCException {
        if (arrayType.getDataKind() == DBPDataKind.ARRAY) {
            if (string != null && string.startsWith("{") && string.endsWith("}")) {
                try {
                    return PostgreValueParser.prepareToParseArray(session, arrayType, string);
                }
                catch (Exception e) {
                    log.error((Object)("Array parsing failed " + e.getMessage()));
                    return string;
                }
            }
            return string;
        }
        if (CommonUtils.isEmpty((String)string)) {
            return PostgreValueParser.convertStringToSimpleValue(session, arrayType, string);
        }
        try {
            switch (arrayType.getTypeID()) {
                case 16: {
                    return string.length() > 0 && Character.toLowerCase(string.charAt(0)) == 't';
                }
                case -6: {
                    return Byte.parseByte(string);
                }
                case 5: {
                    return Short.parseShort(string);
                }
                case 4: {
                    return Integer.parseInt(string);
                }
                case -5: {
                    return Long.parseLong(string);
                }
                case 6: {
                    return Float.valueOf(Float.parseFloat(string));
                }
                case 2: 
                case 7: 
                case 8: {
                    return Double.parseDouble(string);
                }
            }
            return PostgreValueParser.convertStringToSimpleValue(session, arrayType, string);
        }
        catch (NumberFormatException e) {
            return string;
        }
    }

    private static Object prepareToParseArray(DBCSession session, DBSTypedObject arrayType, String string) throws DBCException {
        DBSDataType arrayDataType = arrayType instanceof DBSDataType ? (DBSDataType)arrayType : ((DBSTypedObjectEx)arrayType).getDataType();
        try {
            if (arrayDataType == null) {
                log.error((Object)("Can't get array type '" + arrayType.getFullTypeName() + "'"));
                return string;
            }
            Object componentType = arrayDataType.getComponentType(session.getProgressMonitor());
            if (componentType == null && arrayType instanceof PostgreDataType && ((PostgreDataType)arrayType).getTypeType() == PostgreTypeType.d) {
                componentType = ((PostgreDataType)arrayType).getBaseType(session.getProgressMonitor());
            }
            if (componentType == null) {
                log.error((Object)("Can't get component type from array '" + arrayType.getFullTypeName() + "'"));
                return string;
            }
            if (componentType instanceof PostgreDataType) {
                List<Object> itemStrings = PostgreValueParser.parseArrayString(string, PostgreUtils.getArrayDelimiter((DBSTypedObject)arrayDataType));
                return PostgreValueParser.startTransformListOfValuesIntoArray(session, (PostgreDataType)componentType, itemStrings);
            }
            log.error((Object)("Incorrect type '" + arrayType.getFullTypeName() + "'"));
            return string;
        }
        catch (Exception e) {
            if (e instanceof DBCException) {
                throw (DBCException)e;
            }
            throw new DBCException("Error parsing array '" + arrayType.getFullTypeName() + "' items", (Throwable)e);
        }
    }

    private static Object startTransformListOfValuesIntoArray(DBCSession session, PostgreDataType itemType, List<?> list) throws DBException {
        return PostgreValueParser.transformListOfValuesIntoArray(session, itemType, list, true);
    }

    private static Object transformListOfValuesIntoArray(DBCSession session, PostgreDataType itemType, List<?> list, boolean firstAttempt) throws DBException {
        Object[] values = new Object[list.size()];
        for (int index = 0; index < list.size(); ++index) {
            Object item = list.get(index);
            if (!(item instanceof List)) {
                Object[] itemValues = new Object[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    itemValues[i] = PostgreValueParser.convertStringToValue(session, (DBSTypedObject)itemType, (String)list.get(i));
                }
                if (firstAttempt) {
                    return itemValues;
                }
                return new JDBCCollection(session.getProgressMonitor(), (DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), itemValues);
            }
            Object parsedValue = itemType.getDataKind() == DBPDataKind.STRUCT ? PostgreValueParser.transformListOfValuesIntoStruct(session, itemType, (List)item) : PostgreValueParser.transformListOfValuesIntoArray(session, itemType, (List)item, false);
            values[index] = parsedValue;
        }
        if (firstAttempt) {
            return values;
        }
        return new JDBCCollection(session.getProgressMonitor(), (DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), values);
    }

    private static Object transformListOfValuesIntoStruct(DBCSession session, PostgreDataType itemType, List<?> list) throws DBException {
        List attributes = CommonUtils.safeList(itemType.getAttributes(session.getProgressMonitor()));
        Object[] itemValues = new Object[attributes.size()];
        if (list.size() == 1 && list.get(0) instanceof List) {
            list = (List)list.get(0);
        }
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item instanceof String) {
                itemValues[i] = PostgreValueParser.convertStringToValue(session, (DBSTypedObject)itemType, (String)item);
                continue;
            }
            if (item instanceof List) {
                if (((List)item).size() == 1) {
                    Object subItem = ((List)item).get(0);
                    if (subItem instanceof String) {
                        itemValues[i] = PostgreValueParser.convertStringToValue(session, (DBSTypedObject)itemType, (String)subItem);
                        continue;
                    }
                    log.debug((Object)("Invalid sub item type: " + subItem.getClass().getName()));
                    continue;
                }
                log.debug((Object)("Invalid struct list size: " + ((List)item).size()));
                continue;
            }
            log.debug((Object)("Invalid struct item type: " + String.valueOf(item)));
        }
        JDBCStructImpl contents = new JDBCStructImpl(itemType.getTypeName(), itemValues, list.toString());
        return new JDBCCompositeStatic(session, (DBSDataType)itemType, (Struct)contents);
    }

    private static Object convertStringToSimpleValue(DBCSession session, DBSTypedObject itemType, String string) throws DBCException {
        DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType);
        if (valueHandler != null) {
            return valueHandler.getValueFromObject(session, itemType, (Object)string, false, false);
        }
        return string;
    }

    public static String[] parseSingleObject(String string) throws DBCException {
        if (string.isEmpty()) {
            return new String[0];
        }
        try {
            return new CSVReaderBuilder((Reader)new StringReader(string)).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).build().readNext();
        }
        catch (IOException e) {
            throw new DBCException("Error parsing PGObject", (Throwable)e);
        }
    }

    public static String generateObjectString(Object[] values) {
        String[] line = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value instanceof DBDCollection) {
                value = ((DBDCollection)value).getRawValue();
            }
            if (value instanceof Object[]) {
                String arrayPostgreStyle;
                line[i] = arrayPostgreStyle = Arrays.deepToString((Object[])value).replace("[", "{").replace("]", "}").replace(" ", "");
                continue;
            }
            if (value instanceof JDBCComposite) {
                line[i] = PostgreValueParser.generateObjectString(((JDBCComposite)value).getValues());
                continue;
            }
            if (value == null) continue;
            line[i] = value.toString();
        }
        StringWriter out = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)out);
        writer.writeNext(line);
        try {
            writer.flush();
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
        return "(" + out.toString().trim() + ")";
    }

    public static List<Object> parseArrayString(String fieldString, String delimiter) throws DBCException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (CommonUtils.isEmpty((String)fieldString)) {
            return arrayList;
        }
        int dimensionsCount = 1;
        char delim = delimiter.charAt(0);
        if (fieldString != null) {
            int bracePairsCount = 0;
            char[] chars = fieldString.toCharArray();
            StringBuilder buffer = null;
            boolean insideString = false;
            boolean wasInsideString = false;
            ArrayList dims = new ArrayList();
            List<Object> curArray = arrayList;
            int startOffset = 0;
            if (chars[0] == '[') {
                while (chars[startOffset] != '=') {
                    ++startOffset;
                }
                ++startOffset;
            }
            for (int i = startOffset; i < chars.length; ++i) {
                if (chars[i] == '\\') {
                    ++i;
                } else {
                    if (!insideString && chars[i] == '{') {
                        if (dims.isEmpty()) {
                            dims.add(arrayList);
                        } else {
                            ArrayList a = new ArrayList();
                            List p = (List)dims.get(dims.size() - 1);
                            p.add(a);
                            dims.add(a);
                        }
                        ++bracePairsCount;
                        curArray = (List)dims.get(dims.size() - 1);
                        for (int t = i + 1; t < chars.length; ++t) {
                            if (Character.isWhitespace(chars[t])) continue;
                            if (chars[t] != '{') break;
                            ++dimensionsCount;
                        }
                        buffer = new StringBuilder();
                        continue;
                    }
                    if (chars[i] == '\"') {
                        insideString = !insideString;
                        wasInsideString = true;
                        continue;
                    }
                    if (!insideString && Character.isWhitespace(chars[i])) continue;
                    if (!insideString && (chars[i] == delim || chars[i] == '}') || i == chars.length - 1) {
                        String b;
                        if (chars[i] != '\"' && chars[i] != '}' && chars[i] != delim && buffer != null) {
                            buffer.append(chars[i]);
                        }
                        String string = b = buffer == null ? null : buffer.toString();
                        if (b != null && (!b.isEmpty() || wasInsideString)) {
                            curArray.add(!wasInsideString && b.equals("NULL") ? null : b);
                        }
                        wasInsideString = false;
                        buffer = new StringBuilder();
                        if (chars[i] != '}') continue;
                        if (dims.isEmpty()) {
                            throw new DBCException("Redundant trailing bracket in " + fieldString);
                        }
                        dims.remove(dims.size() - 1);
                        --bracePairsCount;
                        if (!dims.isEmpty()) {
                            curArray = (List)dims.get(dims.size() - 1);
                        }
                        buffer = null;
                        continue;
                    }
                }
                if (buffer == null) continue;
                buffer.append(chars[i]);
            }
            if (bracePairsCount != 0) {
                throw new DBCException("Amount of array's braces is not equal");
            }
        }
        return arrayList;
    }

    @NotNull
    public static <T> T[] parsePrimitiveArray(@NotNull String value, @NotNull Function<String, T> converter, @NotNull IntFunction<T[]> generator) {
        return PostgreValueParser.parsePrimitiveArray(value, converter, generator, ',');
    }

    @NotNull
    public static <T> T[] parsePrimitiveArray(@NotNull String value, @NotNull Function<String, T> converter, @NotNull IntFunction<T[]> generator, char delimiter) {
        int length = value.length();
        if (value.equals("{}")) {
            return generator.apply(0);
        }
        ArrayList<T> result = new ArrayList<T>();
        StringBuilder buffer = new StringBuilder();
        int offset = 0;
        State state = State.EXPECT_START;
        boolean wasQuoted = false;
        while (offset < length) {
            char ch = value.charAt(offset++);
            if (state == State.EXPECT_START) {
                if (ch != '{') {
                    throw new IllegalArgumentException("Array value must start with \"{\"");
                }
                state = State.MAYBE_VALUE;
                continue;
            }
            if (state == State.MAYBE_VALUE || state == State.EXPECT_VALUE) {
                String element;
                if (ch == '\"') {
                    state = State.INSIDE_QUOTES;
                    wasQuoted = true;
                    continue;
                }
                if (ch == '\\') {
                    buffer.append(value.charAt(offset++));
                    continue;
                }
                if (ch == '}') {
                    if (state == State.EXPECT_VALUE) {
                        throw new IllegalArgumentException("Unexpected \"}\" character");
                    }
                    element = buffer.toString();
                    if (!element.isEmpty()) {
                        if (!wasQuoted && element.equalsIgnoreCase("NULL")) {
                            result.add(null);
                        } else {
                            result.add(converter.apply(element));
                        }
                    }
                    buffer.setLength(0);
                    state = State.AFTER_END;
                    break;
                }
                if (ch == delimiter) {
                    element = buffer.toString();
                    if (!element.isEmpty()) {
                        if (!wasQuoted && element.equalsIgnoreCase("NULL")) {
                            result.add(null);
                        } else {
                            result.add(converter.apply(element));
                        }
                    } else {
                        throw new IllegalArgumentException("Unexpected \",\" character");
                    }
                    buffer.setLength(0);
                    state = State.EXPECT_VALUE;
                    wasQuoted = false;
                    continue;
                }
                if (!Character.isWhitespace(ch)) {
                    buffer.append(ch);
                }
                state = State.MAYBE_VALUE;
                continue;
            }
            if (ch == '\\') {
                buffer.append(value.charAt(offset++));
                continue;
            }
            if (ch == '\"') {
                state = State.MAYBE_VALUE;
                continue;
            }
            buffer.append(ch);
        }
        if (state != State.AFTER_END) {
            throw new IllegalArgumentException("Unexpected end of input");
        }
        if (offset < length) {
            throw new IllegalArgumentException("Junk after closing right brace");
        }
        return result.toArray(generator);
    }

    private static enum State {
        EXPECT_START,
        EXPECT_VALUE,
        MAYBE_VALUE,
        INSIDE_QUOTES,
        AFTER_END;

    }
}

