/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.markedj.extension.gfm.alert;

import io.github.gitbucket.markedj.Lexer;
import io.github.gitbucket.markedj.Parser;
import io.github.gitbucket.markedj.extension.Extension;
import io.github.gitbucket.markedj.extension.TokenConsumer;
import io.github.gitbucket.markedj.extension.gfm.alert.DefaultGFMAlertRenderer;
import io.github.gitbucket.markedj.extension.gfm.alert.GFMAlertEndToken;
import io.github.gitbucket.markedj.extension.gfm.alert.GFMAlertOptions;
import io.github.gitbucket.markedj.extension.gfm.alert.GFMAlertRenderer;
import io.github.gitbucket.markedj.extension.gfm.alert.GFMAlertStartToken;
import io.github.gitbucket.markedj.extension.gfm.alert.GFMAlerts;
import io.github.gitbucket.markedj.rule.FindFirstRule;
import io.github.gitbucket.markedj.rule.Rule;
import io.github.gitbucket.markedj.token.Token;
import java.util.List;
import java.util.function.Function;

public class GFMAlertExtension
implements Extension {
    public static String EXPRESSION = "(?s)(?m)\\A^> \\[!(NOTE|TIP|IMPORTANT|WARNING|CAUTION)\\](.+?)(^\n|\\Z)";
    private static final Rule RULE = new FindFirstRule(EXPRESSION);
    private GFMAlertRenderer renderer = new DefaultGFMAlertRenderer();
    private GFMAlertOptions options;

    public GFMAlertExtension() {
        this(new GFMAlertOptions());
    }

    public GFMAlertExtension(GFMAlertOptions options) {
        this.options = options;
    }

    public void setRenderer(GFMAlertRenderer renderer) {
        this.renderer = renderer;
    }

    public void setOptions(GFMAlertOptions options) {
        this.options = options;
    }

    @Override
    public Extension.LexResult lex(String source, Lexer.LexerContext context, TokenConsumer consumer) {
        List<String> cap = RULE.exec(source);
        boolean tokenFound = false;
        if (!cap.isEmpty()) {
            String allNotificationsLines = cap.get(0);
            String content = cap.get(2);
            content = content.replaceAll("(?m)^ *> ?", "");
            source = source.substring(allNotificationsLines.length());
            context.pushToken(new GFMAlertStartToken(cap.get(1)));
            consumer.token(content, false, false, context);
            context.pushToken(new GFMAlertEndToken());
            tokenFound = true;
        }
        return new Extension.LexResult(source, tokenFound);
    }

    @Override
    public boolean handlesToken(String token) {
        return GFMAlertStartToken.TYPE.equals(token);
    }

    @Override
    public String parse(Parser.ParserContext context, Function<Parser.ParserContext, String> tok) {
        Token n;
        GFMAlertStartToken t = (GFMAlertStartToken)context.currentToken();
        StringBuilder body = new StringBuilder();
        while ((n = context.nextToken()) != null && !n.getType().equals(GFMAlertEndToken.TYPE)) {
            body.append(tok.apply(context));
        }
        return this.render(body.toString(), t.getNotification());
    }

    private String render(String message, GFMAlerts.Alert alert) {
        return this.renderer.render(this.options, message, alert);
    }
}

