import { type DOMElement } from './dom.js';
import { type CharOffsetMap } from './measure-text.js';
export type { CharOffsetMap, CharOffsetRange } from './measure-text.js';
declare const squashTextNodes: (node: DOMElement) => string;
/**
 * Squash text nodes with character offset mapping.
 * This variant builds a CharOffsetMap that tracks the character position
 * of each DOM node within the squashed text, used for text selection.
 *
 * The character counting method matches getPositionAtOffset() in measure-text.ts,
 * ensuring consistent cursor and selection position calculations.
 */
export declare const squashTextNodesWithMap: (node: DOMElement, map: CharOffsetMap, offsetRef: {
    current: number;
}) => string;
export default squashTextNodes;
