/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.text;

import io.sf.carte.echosvg.ext.awt.color.ColorContext;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.color.ColorSpace;

public class TextPaintInfo {
    public boolean visible;
    public Paint fillPaint;
    public Paint strokePaint;
    public Stroke strokeStroke;
    public Composite composite;
    public Paint underlinePaint;
    public Paint underlineStrokePaint;
    public Stroke underlineStroke;
    public Paint overlinePaint;
    public Paint overlineStrokePaint;
    public Stroke overlineStroke;
    public Paint strikethroughPaint;
    public Paint strikethroughStrokePaint;
    public Stroke strikethroughStroke;
    public int startChar;
    public int endChar;
    private ColorContext context;

    public TextPaintInfo(ColorContext colorContext) {
        this.context = colorContext;
    }

    public TextPaintInfo(TextPaintInfo textPaintInfo) {
        this.set(textPaintInfo);
    }

    public void set(TextPaintInfo textPaintInfo) {
        if (textPaintInfo == null) {
            this.fillPaint = null;
            this.strokePaint = null;
            this.strokeStroke = null;
            this.composite = null;
            this.underlinePaint = null;
            this.underlineStrokePaint = null;
            this.underlineStroke = null;
            this.overlinePaint = null;
            this.overlineStrokePaint = null;
            this.overlineStroke = null;
            this.strikethroughPaint = null;
            this.strikethroughStrokePaint = null;
            this.strikethroughStroke = null;
            this.visible = false;
            this.context = null;
        } else {
            this.fillPaint = textPaintInfo.fillPaint;
            this.strokePaint = textPaintInfo.strokePaint;
            this.strokeStroke = textPaintInfo.strokeStroke;
            this.composite = textPaintInfo.composite;
            this.underlinePaint = textPaintInfo.underlinePaint;
            this.underlineStrokePaint = textPaintInfo.underlineStrokePaint;
            this.underlineStroke = textPaintInfo.underlineStroke;
            this.overlinePaint = textPaintInfo.overlinePaint;
            this.overlineStrokePaint = textPaintInfo.overlineStrokePaint;
            this.overlineStroke = textPaintInfo.overlineStroke;
            this.strikethroughPaint = textPaintInfo.strikethroughPaint;
            this.strikethroughStrokePaint = textPaintInfo.strikethroughStrokePaint;
            this.strikethroughStroke = textPaintInfo.strikethroughStroke;
            this.visible = textPaintInfo.visible;
            this.context = textPaintInfo.context;
        }
    }

    public Paint getFillPaint() {
        if (this.fillPaint instanceof Color) {
            Color color = (Color)this.fillPaint;
            ColorSpace colorSpace = color.getColorSpace();
            ColorSpace colorSpace2 = this.context.getColorSpace();
            if (colorSpace2 == null) {
                if (!colorSpace.isCS_sRGB()) {
                    float[] fArray = color.getRGBComponents(null);
                    color = new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
            } else {
                color = new Color(colorSpace2, color.getColorComponents(colorSpace2, null), (float)color.getAlpha() / 255.0f);
            }
            return color;
        }
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Paint paint) {
        this.strokePaint = paint;
    }

    public Paint getUnderlinePaint() {
        return this.underlinePaint;
    }

    public void setUnderlinePaint(Paint paint) {
        this.underlinePaint = paint;
    }

    public Paint getUnderlineStrokePaint() {
        return this.underlineStrokePaint;
    }

    public void setUnderlineStrokePaint(Paint paint) {
        this.underlineStrokePaint = paint;
    }

    public Paint getOverlinePaint() {
        return this.overlinePaint;
    }

    public void setOverlinePaint(Paint paint) {
        this.overlinePaint = paint;
    }

    public Paint getOverlineStrokePaint() {
        return this.overlineStrokePaint;
    }

    public void setOverlineStrokePaint(Paint paint) {
        this.overlineStrokePaint = paint;
    }

    public Paint getStrikethroughPaint() {
        return this.strikethroughPaint;
    }

    public void setStrikethroughPaint(Paint paint) {
        this.strikethroughPaint = paint;
    }

    public Paint getStrikethroughStrokePaint() {
        return this.strikethroughStrokePaint;
    }

    public void setStrikethroughStrokePaint(Paint paint) {
        this.strikethroughStrokePaint = paint;
    }

    public static boolean equivilent(TextPaintInfo textPaintInfo, TextPaintInfo textPaintInfo2) {
        if (textPaintInfo == null) {
            return textPaintInfo2 == null;
        }
        if (textPaintInfo2 == null) {
            return false;
        }
        if (textPaintInfo.fillPaint == null != (textPaintInfo2.fillPaint == null)) {
            return false;
        }
        if (textPaintInfo.visible != textPaintInfo2.visible) {
            return false;
        }
        boolean bl = textPaintInfo.strokePaint != null && textPaintInfo.strokeStroke != null;
        boolean bl2 = textPaintInfo2.strokePaint != null && textPaintInfo2.strokeStroke != null;
        return bl == bl2;
    }
}

