# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: ref.proto for package 'gitaly'

require 'grpc'
require 'ref_pb'

module Gitaly
  module RefService
    # RefService is a service that provides RPCs to list and modify Git references.
    class Service

      include ::GRPC::GenericService

      self.marshal_class_method = :encode
      self.unmarshal_class_method = :decode
      self.service_name = 'gitaly.RefService'

      # FindDefaultBranchName looks up the default branch reference name. Unless
      # otherwise specified the following heuristic is used:
      #
      # 1. If there are no branches, return an empty string.
      # 2. If there is only one branch, return the only branch.
      # 3. If a branch exists that matches HEAD, return the HEAD reference name.
      # 4. If a branch exists named refs/heads/main, return refs/heads/main.
      # 5. If a branch exists named refs/heads/master, return refs/heads/master.
      # 6. Return the first branch (as per default ordering by git).
      rpc :FindDefaultBranchName, ::Gitaly::FindDefaultBranchNameRequest, ::Gitaly::FindDefaultBranchNameResponse
      # FindLocalBranches finds all the local branches under `refs/heads/` for the specified repository.
      # The response is streamed back to the client to divide the list of branches into chunks.
      rpc :FindLocalBranches, ::Gitaly::FindLocalBranchesRequest, stream(::Gitaly::FindLocalBranchesResponse)
      # FindAllBranches finds all branches under `refs/heads/` and `refs/remotes/` for the specified repository.
      # The response is streamed back to the client to divide the list of branches into chunks.
      rpc :FindAllBranches, ::Gitaly::FindAllBranchesRequest, stream(::Gitaly::FindAllBranchesResponse)
      # FindAllTags finds all tags under `refs/tags/` for the specified repository.
      # The response is streamed back to the client to divide the list of tags into chunks.
      rpc :FindAllTags, ::Gitaly::FindAllTagsRequest, stream(::Gitaly::FindAllTagsResponse)
      # FindTag looks up a tag by its name and returns it to the caller if it exists. This RPC supports
      # both lightweight and annotated tags. Note: this RPC returns an `Internal` error if the tag was
      # not found.
      rpc :FindTag, ::Gitaly::FindTagRequest, ::Gitaly::FindTagResponse
      # FindAllRemoteBranches finds all the remote branches under `refs/remotes/` for the specified repository.
      # The response is streamed back to the client to divide the list of branches into chunks.
      rpc :FindAllRemoteBranches, ::Gitaly::FindAllRemoteBranchesRequest, stream(::Gitaly::FindAllRemoteBranchesResponse)
      # RefExists checks if the specified reference exists. The reference must be fully qualified.
      rpc :RefExists, ::Gitaly::RefExistsRequest, ::Gitaly::RefExistsResponse
      # FindBranch finds a branch by its unqualified name (like "master") and
      # returns the commit it currently points to.
      rpc :FindBranch, ::Gitaly::FindBranchRequest, ::Gitaly::FindBranchResponse
      # UpdateReferences atomically updates a set of references to a new state. This RPC allows creating
      # new references, deleting old references and updating existing references in a raceless way.
      #
      # Updating symbolic references with this RPC is not allowed.
      rpc :UpdateReferences, stream(::Gitaly::UpdateReferencesRequest), ::Gitaly::UpdateReferencesResponse
      # DeleteRefs deletes the specified references from its repository. Attempting to delete an
      # non-existent reference does not result in an error. It is recommended to instead use the
      # UpdateReferences RPC because it can delete references in a raceless manner via the expected old
      # object ID.
      rpc :DeleteRefs, ::Gitaly::DeleteRefsRequest, ::Gitaly::DeleteRefsResponse
      # ListBranchNamesContainingCommit finds all branches under `refs/heads/` that contain the specified commit.
      # The response is streamed back to the client to divide the list of branches into chunks.
      rpc :ListBranchNamesContainingCommit, ::Gitaly::ListBranchNamesContainingCommitRequest, stream(::Gitaly::ListBranchNamesContainingCommitResponse)
      # ListTagNamesContainingCommit finds all tags under `refs/tags/` that contain the specified commit.
      # The response is streamed back to the client to divide the list of tags into chunks.
      rpc :ListTagNamesContainingCommit, ::Gitaly::ListTagNamesContainingCommitRequest, stream(::Gitaly::ListTagNamesContainingCommitResponse)
      # GetTagSignatures returns signatures for annotated tags resolved from a set of revisions. Revisions
      # which don't resolve to an annotated tag are silently discarded. Revisions which cannot be resolved
      # result in an error. Tags which are annotated but not signed will return a TagSignature response
      # which has no signature, but its unsigned contents will still be returned.
      rpc :GetTagSignatures, ::Gitaly::GetTagSignaturesRequest, stream(::Gitaly::GetTagSignaturesResponse)
      # GetTagMessages returns tag messages for the annotated tags identified via the given revisions.
      # The response is streamed back to the client with a response message containing the tag ID
      # always preceding one or more messages containing the tag message contents. This is repeated for
      # all tags in the response.
      rpc :GetTagMessages, ::Gitaly::GetTagMessagesRequest, stream(::Gitaly::GetTagMessagesResponse)
      # ListRefs returns a stream of all references in the repository. By default, pseudo-revisions like HEAD
      # will not be returned by this RPC. Any symbolic references will be resolved to the object ID it is
      # pointing at.
      rpc :ListRefs, ::Gitaly::ListRefsRequest, stream(::Gitaly::ListRefsResponse)
      # FindRefsByOID returns an array of fully qualified reference names that point to an object ID.
      # It returns nothing if the object ID doesn't exist, or doesn't point to
      # any branches or tags. Prefixes can be also be used as the object ID.
      rpc :FindRefsByOID, ::Gitaly::FindRefsByOIDRequest, ::Gitaly::FindRefsByOIDResponse
    end

    Stub = Service.rpc_stub_class
  end
end
