---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: マージコンフリクトを理解し、Gitプロジェクトでそれらを修正する方法を学びます。
title: マージコンフリクト
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

マージコンフリクトは、マージリクエスト内の2つのブランチ（ソースブランチとターゲットブランチ）で、同じコード行に対して異なる変更が加えられている場合に発生します。ほとんどの場合、GitLabは変更をまとめてマージできますが、コンフリクトが発生した場合は、どちらの変更を保持するかを決定する必要があります。

![マージコンフリクトが原因でブロックされたマージリクエスト](img/conflicts_v16_7.png)

コンフリクトが発生したマージリクエストを解決するには、次のいずれかの操作を行う必要があります:

- マージコミットを作成します。
- リベースによってコンフリクトを解決します。

GitLabでは、ターゲットブランチにマージせずに、ソースブランチにマージコミットを作成することでコンフリクトを解決します。その後、マージコミットを確認およびテストし、意図しない変更が含まれていないこと、ビルドが壊れていないことを検証できます。

## コンフリクトブロックについて {#understand-conflict-blocks}

Gitがユーザーによる決定を必要とするコンフリクトを検出すると、コンフリクトマーカーでコンフリクトブロックの開始と終了がマークされます:

- `<<<<<<< HEAD`は、コンフリクトブロックの開始を示します。
- 変更内容が表示されます。
- `=======`は、変更内容の終了を示します。
- ターゲットブランチの最新の変更が表示されます。
- `>>>>>>>`は、コンフリクトの終了を示します。

コンフリクトを解決するには、以下を削除します:

1. 保持しないコンフリクトしている行のバージョン。
1. 3つのコンフリクトマーカー（開始、終了、2つのバージョン間の`=======`行）。

## UIで解決できるコンフリクト {#conflicts-you-can-resolve-in-the-user-interface}

コンフリクトしているファイルが次の条件を満たす場合、GitLabのUIでマージコンフリクトを解決できます:

- バイナリではないテキストファイルである。
- コンフリクトマーカーが追加された状態で、サイズが200 KiB未満である。
- UTF-8互換のエンコードを使用している。
- コンフリクトマーカーが含まれていない。
- 両方のブランチで同じパスに存在する。

ファイルがこれらの条件を満たしていない場合は、コンフリクトを手動で解決する必要があります。

## コンフリクトの解決方法 {#conflict-resolution-methods}

GitLabは、UIで[解決できるコンフリクト](#conflicts-you-can-resolve-in-the-user-interface)を表示します。次の方法でもコンフリクトを解決できます:

- インタラクティブモード: 保持する行のバージョンを選択するだけで済むコンフリクトに最適です。
- インラインエディタ: 手動編集で変更点を組み合わせる必要がある複雑なコンフリクトに適しています。
- コマンドライン: 複雑なコンフリクトを完全に制御できます。詳細については、[コマンドラインからコンフリクトを解決する](../../../topics/git/git_rebase.md#resolve-conflicts-from-the-command-line)を参照してください。

### インタラクティブモード {#interactive-mode}

インタラクティブモードでは、選択した変更を加えて、ターゲットブランチをソースブランチにマージします。

インタラクティブモードでマージコンフリクトを解決するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. **概要**を選択して、マージリクエストレポートセクションまでスクロールします。
1. マージコンフリクトメッセージを見つけ、**競合を解決**を選択します。GitLabに、マージコンフリクトがあるファイルの一覧が表示されます。コンフリクトしている行が強調表示されます。

1. コンフリクトごとに、**自分の変更を使用**または**相手の変更を使用**を選択して、保持するコンフリクトしている行のバージョンをマークします。この決定は「コンフリクトの解決」と呼ばれます。
1. すべてのコンフリクトを解決したら、**コミットメッセージ**を入力します。
1. **ソースブランチへのコミット**を選択します。

### インラインエディタ {#inline-editor}

一部のマージコンフリクトはより複雑であるため、行を手動で編集して解決する必要があります。

マージコンフリクト解決エディタは、GitLabでこれらのコンフリクトを解決するのに役立ちます:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. **概要**を選択して、マージリクエストレポートセクションまでスクロールします。
1. マージコンフリクトメッセージを見つけ、**競合を解決**を選択します。GitLabに、マージコンフリクトがあるファイルの一覧が表示されます。
1. 手動で編集するファイルを見つけ、コンフリクトブロックまでスクロールします。
1. そのファイルのヘッダーで、**インライン編集**を選択してエディタを開きます。この例では、コンフリクトブロックは1350行目で始まり、1356行目で終わります:

   ![マージコンフリクトエディタ](img/merge_conflict_editor_v16_7.png)

1. コンフリクトを解決したら、**コミットメッセージ**を入力します。
1. **ソースブランチへのコミット**を選択します。

## リベース {#rebase}

マージリクエストが`Checking ability to merge automatically`メッセージで停止している場合は、次の操作を実行できます:

- マージリクエストのコメントで、`/rebase`[クイックアクション](../quick_actions.md#issues-merge-requests-and-epics)を実行します。
- マージウィジェットで、**ソースブランチをrebase**を選択します。
- [Gitでリベース](../../../topics/git/git_rebase.md#rebase)。

CI/CDパイプラインの問題のトラブルシューティングについては、[CI/CDパイプラインのデバッグ](../../../ci/debugging.md)を参照してください。

### GitLab UIでのリベース {#rebase-in-the-gitlab-ui}

GitLab UIからリベースをトリガーするには、`/rebase`[クイックアクション](../quick_actions.md)またはマージリクエストウィジェットのリベースオプションを使用します。

前提要件:

- マージコンフリクトが存在しない。
- ソースプロジェクトに対する[デベロッパー](../../permissions.md)以上のロールが必要です。
- マージリクエストがフォークにある場合、フォークは[アップストリームプロジェクトのメンバーからの](allow_collaboration.md)コミットを許可する必要があります。

GitLab UIからマージリクエストのブランチをリベースするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. 次のいずれかの操作を行います:
   - **概要**タブで、マージリクエストウィジェットまでスクロールし、**ソースブランチをrebase**を選択します。
   - コメントで`/rebase`を入力し、**コメント**を選択します。

GitLabは、スケジュールを設定し、デフォルトブランチに対してブランチのリベースを実行します。GitLabは、完了したリベースをシステムノートとして表示します。

{{< alert type="note" >}}

GitLab UIを介して行われたコミットのコミット署名を設定している場合、[UIを介してリベースすると](../repository/signed_commits/web_commits.md#web-commits-become-unsigned-after-rebase)、ウェブコミットはそのコミット署名を失います。

{{< /alert >}}

## 関連トピック {#related-topics}

- [コンフリクトのリベースと解決](../../../topics/git/git_rebase.md)
- [Gitリベースと強制プッシュの概要](../../../topics/git/git_rebase.md)
- [Gitワークフローを視覚化するためのGitアプリケーション](https://git-scm.com/downloads/guis)
- [`git rerere`を使用した自動コンフリクト解決](https://git-scm.com/book/en/v2/Git-Tools-Rerere)
